/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.computeoptimizer.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.computeoptimizer.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * InstanceRecommendation JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class InstanceRecommendationJsonUnmarshaller implements Unmarshaller<InstanceRecommendation, JsonUnmarshallerContext> {

    public InstanceRecommendation unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstanceRecommendation instanceRecommendation = new InstanceRecommendation();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("instanceArn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setInstanceArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("accountId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setAccountId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("instanceName", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setInstanceName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("currentInstanceType", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setCurrentInstanceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("finding", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setFinding(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("findingReasonCodes", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setFindingReasonCodes(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("utilizationMetrics", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setUtilizationMetrics(new ListUnmarshaller<UtilizationMetric>(UtilizationMetricJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("lookBackPeriodInDays", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setLookBackPeriodInDays(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("recommendationOptions", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setRecommendationOptions(new ListUnmarshaller<InstanceRecommendationOption>(
                            InstanceRecommendationOptionJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("recommendationSources", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setRecommendationSources(new ListUnmarshaller<RecommendationSource>(RecommendationSourceJsonUnmarshaller
                            .getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("lastRefreshTimestamp", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setLastRefreshTimestamp(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("currentPerformanceRisk", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setCurrentPerformanceRisk(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("effectiveRecommendationPreferences", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setEffectiveRecommendationPreferences(EffectiveRecommendationPreferencesJsonUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("inferredWorkloadTypes", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setInferredWorkloadTypes(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("instanceState", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setInstanceState(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("tags", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setTags(new ListUnmarshaller<Tag>(TagJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("externalMetricStatus", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setExternalMetricStatus(ExternalMetricStatusJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("currentInstanceGpuInfo", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setCurrentInstanceGpuInfo(GpuInfoJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("idle", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    instanceRecommendation.setIdle(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return instanceRecommendation;
    }

    private static InstanceRecommendationJsonUnmarshaller instance;

    public static InstanceRecommendationJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new InstanceRecommendationJsonUnmarshaller();
        return instance;
    }
}
