/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.computeoptimizer.model.ExportableInstanceField;
import com.amazonaws.services.computeoptimizer.model.FileFormat;
import com.amazonaws.services.computeoptimizer.model.Filter;
import com.amazonaws.services.computeoptimizer.model.RecommendationPreferences;
import com.amazonaws.services.computeoptimizer.model.S3DestinationConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExportEC2InstanceRecommendationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> accountIds;
    private List<Filter> filters;
    private List<String> fieldsToExport;
    private S3DestinationConfig s3DestinationConfig;
    private String fileFormat;
    private Boolean includeMemberAccounts;
    private RecommendationPreferences recommendationPreferences;

    public List<String> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(Collection<String> accountIds) {
        if (accountIds == null) {
            this.accountIds = null;
            return;
        }
        this.accountIds = new ArrayList<String>(accountIds);
    }

    public ExportEC2InstanceRecommendationsRequest withAccountIds(String ... accountIds) {
        if (this.accountIds == null) {
            this.setAccountIds(new ArrayList<String>(accountIds.length));
        }
        for (String ele : accountIds) {
            this.accountIds.add(ele);
        }
        return this;
    }

    public ExportEC2InstanceRecommendationsRequest withAccountIds(Collection<String> accountIds) {
        this.setAccountIds(accountIds);
        return this;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<Filter>(filters);
    }

    public ExportEC2InstanceRecommendationsRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public ExportEC2InstanceRecommendationsRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public List<String> getFieldsToExport() {
        return this.fieldsToExport;
    }

    public void setFieldsToExport(Collection<String> fieldsToExport) {
        if (fieldsToExport == null) {
            this.fieldsToExport = null;
            return;
        }
        this.fieldsToExport = new ArrayList<String>(fieldsToExport);
    }

    public ExportEC2InstanceRecommendationsRequest withFieldsToExport(String ... fieldsToExport) {
        if (this.fieldsToExport == null) {
            this.setFieldsToExport(new ArrayList<String>(fieldsToExport.length));
        }
        for (String ele : fieldsToExport) {
            this.fieldsToExport.add(ele);
        }
        return this;
    }

    public ExportEC2InstanceRecommendationsRequest withFieldsToExport(Collection<String> fieldsToExport) {
        this.setFieldsToExport(fieldsToExport);
        return this;
    }

    public ExportEC2InstanceRecommendationsRequest withFieldsToExport(ExportableInstanceField ... fieldsToExport) {
        ArrayList<String> fieldsToExportCopy = new ArrayList<String>(fieldsToExport.length);
        for (ExportableInstanceField value : fieldsToExport) {
            fieldsToExportCopy.add(value.toString());
        }
        if (this.getFieldsToExport() == null) {
            this.setFieldsToExport(fieldsToExportCopy);
        } else {
            this.getFieldsToExport().addAll(fieldsToExportCopy);
        }
        return this;
    }

    public void setS3DestinationConfig(S3DestinationConfig s3DestinationConfig) {
        this.s3DestinationConfig = s3DestinationConfig;
    }

    public S3DestinationConfig getS3DestinationConfig() {
        return this.s3DestinationConfig;
    }

    public ExportEC2InstanceRecommendationsRequest withS3DestinationConfig(S3DestinationConfig s3DestinationConfig) {
        this.setS3DestinationConfig(s3DestinationConfig);
        return this;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public ExportEC2InstanceRecommendationsRequest withFileFormat(String fileFormat) {
        this.setFileFormat(fileFormat);
        return this;
    }

    public ExportEC2InstanceRecommendationsRequest withFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat.toString();
        return this;
    }

    public void setIncludeMemberAccounts(Boolean includeMemberAccounts) {
        this.includeMemberAccounts = includeMemberAccounts;
    }

    public Boolean getIncludeMemberAccounts() {
        return this.includeMemberAccounts;
    }

    public ExportEC2InstanceRecommendationsRequest withIncludeMemberAccounts(Boolean includeMemberAccounts) {
        this.setIncludeMemberAccounts(includeMemberAccounts);
        return this;
    }

    public Boolean isIncludeMemberAccounts() {
        return this.includeMemberAccounts;
    }

    public void setRecommendationPreferences(RecommendationPreferences recommendationPreferences) {
        this.recommendationPreferences = recommendationPreferences;
    }

    public RecommendationPreferences getRecommendationPreferences() {
        return this.recommendationPreferences;
    }

    public ExportEC2InstanceRecommendationsRequest withRecommendationPreferences(RecommendationPreferences recommendationPreferences) {
        this.setRecommendationPreferences(recommendationPreferences);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountIds() != null) {
            sb.append("AccountIds: ").append(this.getAccountIds()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getFieldsToExport() != null) {
            sb.append("FieldsToExport: ").append(this.getFieldsToExport()).append(",");
        }
        if (this.getS3DestinationConfig() != null) {
            sb.append("S3DestinationConfig: ").append(this.getS3DestinationConfig()).append(",");
        }
        if (this.getFileFormat() != null) {
            sb.append("FileFormat: ").append(this.getFileFormat()).append(",");
        }
        if (this.getIncludeMemberAccounts() != null) {
            sb.append("IncludeMemberAccounts: ").append(this.getIncludeMemberAccounts()).append(",");
        }
        if (this.getRecommendationPreferences() != null) {
            sb.append("RecommendationPreferences: ").append(this.getRecommendationPreferences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportEC2InstanceRecommendationsRequest)) {
            return false;
        }
        ExportEC2InstanceRecommendationsRequest other = (ExportEC2InstanceRecommendationsRequest)obj;
        if (other.getAccountIds() == null ^ this.getAccountIds() == null) {
            return false;
        }
        if (other.getAccountIds() != null && !other.getAccountIds().equals(this.getAccountIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getFieldsToExport() == null ^ this.getFieldsToExport() == null) {
            return false;
        }
        if (other.getFieldsToExport() != null && !other.getFieldsToExport().equals(this.getFieldsToExport())) {
            return false;
        }
        if (other.getS3DestinationConfig() == null ^ this.getS3DestinationConfig() == null) {
            return false;
        }
        if (other.getS3DestinationConfig() != null && !other.getS3DestinationConfig().equals(this.getS3DestinationConfig())) {
            return false;
        }
        if (other.getFileFormat() == null ^ this.getFileFormat() == null) {
            return false;
        }
        if (other.getFileFormat() != null && !other.getFileFormat().equals(this.getFileFormat())) {
            return false;
        }
        if (other.getIncludeMemberAccounts() == null ^ this.getIncludeMemberAccounts() == null) {
            return false;
        }
        if (other.getIncludeMemberAccounts() != null && !other.getIncludeMemberAccounts().equals(this.getIncludeMemberAccounts())) {
            return false;
        }
        if (other.getRecommendationPreferences() == null ^ this.getRecommendationPreferences() == null) {
            return false;
        }
        return other.getRecommendationPreferences() == null || other.getRecommendationPreferences().equals(this.getRecommendationPreferences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountIds() == null ? 0 : this.getAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getFieldsToExport() == null ? 0 : this.getFieldsToExport().hashCode());
        hashCode = 31 * hashCode + (this.getS3DestinationConfig() == null ? 0 : this.getS3DestinationConfig().hashCode());
        hashCode = 31 * hashCode + (this.getFileFormat() == null ? 0 : this.getFileFormat().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeMemberAccounts() == null ? 0 : this.getIncludeMemberAccounts().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationPreferences() == null ? 0 : this.getRecommendationPreferences().hashCode());
        return hashCode;
    }

    public ExportEC2InstanceRecommendationsRequest clone() {
        return (ExportEC2InstanceRecommendationsRequest)super.clone();
    }
}

