/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.LicenseConfiguration;
import com.amazonaws.services.computeoptimizer.model.LicenseFinding;
import com.amazonaws.services.computeoptimizer.model.LicenseFindingReasonCode;
import com.amazonaws.services.computeoptimizer.model.LicenseRecommendationOption;
import com.amazonaws.services.computeoptimizer.model.Tag;
import com.amazonaws.services.computeoptimizer.model.transform.LicenseRecommendationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class LicenseRecommendation
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceArn;
    private String accountId;
    private LicenseConfiguration currentLicenseConfiguration;
    private Double lookbackPeriodInDays;
    private Date lastRefreshTimestamp;
    private String finding;
    private List<String> findingReasonCodes;
    private List<LicenseRecommendationOption> licenseRecommendationOptions;
    private List<Tag> tags;

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public LicenseRecommendation withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public LicenseRecommendation withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setCurrentLicenseConfiguration(LicenseConfiguration currentLicenseConfiguration) {
        this.currentLicenseConfiguration = currentLicenseConfiguration;
    }

    public LicenseConfiguration getCurrentLicenseConfiguration() {
        return this.currentLicenseConfiguration;
    }

    public LicenseRecommendation withCurrentLicenseConfiguration(LicenseConfiguration currentLicenseConfiguration) {
        this.setCurrentLicenseConfiguration(currentLicenseConfiguration);
        return this;
    }

    public void setLookbackPeriodInDays(Double lookbackPeriodInDays) {
        this.lookbackPeriodInDays = lookbackPeriodInDays;
    }

    public Double getLookbackPeriodInDays() {
        return this.lookbackPeriodInDays;
    }

    public LicenseRecommendation withLookbackPeriodInDays(Double lookbackPeriodInDays) {
        this.setLookbackPeriodInDays(lookbackPeriodInDays);
        return this;
    }

    public void setLastRefreshTimestamp(Date lastRefreshTimestamp) {
        this.lastRefreshTimestamp = lastRefreshTimestamp;
    }

    public Date getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public LicenseRecommendation withLastRefreshTimestamp(Date lastRefreshTimestamp) {
        this.setLastRefreshTimestamp(lastRefreshTimestamp);
        return this;
    }

    public void setFinding(String finding) {
        this.finding = finding;
    }

    public String getFinding() {
        return this.finding;
    }

    public LicenseRecommendation withFinding(String finding) {
        this.setFinding(finding);
        return this;
    }

    public LicenseRecommendation withFinding(LicenseFinding finding) {
        this.finding = finding.toString();
        return this;
    }

    public List<String> getFindingReasonCodes() {
        return this.findingReasonCodes;
    }

    public void setFindingReasonCodes(Collection<String> findingReasonCodes) {
        if (findingReasonCodes == null) {
            this.findingReasonCodes = null;
            return;
        }
        this.findingReasonCodes = new ArrayList<String>(findingReasonCodes);
    }

    public LicenseRecommendation withFindingReasonCodes(String ... findingReasonCodes) {
        if (this.findingReasonCodes == null) {
            this.setFindingReasonCodes(new ArrayList<String>(findingReasonCodes.length));
        }
        for (String ele : findingReasonCodes) {
            this.findingReasonCodes.add(ele);
        }
        return this;
    }

    public LicenseRecommendation withFindingReasonCodes(Collection<String> findingReasonCodes) {
        this.setFindingReasonCodes(findingReasonCodes);
        return this;
    }

    public LicenseRecommendation withFindingReasonCodes(LicenseFindingReasonCode ... findingReasonCodes) {
        ArrayList<String> findingReasonCodesCopy = new ArrayList<String>(findingReasonCodes.length);
        for (LicenseFindingReasonCode value : findingReasonCodes) {
            findingReasonCodesCopy.add(value.toString());
        }
        if (this.getFindingReasonCodes() == null) {
            this.setFindingReasonCodes(findingReasonCodesCopy);
        } else {
            this.getFindingReasonCodes().addAll(findingReasonCodesCopy);
        }
        return this;
    }

    public List<LicenseRecommendationOption> getLicenseRecommendationOptions() {
        return this.licenseRecommendationOptions;
    }

    public void setLicenseRecommendationOptions(Collection<LicenseRecommendationOption> licenseRecommendationOptions) {
        if (licenseRecommendationOptions == null) {
            this.licenseRecommendationOptions = null;
            return;
        }
        this.licenseRecommendationOptions = new ArrayList<LicenseRecommendationOption>(licenseRecommendationOptions);
    }

    public LicenseRecommendation withLicenseRecommendationOptions(LicenseRecommendationOption ... licenseRecommendationOptions) {
        if (this.licenseRecommendationOptions == null) {
            this.setLicenseRecommendationOptions(new ArrayList<LicenseRecommendationOption>(licenseRecommendationOptions.length));
        }
        for (LicenseRecommendationOption ele : licenseRecommendationOptions) {
            this.licenseRecommendationOptions.add(ele);
        }
        return this;
    }

    public LicenseRecommendation withLicenseRecommendationOptions(Collection<LicenseRecommendationOption> licenseRecommendationOptions) {
        this.setLicenseRecommendationOptions(licenseRecommendationOptions);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public LicenseRecommendation withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public LicenseRecommendation withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getCurrentLicenseConfiguration() != null) {
            sb.append("CurrentLicenseConfiguration: ").append(this.getCurrentLicenseConfiguration()).append(",");
        }
        if (this.getLookbackPeriodInDays() != null) {
            sb.append("LookbackPeriodInDays: ").append(this.getLookbackPeriodInDays()).append(",");
        }
        if (this.getLastRefreshTimestamp() != null) {
            sb.append("LastRefreshTimestamp: ").append(this.getLastRefreshTimestamp()).append(",");
        }
        if (this.getFinding() != null) {
            sb.append("Finding: ").append(this.getFinding()).append(",");
        }
        if (this.getFindingReasonCodes() != null) {
            sb.append("FindingReasonCodes: ").append(this.getFindingReasonCodes()).append(",");
        }
        if (this.getLicenseRecommendationOptions() != null) {
            sb.append("LicenseRecommendationOptions: ").append(this.getLicenseRecommendationOptions()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseRecommendation)) {
            return false;
        }
        LicenseRecommendation other = (LicenseRecommendation)obj;
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getCurrentLicenseConfiguration() == null ^ this.getCurrentLicenseConfiguration() == null) {
            return false;
        }
        if (other.getCurrentLicenseConfiguration() != null && !other.getCurrentLicenseConfiguration().equals(this.getCurrentLicenseConfiguration())) {
            return false;
        }
        if (other.getLookbackPeriodInDays() == null ^ this.getLookbackPeriodInDays() == null) {
            return false;
        }
        if (other.getLookbackPeriodInDays() != null && !other.getLookbackPeriodInDays().equals(this.getLookbackPeriodInDays())) {
            return false;
        }
        if (other.getLastRefreshTimestamp() == null ^ this.getLastRefreshTimestamp() == null) {
            return false;
        }
        if (other.getLastRefreshTimestamp() != null && !other.getLastRefreshTimestamp().equals(this.getLastRefreshTimestamp())) {
            return false;
        }
        if (other.getFinding() == null ^ this.getFinding() == null) {
            return false;
        }
        if (other.getFinding() != null && !other.getFinding().equals(this.getFinding())) {
            return false;
        }
        if (other.getFindingReasonCodes() == null ^ this.getFindingReasonCodes() == null) {
            return false;
        }
        if (other.getFindingReasonCodes() != null && !other.getFindingReasonCodes().equals(this.getFindingReasonCodes())) {
            return false;
        }
        if (other.getLicenseRecommendationOptions() == null ^ this.getLicenseRecommendationOptions() == null) {
            return false;
        }
        if (other.getLicenseRecommendationOptions() != null && !other.getLicenseRecommendationOptions().equals(this.getLicenseRecommendationOptions())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentLicenseConfiguration() == null ? 0 : this.getCurrentLicenseConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getLookbackPeriodInDays() == null ? 0 : this.getLookbackPeriodInDays().hashCode());
        hashCode = 31 * hashCode + (this.getLastRefreshTimestamp() == null ? 0 : this.getLastRefreshTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getFinding() == null ? 0 : this.getFinding().hashCode());
        hashCode = 31 * hashCode + (this.getFindingReasonCodes() == null ? 0 : this.getFindingReasonCodes().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseRecommendationOptions() == null ? 0 : this.getLicenseRecommendationOptions().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public LicenseRecommendation clone() {
        try {
            return (LicenseRecommendation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LicenseRecommendationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

