/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.GpuInfo;
import java.util.List;

@SdkInternalApi
public class GpuInfoMarshaller {
    private static final MarshallingInfo<List> GPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gpus").build();
    private static final GpuInfoMarshaller instance = new GpuInfoMarshaller();

    public static GpuInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(GpuInfo gpuInfo, ProtocolMarshaller protocolMarshaller) {
        if (gpuInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(gpuInfo.getGpus(), GPUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

