/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.computeoptimizer.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Describes an Amazon EC2 instance recommendation.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/InstanceRecommendation"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class InstanceRecommendation implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the current instance.
     * </p>
     */
    private String instanceArn;
    /**
     * <p>
     * The Amazon Web Services account ID of the instance.
     * </p>
     */
    private String accountId;
    /**
     * <p>
     * The name of the current instance.
     * </p>
     */
    private String instanceName;
    /**
     * <p>
     * The instance type of the current instance.
     * </p>
     */
    private String currentInstanceType;
    /**
     * <p>
     * The finding classification of the instance.
     * </p>
     * <p>
     * Findings for instances include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>Underprovisioned</code> </b>—An instance is considered under-provisioned when at least one
     * specification of your instance, such as CPU, memory, or network, does not meet the performance requirements of
     * your workload. Under-provisioned instances may lead to poor application performance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Overprovisioned</code> </b>—An instance is considered over-provisioned when at least one specification
     * of your instance, such as CPU, memory, or network, can be sized down while still meeting the performance
     * requirements of your workload, and no specification is under-provisioned. Over-provisioned instances may lead to
     * unnecessary infrastructure cost.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Optimized</code> </b>—An instance is considered optimized when all specifications of your instance,
     * such as CPU, memory, and network, meet the performance requirements of your workload and is not over provisioned.
     * For optimized resources, Compute Optimizer might recommend a new generation instance type.
     * </p>
     * </li>
     * </ul>
     */
    private String finding;
    /**
     * <p>
     * The reason for the finding classification of the instance.
     * </p>
     * <p>
     * Finding reason codes for instances include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still meeting
     * the performance requirements of your workload. This is identified by analyzing the <code>CPUUtilization</code>
     * metric of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type that provides better CPU performance.
     * This is identified by analyzing the <code>CPUUtilization</code> metric of the current instance during the
     * look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while still
     * meeting the performance requirements of your workload. This is identified by analyzing the memory utilization
     * metric of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type that provides better memory performance.
     * This is identified by analyzing the memory utilization metric of the current instance during the look-back
     * period.
     * </p>
     * <note>
     * <p>
     * Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on them. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory utilization
     * with the Amazon CloudWatch Agent</a> in the <i>Compute Optimizer User Guide</i>. On Linux instances, Compute
     * Optimizer analyses the <code>mem_used_percent</code> metric in the <code>CWAgent</code> namespace, or the legacy
     * <code>MemoryUtilization</code> metric in the <code>System/Linux</code> namespace. On Windows instances, Compute
     * Optimizer analyses the <code>Memory % Committed Bytes In Use</code> metric in the <code>CWAgent</code> namespace.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be sized
     * down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current
     * instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn't meet
     * the performance requirements of your workload and there is an alternative instance type that provides better EBS
     * throughput performance. This is identified by analyzing the <code>VolumeReadBytes</code> and
     * <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down while
     * still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metric of EBS volumes attached to the current instance
     * during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn't meet the
     * performance requirements of your workload and there is an alternative instance type that provides better EBS IOPS
     * performance. This is identified by analyzing the <code>VolumeReadOps</code> and <code>VolumeWriteOps</code>
     * metric of EBS volumes attached to the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration can be
     * sized down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration doesn't
     * meet the performance requirements of your workload and there is an alternative instance type that provides better
     * network bandwidth performance. This is identified by analyzing the <code>NetworkIn</code> and
     * <code>NetworkOut</code> metrics of the current instance during the look-back period. This finding reason happens
     * when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is impacted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration
     * can be sized down while still meeting the performance requirements of your workload. This is identified by
     * analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance
     * during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration
     * doesn't meet the performance requirements of your workload and there is an alternative instance type that
     * provides better network PPS performance. This is identified by analyzing the <code>NetworkPacketsIn</code> and
     * <code>NetworkPacketsIn</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down while
     * still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn't meet the
     * performance requirements of your workload and there is an alternative instance type that provides better disk
     * IOPS performance. This is identified by analyzing the <code>DiskReadOps</code> and <code>DiskWriteOps</code>
     * metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be sized
     * down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration doesn't meet
     * the performance requirements of your workload and there is an alternative instance type that provides better disk
     * throughput performance. This is identified by analyzing the <code>DiskReadBytes</code> and
     * <code>DiskWriteBytes</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * For more information about instance metrics, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
     * available CloudWatch metrics for your instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For
     * more information about EBS volume metrics, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch metrics
     * for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </note>
     */
    private java.util.List<String> findingReasonCodes;
    /**
     * <p>
     * An array of objects that describe the utilization metrics of the instance.
     * </p>
     */
    private java.util.List<UtilizationMetric> utilizationMetrics;
    /**
     * <p>
     * The number of days for which utilization metrics were analyzed for the instance.
     * </p>
     */
    private Double lookBackPeriodInDays;
    /**
     * <p>
     * An array of objects that describe the recommendation options for the instance.
     * </p>
     */
    private java.util.List<InstanceRecommendationOption> recommendationOptions;
    /**
     * <p>
     * An array of objects that describe the source resource of the recommendation.
     * </p>
     */
    private java.util.List<RecommendationSource> recommendationSources;
    /**
     * <p>
     * The timestamp of when the instance recommendation was last generated.
     * </p>
     */
    private java.util.Date lastRefreshTimestamp;
    /**
     * <p>
     * The risk of the current instance not meeting the performance needs of its workloads. The higher the risk, the
     * more likely the current instance cannot meet the performance requirements of its workload.
     * </p>
     */
    private String currentPerformanceRisk;
    /**
     * <p>
     * An object that describes the effective recommendation preferences for the instance.
     * </p>
     */
    private EffectiveRecommendationPreferences effectiveRecommendationPreferences;
    /**
     * <p>
     * The applications that might be running on the instance as inferred by Compute Optimizer.
     * </p>
     * <p>
     * Compute Optimizer can infer if one of the following applications might be running on the instance:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AmazonEmr</code> - Infers that Amazon EMR might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApacheCassandra</code> - Infers that Apache Cassandra might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApacheHadoop</code> - Infers that Apache Hadoop might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Memcached</code> - Infers that Memcached might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NGINX</code> - Infers that NGINX might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PostgreSql</code> - Infers that PostgreSQL might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Redis</code> - Infers that Redis might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Kafka</code> - Infers that Kafka might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SQLServer</code> - Infers that SQLServer might be running on the instance.
     * </p>
     * </li>
     * </ul>
     */
    private java.util.List<String> inferredWorkloadTypes;
    /**
     * <p>
     * The state of the instance when the recommendation was generated.
     * </p>
     */
    private String instanceState;
    /**
     * <p>
     * A list of tags assigned to your Amazon EC2 instance recommendations.
     * </p>
     */
    private java.util.List<Tag> tags;
    /**
     * <p>
     * An object that describes Compute Optimizer's integration status with your external metrics provider.
     * </p>
     */
    private ExternalMetricStatus externalMetricStatus;
    /**
     * <p>
     * Describes the GPU accelerator settings for the current instance type.
     * </p>
     */
    private GpuInfo currentInstanceGpuInfo;
    /**
     * <p>
     * Describes if an Amazon EC2 instance is idle.
     * </p>
     */
    private String idle;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the current instance.
     * </p>
     * 
     * @param instanceArn
     *        The Amazon Resource Name (ARN) of the current instance.
     */

    public void setInstanceArn(String instanceArn) {
        this.instanceArn = instanceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the current instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the current instance.
     */

    public String getInstanceArn() {
        return this.instanceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the current instance.
     * </p>
     * 
     * @param instanceArn
     *        The Amazon Resource Name (ARN) of the current instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withInstanceArn(String instanceArn) {
        setInstanceArn(instanceArn);
        return this;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the instance.
     * </p>
     * 
     * @param accountId
     *        The Amazon Web Services account ID of the instance.
     */

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the instance.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the instance.
     */

    public String getAccountId() {
        return this.accountId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the instance.
     * </p>
     * 
     * @param accountId
     *        The Amazon Web Services account ID of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withAccountId(String accountId) {
        setAccountId(accountId);
        return this;
    }

    /**
     * <p>
     * The name of the current instance.
     * </p>
     * 
     * @param instanceName
     *        The name of the current instance.
     */

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    /**
     * <p>
     * The name of the current instance.
     * </p>
     * 
     * @return The name of the current instance.
     */

    public String getInstanceName() {
        return this.instanceName;
    }

    /**
     * <p>
     * The name of the current instance.
     * </p>
     * 
     * @param instanceName
     *        The name of the current instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withInstanceName(String instanceName) {
        setInstanceName(instanceName);
        return this;
    }

    /**
     * <p>
     * The instance type of the current instance.
     * </p>
     * 
     * @param currentInstanceType
     *        The instance type of the current instance.
     */

    public void setCurrentInstanceType(String currentInstanceType) {
        this.currentInstanceType = currentInstanceType;
    }

    /**
     * <p>
     * The instance type of the current instance.
     * </p>
     * 
     * @return The instance type of the current instance.
     */

    public String getCurrentInstanceType() {
        return this.currentInstanceType;
    }

    /**
     * <p>
     * The instance type of the current instance.
     * </p>
     * 
     * @param currentInstanceType
     *        The instance type of the current instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withCurrentInstanceType(String currentInstanceType) {
        setCurrentInstanceType(currentInstanceType);
        return this;
    }

    /**
     * <p>
     * The finding classification of the instance.
     * </p>
     * <p>
     * Findings for instances include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>Underprovisioned</code> </b>—An instance is considered under-provisioned when at least one
     * specification of your instance, such as CPU, memory, or network, does not meet the performance requirements of
     * your workload. Under-provisioned instances may lead to poor application performance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Overprovisioned</code> </b>—An instance is considered over-provisioned when at least one specification
     * of your instance, such as CPU, memory, or network, can be sized down while still meeting the performance
     * requirements of your workload, and no specification is under-provisioned. Over-provisioned instances may lead to
     * unnecessary infrastructure cost.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Optimized</code> </b>—An instance is considered optimized when all specifications of your instance,
     * such as CPU, memory, and network, meet the performance requirements of your workload and is not over provisioned.
     * For optimized resources, Compute Optimizer might recommend a new generation instance type.
     * </p>
     * </li>
     * </ul>
     * 
     * @param finding
     *        The finding classification of the instance.</p>
     *        <p>
     *        Findings for instances include:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b> <code>Underprovisioned</code> </b>—An instance is considered under-provisioned when at least one
     *        specification of your instance, such as CPU, memory, or network, does not meet the performance
     *        requirements of your workload. Under-provisioned instances may lead to poor application performance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>Overprovisioned</code> </b>—An instance is considered over-provisioned when at least one
     *        specification of your instance, such as CPU, memory, or network, can be sized down while still meeting the
     *        performance requirements of your workload, and no specification is under-provisioned. Over-provisioned
     *        instances may lead to unnecessary infrastructure cost.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>Optimized</code> </b>—An instance is considered optimized when all specifications of your
     *        instance, such as CPU, memory, and network, meet the performance requirements of your workload and is not
     *        over provisioned. For optimized resources, Compute Optimizer might recommend a new generation instance
     *        type.
     *        </p>
     *        </li>
     * @see Finding
     */

    public void setFinding(String finding) {
        this.finding = finding;
    }

    /**
     * <p>
     * The finding classification of the instance.
     * </p>
     * <p>
     * Findings for instances include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>Underprovisioned</code> </b>—An instance is considered under-provisioned when at least one
     * specification of your instance, such as CPU, memory, or network, does not meet the performance requirements of
     * your workload. Under-provisioned instances may lead to poor application performance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Overprovisioned</code> </b>—An instance is considered over-provisioned when at least one specification
     * of your instance, such as CPU, memory, or network, can be sized down while still meeting the performance
     * requirements of your workload, and no specification is under-provisioned. Over-provisioned instances may lead to
     * unnecessary infrastructure cost.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Optimized</code> </b>—An instance is considered optimized when all specifications of your instance,
     * such as CPU, memory, and network, meet the performance requirements of your workload and is not over provisioned.
     * For optimized resources, Compute Optimizer might recommend a new generation instance type.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The finding classification of the instance.</p>
     *         <p>
     *         Findings for instances include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>Underprovisioned</code> </b>—An instance is considered under-provisioned when at least one
     *         specification of your instance, such as CPU, memory, or network, does not meet the performance
     *         requirements of your workload. Under-provisioned instances may lead to poor application performance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Overprovisioned</code> </b>—An instance is considered over-provisioned when at least one
     *         specification of your instance, such as CPU, memory, or network, can be sized down while still meeting
     *         the performance requirements of your workload, and no specification is under-provisioned.
     *         Over-provisioned instances may lead to unnecessary infrastructure cost.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Optimized</code> </b>—An instance is considered optimized when all specifications of your
     *         instance, such as CPU, memory, and network, meet the performance requirements of your workload and is not
     *         over provisioned. For optimized resources, Compute Optimizer might recommend a new generation instance
     *         type.
     *         </p>
     *         </li>
     * @see Finding
     */

    public String getFinding() {
        return this.finding;
    }

    /**
     * <p>
     * The finding classification of the instance.
     * </p>
     * <p>
     * Findings for instances include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>Underprovisioned</code> </b>—An instance is considered under-provisioned when at least one
     * specification of your instance, such as CPU, memory, or network, does not meet the performance requirements of
     * your workload. Under-provisioned instances may lead to poor application performance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Overprovisioned</code> </b>—An instance is considered over-provisioned when at least one specification
     * of your instance, such as CPU, memory, or network, can be sized down while still meeting the performance
     * requirements of your workload, and no specification is under-provisioned. Over-provisioned instances may lead to
     * unnecessary infrastructure cost.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Optimized</code> </b>—An instance is considered optimized when all specifications of your instance,
     * such as CPU, memory, and network, meet the performance requirements of your workload and is not over provisioned.
     * For optimized resources, Compute Optimizer might recommend a new generation instance type.
     * </p>
     * </li>
     * </ul>
     * 
     * @param finding
     *        The finding classification of the instance.</p>
     *        <p>
     *        Findings for instances include:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b> <code>Underprovisioned</code> </b>—An instance is considered under-provisioned when at least one
     *        specification of your instance, such as CPU, memory, or network, does not meet the performance
     *        requirements of your workload. Under-provisioned instances may lead to poor application performance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>Overprovisioned</code> </b>—An instance is considered over-provisioned when at least one
     *        specification of your instance, such as CPU, memory, or network, can be sized down while still meeting the
     *        performance requirements of your workload, and no specification is under-provisioned. Over-provisioned
     *        instances may lead to unnecessary infrastructure cost.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>Optimized</code> </b>—An instance is considered optimized when all specifications of your
     *        instance, such as CPU, memory, and network, meet the performance requirements of your workload and is not
     *        over provisioned. For optimized resources, Compute Optimizer might recommend a new generation instance
     *        type.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Finding
     */

    public InstanceRecommendation withFinding(String finding) {
        setFinding(finding);
        return this;
    }

    /**
     * <p>
     * The finding classification of the instance.
     * </p>
     * <p>
     * Findings for instances include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>Underprovisioned</code> </b>—An instance is considered under-provisioned when at least one
     * specification of your instance, such as CPU, memory, or network, does not meet the performance requirements of
     * your workload. Under-provisioned instances may lead to poor application performance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Overprovisioned</code> </b>—An instance is considered over-provisioned when at least one specification
     * of your instance, such as CPU, memory, or network, can be sized down while still meeting the performance
     * requirements of your workload, and no specification is under-provisioned. Over-provisioned instances may lead to
     * unnecessary infrastructure cost.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Optimized</code> </b>—An instance is considered optimized when all specifications of your instance,
     * such as CPU, memory, and network, meet the performance requirements of your workload and is not over provisioned.
     * For optimized resources, Compute Optimizer might recommend a new generation instance type.
     * </p>
     * </li>
     * </ul>
     * 
     * @param finding
     *        The finding classification of the instance.</p>
     *        <p>
     *        Findings for instances include:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b> <code>Underprovisioned</code> </b>—An instance is considered under-provisioned when at least one
     *        specification of your instance, such as CPU, memory, or network, does not meet the performance
     *        requirements of your workload. Under-provisioned instances may lead to poor application performance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>Overprovisioned</code> </b>—An instance is considered over-provisioned when at least one
     *        specification of your instance, such as CPU, memory, or network, can be sized down while still meeting the
     *        performance requirements of your workload, and no specification is under-provisioned. Over-provisioned
     *        instances may lead to unnecessary infrastructure cost.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>Optimized</code> </b>—An instance is considered optimized when all specifications of your
     *        instance, such as CPU, memory, and network, meet the performance requirements of your workload and is not
     *        over provisioned. For optimized resources, Compute Optimizer might recommend a new generation instance
     *        type.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Finding
     */

    public InstanceRecommendation withFinding(Finding finding) {
        this.finding = finding.toString();
        return this;
    }

    /**
     * <p>
     * The reason for the finding classification of the instance.
     * </p>
     * <p>
     * Finding reason codes for instances include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still meeting
     * the performance requirements of your workload. This is identified by analyzing the <code>CPUUtilization</code>
     * metric of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type that provides better CPU performance.
     * This is identified by analyzing the <code>CPUUtilization</code> metric of the current instance during the
     * look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while still
     * meeting the performance requirements of your workload. This is identified by analyzing the memory utilization
     * metric of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type that provides better memory performance.
     * This is identified by analyzing the memory utilization metric of the current instance during the look-back
     * period.
     * </p>
     * <note>
     * <p>
     * Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on them. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory utilization
     * with the Amazon CloudWatch Agent</a> in the <i>Compute Optimizer User Guide</i>. On Linux instances, Compute
     * Optimizer analyses the <code>mem_used_percent</code> metric in the <code>CWAgent</code> namespace, or the legacy
     * <code>MemoryUtilization</code> metric in the <code>System/Linux</code> namespace. On Windows instances, Compute
     * Optimizer analyses the <code>Memory % Committed Bytes In Use</code> metric in the <code>CWAgent</code> namespace.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be sized
     * down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current
     * instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn't meet
     * the performance requirements of your workload and there is an alternative instance type that provides better EBS
     * throughput performance. This is identified by analyzing the <code>VolumeReadBytes</code> and
     * <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down while
     * still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metric of EBS volumes attached to the current instance
     * during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn't meet the
     * performance requirements of your workload and there is an alternative instance type that provides better EBS IOPS
     * performance. This is identified by analyzing the <code>VolumeReadOps</code> and <code>VolumeWriteOps</code>
     * metric of EBS volumes attached to the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration can be
     * sized down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration doesn't
     * meet the performance requirements of your workload and there is an alternative instance type that provides better
     * network bandwidth performance. This is identified by analyzing the <code>NetworkIn</code> and
     * <code>NetworkOut</code> metrics of the current instance during the look-back period. This finding reason happens
     * when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is impacted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration
     * can be sized down while still meeting the performance requirements of your workload. This is identified by
     * analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance
     * during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration
     * doesn't meet the performance requirements of your workload and there is an alternative instance type that
     * provides better network PPS performance. This is identified by analyzing the <code>NetworkPacketsIn</code> and
     * <code>NetworkPacketsIn</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down while
     * still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn't meet the
     * performance requirements of your workload and there is an alternative instance type that provides better disk
     * IOPS performance. This is identified by analyzing the <code>DiskReadOps</code> and <code>DiskWriteOps</code>
     * metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be sized
     * down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration doesn't meet
     * the performance requirements of your workload and there is an alternative instance type that provides better disk
     * throughput performance. This is identified by analyzing the <code>DiskReadBytes</code> and
     * <code>DiskWriteBytes</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * For more information about instance metrics, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
     * available CloudWatch metrics for your instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For
     * more information about EBS volume metrics, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch metrics
     * for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The reason for the finding classification of the instance.</p>
     *         <p>
     *         Finding reason codes for instances include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still
     *         meeting the performance requirements of your workload. This is identified by analyzing the
     *         <code>CPUUtilization</code> metric of the current instance during the look-back period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn't meet the performance
     *         requirements of your workload and there is an alternative instance type that provides better CPU
     *         performance. This is identified by analyzing the <code>CPUUtilization</code> metric of the current
     *         instance during the look-back period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while
     *         still meeting the performance requirements of your workload. This is identified by analyzing the memory
     *         utilization metric of the current instance during the look-back period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn't meet the
     *         performance requirements of your workload and there is an alternative instance type that provides better
     *         memory performance. This is identified by analyzing the memory utilization metric of the current instance
     *         during the look-back period.
     *         </p>
     *         <note>
     *         <p>
     *         Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on
     *         them. For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory
     *         utilization with the Amazon CloudWatch Agent</a> in the <i>Compute Optimizer User Guide</i>. On Linux
     *         instances, Compute Optimizer analyses the <code>mem_used_percent</code> metric in the
     *         <code>CWAgent</code> namespace, or the legacy <code>MemoryUtilization</code> metric in the
     *         <code>System/Linux</code> namespace. On Windows instances, Compute Optimizer analyses the
     *         <code>Memory % Committed Bytes In Use</code> metric in the <code>CWAgent</code> namespace.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be
     *         sized down while still meeting the performance requirements of your workload. This is identified by
     *         analyzing the <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metrics of EBS volumes
     *         attached to the current instance during the look-back period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn't
     *         meet the performance requirements of your workload and there is an alternative instance type that
     *         provides better EBS throughput performance. This is identified by analyzing the
     *         <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the
     *         current instance during the look-back period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down
     *         while still meeting the performance requirements of your workload. This is identified by analyzing the
     *         <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metric of EBS volumes attached to the current
     *         instance during the look-back period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn't meet the
     *         performance requirements of your workload and there is an alternative instance type that provides better
     *         EBS IOPS performance. This is identified by analyzing the <code>VolumeReadOps</code> and
     *         <code>VolumeWriteOps</code> metric of EBS volumes attached to the current instance during the look-back
     *         period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration
     *         can be sized down while still meeting the performance requirements of your workload. This is identified
     *         by analyzing the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance
     *         during the look-back period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration
     *         doesn't meet the performance requirements of your workload and there is an alternative instance type that
     *         provides better network bandwidth performance. This is identified by analyzing the <code>NetworkIn</code>
     *         and <code>NetworkOut</code> metrics of the current instance during the look-back period. This finding
     *         reason happens when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is
     *         impacted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second)
     *         configuration can be sized down while still meeting the performance requirements of your workload. This
     *         is identified by analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of
     *         the current instance during the look-back period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second)
     *         configuration doesn't meet the performance requirements of your workload and there is an alternative
     *         instance type that provides better network PPS performance. This is identified by analyzing the
     *         <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance during
     *         the look-back period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down
     *         while still meeting the performance requirements of your workload. This is identified by analyzing the
     *         <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the
     *         look-back period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn't meet the
     *         performance requirements of your workload and there is an alternative instance type that provides better
     *         disk IOPS performance. This is identified by analyzing the <code>DiskReadOps</code> and
     *         <code>DiskWriteOps</code> metrics of the current instance during the look-back period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be
     *         sized down while still meeting the performance requirements of your workload. This is identified by
     *         analyzing the <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance
     *         during the look-back period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration
     *         doesn't meet the performance requirements of your workload and there is an alternative instance type that
     *         provides better disk throughput performance. This is identified by analyzing the
     *         <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the
     *         look-back period.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         For more information about instance metrics, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
     *         available CloudWatch metrics for your instances</a> in the <i>Amazon Elastic Compute Cloud User
     *         Guide</i>. For more information about EBS volume metrics, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch
     *         metrics for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     *         </p>
     * @see InstanceRecommendationFindingReasonCode
     */

    public java.util.List<String> getFindingReasonCodes() {
        return findingReasonCodes;
    }

    /**
     * <p>
     * The reason for the finding classification of the instance.
     * </p>
     * <p>
     * Finding reason codes for instances include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still meeting
     * the performance requirements of your workload. This is identified by analyzing the <code>CPUUtilization</code>
     * metric of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type that provides better CPU performance.
     * This is identified by analyzing the <code>CPUUtilization</code> metric of the current instance during the
     * look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while still
     * meeting the performance requirements of your workload. This is identified by analyzing the memory utilization
     * metric of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type that provides better memory performance.
     * This is identified by analyzing the memory utilization metric of the current instance during the look-back
     * period.
     * </p>
     * <note>
     * <p>
     * Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on them. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory utilization
     * with the Amazon CloudWatch Agent</a> in the <i>Compute Optimizer User Guide</i>. On Linux instances, Compute
     * Optimizer analyses the <code>mem_used_percent</code> metric in the <code>CWAgent</code> namespace, or the legacy
     * <code>MemoryUtilization</code> metric in the <code>System/Linux</code> namespace. On Windows instances, Compute
     * Optimizer analyses the <code>Memory % Committed Bytes In Use</code> metric in the <code>CWAgent</code> namespace.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be sized
     * down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current
     * instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn't meet
     * the performance requirements of your workload and there is an alternative instance type that provides better EBS
     * throughput performance. This is identified by analyzing the <code>VolumeReadBytes</code> and
     * <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down while
     * still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metric of EBS volumes attached to the current instance
     * during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn't meet the
     * performance requirements of your workload and there is an alternative instance type that provides better EBS IOPS
     * performance. This is identified by analyzing the <code>VolumeReadOps</code> and <code>VolumeWriteOps</code>
     * metric of EBS volumes attached to the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration can be
     * sized down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration doesn't
     * meet the performance requirements of your workload and there is an alternative instance type that provides better
     * network bandwidth performance. This is identified by analyzing the <code>NetworkIn</code> and
     * <code>NetworkOut</code> metrics of the current instance during the look-back period. This finding reason happens
     * when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is impacted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration
     * can be sized down while still meeting the performance requirements of your workload. This is identified by
     * analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance
     * during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration
     * doesn't meet the performance requirements of your workload and there is an alternative instance type that
     * provides better network PPS performance. This is identified by analyzing the <code>NetworkPacketsIn</code> and
     * <code>NetworkPacketsIn</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down while
     * still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn't meet the
     * performance requirements of your workload and there is an alternative instance type that provides better disk
     * IOPS performance. This is identified by analyzing the <code>DiskReadOps</code> and <code>DiskWriteOps</code>
     * metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be sized
     * down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration doesn't meet
     * the performance requirements of your workload and there is an alternative instance type that provides better disk
     * throughput performance. This is identified by analyzing the <code>DiskReadBytes</code> and
     * <code>DiskWriteBytes</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * For more information about instance metrics, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
     * available CloudWatch metrics for your instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For
     * more information about EBS volume metrics, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch metrics
     * for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </note>
     * 
     * @param findingReasonCodes
     *        The reason for the finding classification of the instance.</p>
     *        <p>
     *        Finding reason codes for instances include:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still
     *        meeting the performance requirements of your workload. This is identified by analyzing the
     *        <code>CPUUtilization</code> metric of the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn't meet the performance
     *        requirements of your workload and there is an alternative instance type that provides better CPU
     *        performance. This is identified by analyzing the <code>CPUUtilization</code> metric of the current
     *        instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while
     *        still meeting the performance requirements of your workload. This is identified by analyzing the memory
     *        utilization metric of the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn't meet the
     *        performance requirements of your workload and there is an alternative instance type that provides better
     *        memory performance. This is identified by analyzing the memory utilization metric of the current instance
     *        during the look-back period.
     *        </p>
     *        <note>
     *        <p>
     *        Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on
     *        them. For more information, see <a
     *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory
     *        utilization with the Amazon CloudWatch Agent</a> in the <i>Compute Optimizer User Guide</i>. On Linux
     *        instances, Compute Optimizer analyses the <code>mem_used_percent</code> metric in the <code>CWAgent</code>
     *        namespace, or the legacy <code>MemoryUtilization</code> metric in the <code>System/Linux</code> namespace.
     *        On Windows instances, Compute Optimizer analyses the <code>Memory % Committed Bytes In Use</code> metric
     *        in the <code>CWAgent</code> namespace.
     *        </p>
     *        </note></li>
     *        <li>
     *        <p>
     *        <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be
     *        sized down while still meeting the performance requirements of your workload. This is identified by
     *        analyzing the <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metrics of EBS volumes
     *        attached to the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn't
     *        meet the performance requirements of your workload and there is an alternative instance type that provides
     *        better EBS throughput performance. This is identified by analyzing the <code>VolumeReadBytes</code> and
     *        <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current instance during the look-back
     *        period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down
     *        while still meeting the performance requirements of your workload. This is identified by analyzing the
     *        <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metric of EBS volumes attached to the current
     *        instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn't meet the
     *        performance requirements of your workload and there is an alternative instance type that provides better
     *        EBS IOPS performance. This is identified by analyzing the <code>VolumeReadOps</code> and
     *        <code>VolumeWriteOps</code> metric of EBS volumes attached to the current instance during the look-back
     *        period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration can
     *        be sized down while still meeting the performance requirements of your workload. This is identified by
     *        analyzing the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance during
     *        the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration
     *        doesn't meet the performance requirements of your workload and there is an alternative instance type that
     *        provides better network bandwidth performance. This is identified by analyzing the <code>NetworkIn</code>
     *        and <code>NetworkOut</code> metrics of the current instance during the look-back period. This finding
     *        reason happens when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is
     *        impacted.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second)
     *        configuration can be sized down while still meeting the performance requirements of your workload. This is
     *        identified by analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the
     *        current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second)
     *        configuration doesn't meet the performance requirements of your workload and there is an alternative
     *        instance type that provides better network PPS performance. This is identified by analyzing the
     *        <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance during the
     *        look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down
     *        while still meeting the performance requirements of your workload. This is identified by analyzing the
     *        <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the
     *        look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn't meet the
     *        performance requirements of your workload and there is an alternative instance type that provides better
     *        disk IOPS performance. This is identified by analyzing the <code>DiskReadOps</code> and
     *        <code>DiskWriteOps</code> metrics of the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be
     *        sized down while still meeting the performance requirements of your workload. This is identified by
     *        analyzing the <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance
     *        during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration
     *        doesn't meet the performance requirements of your workload and there is an alternative instance type that
     *        provides better disk throughput performance. This is identified by analyzing the
     *        <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the
     *        look-back period.
     *        </p>
     *        </li>
     *        </ul>
     *        <note>
     *        <p>
     *        For more information about instance metrics, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
     *        available CloudWatch metrics for your instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     *        For more information about EBS volume metrics, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch
     *        metrics for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     *        </p>
     * @see InstanceRecommendationFindingReasonCode
     */

    public void setFindingReasonCodes(java.util.Collection<String> findingReasonCodes) {
        if (findingReasonCodes == null) {
            this.findingReasonCodes = null;
            return;
        }

        this.findingReasonCodes = new java.util.ArrayList<String>(findingReasonCodes);
    }

    /**
     * <p>
     * The reason for the finding classification of the instance.
     * </p>
     * <p>
     * Finding reason codes for instances include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still meeting
     * the performance requirements of your workload. This is identified by analyzing the <code>CPUUtilization</code>
     * metric of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type that provides better CPU performance.
     * This is identified by analyzing the <code>CPUUtilization</code> metric of the current instance during the
     * look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while still
     * meeting the performance requirements of your workload. This is identified by analyzing the memory utilization
     * metric of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type that provides better memory performance.
     * This is identified by analyzing the memory utilization metric of the current instance during the look-back
     * period.
     * </p>
     * <note>
     * <p>
     * Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on them. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory utilization
     * with the Amazon CloudWatch Agent</a> in the <i>Compute Optimizer User Guide</i>. On Linux instances, Compute
     * Optimizer analyses the <code>mem_used_percent</code> metric in the <code>CWAgent</code> namespace, or the legacy
     * <code>MemoryUtilization</code> metric in the <code>System/Linux</code> namespace. On Windows instances, Compute
     * Optimizer analyses the <code>Memory % Committed Bytes In Use</code> metric in the <code>CWAgent</code> namespace.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be sized
     * down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current
     * instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn't meet
     * the performance requirements of your workload and there is an alternative instance type that provides better EBS
     * throughput performance. This is identified by analyzing the <code>VolumeReadBytes</code> and
     * <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down while
     * still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metric of EBS volumes attached to the current instance
     * during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn't meet the
     * performance requirements of your workload and there is an alternative instance type that provides better EBS IOPS
     * performance. This is identified by analyzing the <code>VolumeReadOps</code> and <code>VolumeWriteOps</code>
     * metric of EBS volumes attached to the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration can be
     * sized down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration doesn't
     * meet the performance requirements of your workload and there is an alternative instance type that provides better
     * network bandwidth performance. This is identified by analyzing the <code>NetworkIn</code> and
     * <code>NetworkOut</code> metrics of the current instance during the look-back period. This finding reason happens
     * when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is impacted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration
     * can be sized down while still meeting the performance requirements of your workload. This is identified by
     * analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance
     * during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration
     * doesn't meet the performance requirements of your workload and there is an alternative instance type that
     * provides better network PPS performance. This is identified by analyzing the <code>NetworkPacketsIn</code> and
     * <code>NetworkPacketsIn</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down while
     * still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn't meet the
     * performance requirements of your workload and there is an alternative instance type that provides better disk
     * IOPS performance. This is identified by analyzing the <code>DiskReadOps</code> and <code>DiskWriteOps</code>
     * metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be sized
     * down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration doesn't meet
     * the performance requirements of your workload and there is an alternative instance type that provides better disk
     * throughput performance. This is identified by analyzing the <code>DiskReadBytes</code> and
     * <code>DiskWriteBytes</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * For more information about instance metrics, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
     * available CloudWatch metrics for your instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For
     * more information about EBS volume metrics, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch metrics
     * for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </note>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setFindingReasonCodes(java.util.Collection)} or {@link #withFindingReasonCodes(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param findingReasonCodes
     *        The reason for the finding classification of the instance.</p>
     *        <p>
     *        Finding reason codes for instances include:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still
     *        meeting the performance requirements of your workload. This is identified by analyzing the
     *        <code>CPUUtilization</code> metric of the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn't meet the performance
     *        requirements of your workload and there is an alternative instance type that provides better CPU
     *        performance. This is identified by analyzing the <code>CPUUtilization</code> metric of the current
     *        instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while
     *        still meeting the performance requirements of your workload. This is identified by analyzing the memory
     *        utilization metric of the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn't meet the
     *        performance requirements of your workload and there is an alternative instance type that provides better
     *        memory performance. This is identified by analyzing the memory utilization metric of the current instance
     *        during the look-back period.
     *        </p>
     *        <note>
     *        <p>
     *        Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on
     *        them. For more information, see <a
     *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory
     *        utilization with the Amazon CloudWatch Agent</a> in the <i>Compute Optimizer User Guide</i>. On Linux
     *        instances, Compute Optimizer analyses the <code>mem_used_percent</code> metric in the <code>CWAgent</code>
     *        namespace, or the legacy <code>MemoryUtilization</code> metric in the <code>System/Linux</code> namespace.
     *        On Windows instances, Compute Optimizer analyses the <code>Memory % Committed Bytes In Use</code> metric
     *        in the <code>CWAgent</code> namespace.
     *        </p>
     *        </note></li>
     *        <li>
     *        <p>
     *        <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be
     *        sized down while still meeting the performance requirements of your workload. This is identified by
     *        analyzing the <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metrics of EBS volumes
     *        attached to the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn't
     *        meet the performance requirements of your workload and there is an alternative instance type that provides
     *        better EBS throughput performance. This is identified by analyzing the <code>VolumeReadBytes</code> and
     *        <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current instance during the look-back
     *        period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down
     *        while still meeting the performance requirements of your workload. This is identified by analyzing the
     *        <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metric of EBS volumes attached to the current
     *        instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn't meet the
     *        performance requirements of your workload and there is an alternative instance type that provides better
     *        EBS IOPS performance. This is identified by analyzing the <code>VolumeReadOps</code> and
     *        <code>VolumeWriteOps</code> metric of EBS volumes attached to the current instance during the look-back
     *        period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration can
     *        be sized down while still meeting the performance requirements of your workload. This is identified by
     *        analyzing the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance during
     *        the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration
     *        doesn't meet the performance requirements of your workload and there is an alternative instance type that
     *        provides better network bandwidth performance. This is identified by analyzing the <code>NetworkIn</code>
     *        and <code>NetworkOut</code> metrics of the current instance during the look-back period. This finding
     *        reason happens when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is
     *        impacted.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second)
     *        configuration can be sized down while still meeting the performance requirements of your workload. This is
     *        identified by analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the
     *        current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second)
     *        configuration doesn't meet the performance requirements of your workload and there is an alternative
     *        instance type that provides better network PPS performance. This is identified by analyzing the
     *        <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance during the
     *        look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down
     *        while still meeting the performance requirements of your workload. This is identified by analyzing the
     *        <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the
     *        look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn't meet the
     *        performance requirements of your workload and there is an alternative instance type that provides better
     *        disk IOPS performance. This is identified by analyzing the <code>DiskReadOps</code> and
     *        <code>DiskWriteOps</code> metrics of the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be
     *        sized down while still meeting the performance requirements of your workload. This is identified by
     *        analyzing the <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance
     *        during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration
     *        doesn't meet the performance requirements of your workload and there is an alternative instance type that
     *        provides better disk throughput performance. This is identified by analyzing the
     *        <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the
     *        look-back period.
     *        </p>
     *        </li>
     *        </ul>
     *        <note>
     *        <p>
     *        For more information about instance metrics, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
     *        available CloudWatch metrics for your instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     *        For more information about EBS volume metrics, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch
     *        metrics for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InstanceRecommendationFindingReasonCode
     */

    public InstanceRecommendation withFindingReasonCodes(String... findingReasonCodes) {
        if (this.findingReasonCodes == null) {
            setFindingReasonCodes(new java.util.ArrayList<String>(findingReasonCodes.length));
        }
        for (String ele : findingReasonCodes) {
            this.findingReasonCodes.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The reason for the finding classification of the instance.
     * </p>
     * <p>
     * Finding reason codes for instances include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still meeting
     * the performance requirements of your workload. This is identified by analyzing the <code>CPUUtilization</code>
     * metric of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type that provides better CPU performance.
     * This is identified by analyzing the <code>CPUUtilization</code> metric of the current instance during the
     * look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while still
     * meeting the performance requirements of your workload. This is identified by analyzing the memory utilization
     * metric of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type that provides better memory performance.
     * This is identified by analyzing the memory utilization metric of the current instance during the look-back
     * period.
     * </p>
     * <note>
     * <p>
     * Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on them. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory utilization
     * with the Amazon CloudWatch Agent</a> in the <i>Compute Optimizer User Guide</i>. On Linux instances, Compute
     * Optimizer analyses the <code>mem_used_percent</code> metric in the <code>CWAgent</code> namespace, or the legacy
     * <code>MemoryUtilization</code> metric in the <code>System/Linux</code> namespace. On Windows instances, Compute
     * Optimizer analyses the <code>Memory % Committed Bytes In Use</code> metric in the <code>CWAgent</code> namespace.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be sized
     * down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current
     * instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn't meet
     * the performance requirements of your workload and there is an alternative instance type that provides better EBS
     * throughput performance. This is identified by analyzing the <code>VolumeReadBytes</code> and
     * <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down while
     * still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metric of EBS volumes attached to the current instance
     * during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn't meet the
     * performance requirements of your workload and there is an alternative instance type that provides better EBS IOPS
     * performance. This is identified by analyzing the <code>VolumeReadOps</code> and <code>VolumeWriteOps</code>
     * metric of EBS volumes attached to the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration can be
     * sized down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration doesn't
     * meet the performance requirements of your workload and there is an alternative instance type that provides better
     * network bandwidth performance. This is identified by analyzing the <code>NetworkIn</code> and
     * <code>NetworkOut</code> metrics of the current instance during the look-back period. This finding reason happens
     * when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is impacted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration
     * can be sized down while still meeting the performance requirements of your workload. This is identified by
     * analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance
     * during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration
     * doesn't meet the performance requirements of your workload and there is an alternative instance type that
     * provides better network PPS performance. This is identified by analyzing the <code>NetworkPacketsIn</code> and
     * <code>NetworkPacketsIn</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down while
     * still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn't meet the
     * performance requirements of your workload and there is an alternative instance type that provides better disk
     * IOPS performance. This is identified by analyzing the <code>DiskReadOps</code> and <code>DiskWriteOps</code>
     * metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be sized
     * down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration doesn't meet
     * the performance requirements of your workload and there is an alternative instance type that provides better disk
     * throughput performance. This is identified by analyzing the <code>DiskReadBytes</code> and
     * <code>DiskWriteBytes</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * For more information about instance metrics, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
     * available CloudWatch metrics for your instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For
     * more information about EBS volume metrics, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch metrics
     * for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </note>
     * 
     * @param findingReasonCodes
     *        The reason for the finding classification of the instance.</p>
     *        <p>
     *        Finding reason codes for instances include:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still
     *        meeting the performance requirements of your workload. This is identified by analyzing the
     *        <code>CPUUtilization</code> metric of the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn't meet the performance
     *        requirements of your workload and there is an alternative instance type that provides better CPU
     *        performance. This is identified by analyzing the <code>CPUUtilization</code> metric of the current
     *        instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while
     *        still meeting the performance requirements of your workload. This is identified by analyzing the memory
     *        utilization metric of the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn't meet the
     *        performance requirements of your workload and there is an alternative instance type that provides better
     *        memory performance. This is identified by analyzing the memory utilization metric of the current instance
     *        during the look-back period.
     *        </p>
     *        <note>
     *        <p>
     *        Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on
     *        them. For more information, see <a
     *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory
     *        utilization with the Amazon CloudWatch Agent</a> in the <i>Compute Optimizer User Guide</i>. On Linux
     *        instances, Compute Optimizer analyses the <code>mem_used_percent</code> metric in the <code>CWAgent</code>
     *        namespace, or the legacy <code>MemoryUtilization</code> metric in the <code>System/Linux</code> namespace.
     *        On Windows instances, Compute Optimizer analyses the <code>Memory % Committed Bytes In Use</code> metric
     *        in the <code>CWAgent</code> namespace.
     *        </p>
     *        </note></li>
     *        <li>
     *        <p>
     *        <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be
     *        sized down while still meeting the performance requirements of your workload. This is identified by
     *        analyzing the <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metrics of EBS volumes
     *        attached to the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn't
     *        meet the performance requirements of your workload and there is an alternative instance type that provides
     *        better EBS throughput performance. This is identified by analyzing the <code>VolumeReadBytes</code> and
     *        <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current instance during the look-back
     *        period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down
     *        while still meeting the performance requirements of your workload. This is identified by analyzing the
     *        <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metric of EBS volumes attached to the current
     *        instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn't meet the
     *        performance requirements of your workload and there is an alternative instance type that provides better
     *        EBS IOPS performance. This is identified by analyzing the <code>VolumeReadOps</code> and
     *        <code>VolumeWriteOps</code> metric of EBS volumes attached to the current instance during the look-back
     *        period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration can
     *        be sized down while still meeting the performance requirements of your workload. This is identified by
     *        analyzing the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance during
     *        the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration
     *        doesn't meet the performance requirements of your workload and there is an alternative instance type that
     *        provides better network bandwidth performance. This is identified by analyzing the <code>NetworkIn</code>
     *        and <code>NetworkOut</code> metrics of the current instance during the look-back period. This finding
     *        reason happens when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is
     *        impacted.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second)
     *        configuration can be sized down while still meeting the performance requirements of your workload. This is
     *        identified by analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the
     *        current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second)
     *        configuration doesn't meet the performance requirements of your workload and there is an alternative
     *        instance type that provides better network PPS performance. This is identified by analyzing the
     *        <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance during the
     *        look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down
     *        while still meeting the performance requirements of your workload. This is identified by analyzing the
     *        <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the
     *        look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn't meet the
     *        performance requirements of your workload and there is an alternative instance type that provides better
     *        disk IOPS performance. This is identified by analyzing the <code>DiskReadOps</code> and
     *        <code>DiskWriteOps</code> metrics of the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be
     *        sized down while still meeting the performance requirements of your workload. This is identified by
     *        analyzing the <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance
     *        during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration
     *        doesn't meet the performance requirements of your workload and there is an alternative instance type that
     *        provides better disk throughput performance. This is identified by analyzing the
     *        <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the
     *        look-back period.
     *        </p>
     *        </li>
     *        </ul>
     *        <note>
     *        <p>
     *        For more information about instance metrics, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
     *        available CloudWatch metrics for your instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     *        For more information about EBS volume metrics, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch
     *        metrics for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InstanceRecommendationFindingReasonCode
     */

    public InstanceRecommendation withFindingReasonCodes(java.util.Collection<String> findingReasonCodes) {
        setFindingReasonCodes(findingReasonCodes);
        return this;
    }

    /**
     * <p>
     * The reason for the finding classification of the instance.
     * </p>
     * <p>
     * Finding reason codes for instances include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still meeting
     * the performance requirements of your workload. This is identified by analyzing the <code>CPUUtilization</code>
     * metric of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type that provides better CPU performance.
     * This is identified by analyzing the <code>CPUUtilization</code> metric of the current instance during the
     * look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while still
     * meeting the performance requirements of your workload. This is identified by analyzing the memory utilization
     * metric of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn't meet the performance
     * requirements of your workload and there is an alternative instance type that provides better memory performance.
     * This is identified by analyzing the memory utilization metric of the current instance during the look-back
     * period.
     * </p>
     * <note>
     * <p>
     * Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on them. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory utilization
     * with the Amazon CloudWatch Agent</a> in the <i>Compute Optimizer User Guide</i>. On Linux instances, Compute
     * Optimizer analyses the <code>mem_used_percent</code> metric in the <code>CWAgent</code> namespace, or the legacy
     * <code>MemoryUtilization</code> metric in the <code>System/Linux</code> namespace. On Windows instances, Compute
     * Optimizer analyses the <code>Memory % Committed Bytes In Use</code> metric in the <code>CWAgent</code> namespace.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be sized
     * down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current
     * instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn't meet
     * the performance requirements of your workload and there is an alternative instance type that provides better EBS
     * throughput performance. This is identified by analyzing the <code>VolumeReadBytes</code> and
     * <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down while
     * still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metric of EBS volumes attached to the current instance
     * during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn't meet the
     * performance requirements of your workload and there is an alternative instance type that provides better EBS IOPS
     * performance. This is identified by analyzing the <code>VolumeReadOps</code> and <code>VolumeWriteOps</code>
     * metric of EBS volumes attached to the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration can be
     * sized down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration doesn't
     * meet the performance requirements of your workload and there is an alternative instance type that provides better
     * network bandwidth performance. This is identified by analyzing the <code>NetworkIn</code> and
     * <code>NetworkOut</code> metrics of the current instance during the look-back period. This finding reason happens
     * when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is impacted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration
     * can be sized down while still meeting the performance requirements of your workload. This is identified by
     * analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance
     * during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration
     * doesn't meet the performance requirements of your workload and there is an alternative instance type that
     * provides better network PPS performance. This is identified by analyzing the <code>NetworkPacketsIn</code> and
     * <code>NetworkPacketsIn</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down while
     * still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn't meet the
     * performance requirements of your workload and there is an alternative instance type that provides better disk
     * IOPS performance. This is identified by analyzing the <code>DiskReadOps</code> and <code>DiskWriteOps</code>
     * metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be sized
     * down while still meeting the performance requirements of your workload. This is identified by analyzing the
     * <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the look-back
     * period.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration doesn't meet
     * the performance requirements of your workload and there is an alternative instance type that provides better disk
     * throughput performance. This is identified by analyzing the <code>DiskReadBytes</code> and
     * <code>DiskWriteBytes</code> metrics of the current instance during the look-back period.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * For more information about instance metrics, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
     * available CloudWatch metrics for your instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For
     * more information about EBS volume metrics, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch metrics
     * for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </note>
     * 
     * @param findingReasonCodes
     *        The reason for the finding classification of the instance.</p>
     *        <p>
     *        Finding reason codes for instances include:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still
     *        meeting the performance requirements of your workload. This is identified by analyzing the
     *        <code>CPUUtilization</code> metric of the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn't meet the performance
     *        requirements of your workload and there is an alternative instance type that provides better CPU
     *        performance. This is identified by analyzing the <code>CPUUtilization</code> metric of the current
     *        instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while
     *        still meeting the performance requirements of your workload. This is identified by analyzing the memory
     *        utilization metric of the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn't meet the
     *        performance requirements of your workload and there is an alternative instance type that provides better
     *        memory performance. This is identified by analyzing the memory utilization metric of the current instance
     *        during the look-back period.
     *        </p>
     *        <note>
     *        <p>
     *        Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on
     *        them. For more information, see <a
     *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory
     *        utilization with the Amazon CloudWatch Agent</a> in the <i>Compute Optimizer User Guide</i>. On Linux
     *        instances, Compute Optimizer analyses the <code>mem_used_percent</code> metric in the <code>CWAgent</code>
     *        namespace, or the legacy <code>MemoryUtilization</code> metric in the <code>System/Linux</code> namespace.
     *        On Windows instances, Compute Optimizer analyses the <code>Memory % Committed Bytes In Use</code> metric
     *        in the <code>CWAgent</code> namespace.
     *        </p>
     *        </note></li>
     *        <li>
     *        <p>
     *        <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be
     *        sized down while still meeting the performance requirements of your workload. This is identified by
     *        analyzing the <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metrics of EBS volumes
     *        attached to the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn't
     *        meet the performance requirements of your workload and there is an alternative instance type that provides
     *        better EBS throughput performance. This is identified by analyzing the <code>VolumeReadBytes</code> and
     *        <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current instance during the look-back
     *        period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down
     *        while still meeting the performance requirements of your workload. This is identified by analyzing the
     *        <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metric of EBS volumes attached to the current
     *        instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn't meet the
     *        performance requirements of your workload and there is an alternative instance type that provides better
     *        EBS IOPS performance. This is identified by analyzing the <code>VolumeReadOps</code> and
     *        <code>VolumeWriteOps</code> metric of EBS volumes attached to the current instance during the look-back
     *        period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration can
     *        be sized down while still meeting the performance requirements of your workload. This is identified by
     *        analyzing the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance during
     *        the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration
     *        doesn't meet the performance requirements of your workload and there is an alternative instance type that
     *        provides better network bandwidth performance. This is identified by analyzing the <code>NetworkIn</code>
     *        and <code>NetworkOut</code> metrics of the current instance during the look-back period. This finding
     *        reason happens when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is
     *        impacted.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second)
     *        configuration can be sized down while still meeting the performance requirements of your workload. This is
     *        identified by analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the
     *        current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second)
     *        configuration doesn't meet the performance requirements of your workload and there is an alternative
     *        instance type that provides better network PPS performance. This is identified by analyzing the
     *        <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance during the
     *        look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down
     *        while still meeting the performance requirements of your workload. This is identified by analyzing the
     *        <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the
     *        look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn't meet the
     *        performance requirements of your workload and there is an alternative instance type that provides better
     *        disk IOPS performance. This is identified by analyzing the <code>DiskReadOps</code> and
     *        <code>DiskWriteOps</code> metrics of the current instance during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be
     *        sized down while still meeting the performance requirements of your workload. This is identified by
     *        analyzing the <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance
     *        during the look-back period.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration
     *        doesn't meet the performance requirements of your workload and there is an alternative instance type that
     *        provides better disk throughput performance. This is identified by analyzing the
     *        <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the
     *        look-back period.
     *        </p>
     *        </li>
     *        </ul>
     *        <note>
     *        <p>
     *        For more information about instance metrics, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the
     *        available CloudWatch metrics for your instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     *        For more information about EBS volume metrics, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch
     *        metrics for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InstanceRecommendationFindingReasonCode
     */

    public InstanceRecommendation withFindingReasonCodes(InstanceRecommendationFindingReasonCode... findingReasonCodes) {
        java.util.ArrayList<String> findingReasonCodesCopy = new java.util.ArrayList<String>(findingReasonCodes.length);
        for (InstanceRecommendationFindingReasonCode value : findingReasonCodes) {
            findingReasonCodesCopy.add(value.toString());
        }
        if (getFindingReasonCodes() == null) {
            setFindingReasonCodes(findingReasonCodesCopy);
        } else {
            getFindingReasonCodes().addAll(findingReasonCodesCopy);
        }
        return this;
    }

    /**
     * <p>
     * An array of objects that describe the utilization metrics of the instance.
     * </p>
     * 
     * @return An array of objects that describe the utilization metrics of the instance.
     */

    public java.util.List<UtilizationMetric> getUtilizationMetrics() {
        return utilizationMetrics;
    }

    /**
     * <p>
     * An array of objects that describe the utilization metrics of the instance.
     * </p>
     * 
     * @param utilizationMetrics
     *        An array of objects that describe the utilization metrics of the instance.
     */

    public void setUtilizationMetrics(java.util.Collection<UtilizationMetric> utilizationMetrics) {
        if (utilizationMetrics == null) {
            this.utilizationMetrics = null;
            return;
        }

        this.utilizationMetrics = new java.util.ArrayList<UtilizationMetric>(utilizationMetrics);
    }

    /**
     * <p>
     * An array of objects that describe the utilization metrics of the instance.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setUtilizationMetrics(java.util.Collection)} or {@link #withUtilizationMetrics(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param utilizationMetrics
     *        An array of objects that describe the utilization metrics of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withUtilizationMetrics(UtilizationMetric... utilizationMetrics) {
        if (this.utilizationMetrics == null) {
            setUtilizationMetrics(new java.util.ArrayList<UtilizationMetric>(utilizationMetrics.length));
        }
        for (UtilizationMetric ele : utilizationMetrics) {
            this.utilizationMetrics.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of objects that describe the utilization metrics of the instance.
     * </p>
     * 
     * @param utilizationMetrics
     *        An array of objects that describe the utilization metrics of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withUtilizationMetrics(java.util.Collection<UtilizationMetric> utilizationMetrics) {
        setUtilizationMetrics(utilizationMetrics);
        return this;
    }

    /**
     * <p>
     * The number of days for which utilization metrics were analyzed for the instance.
     * </p>
     * 
     * @param lookBackPeriodInDays
     *        The number of days for which utilization metrics were analyzed for the instance.
     */

    public void setLookBackPeriodInDays(Double lookBackPeriodInDays) {
        this.lookBackPeriodInDays = lookBackPeriodInDays;
    }

    /**
     * <p>
     * The number of days for which utilization metrics were analyzed for the instance.
     * </p>
     * 
     * @return The number of days for which utilization metrics were analyzed for the instance.
     */

    public Double getLookBackPeriodInDays() {
        return this.lookBackPeriodInDays;
    }

    /**
     * <p>
     * The number of days for which utilization metrics were analyzed for the instance.
     * </p>
     * 
     * @param lookBackPeriodInDays
     *        The number of days for which utilization metrics were analyzed for the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withLookBackPeriodInDays(Double lookBackPeriodInDays) {
        setLookBackPeriodInDays(lookBackPeriodInDays);
        return this;
    }

    /**
     * <p>
     * An array of objects that describe the recommendation options for the instance.
     * </p>
     * 
     * @return An array of objects that describe the recommendation options for the instance.
     */

    public java.util.List<InstanceRecommendationOption> getRecommendationOptions() {
        return recommendationOptions;
    }

    /**
     * <p>
     * An array of objects that describe the recommendation options for the instance.
     * </p>
     * 
     * @param recommendationOptions
     *        An array of objects that describe the recommendation options for the instance.
     */

    public void setRecommendationOptions(java.util.Collection<InstanceRecommendationOption> recommendationOptions) {
        if (recommendationOptions == null) {
            this.recommendationOptions = null;
            return;
        }

        this.recommendationOptions = new java.util.ArrayList<InstanceRecommendationOption>(recommendationOptions);
    }

    /**
     * <p>
     * An array of objects that describe the recommendation options for the instance.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRecommendationOptions(java.util.Collection)} or
     * {@link #withRecommendationOptions(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param recommendationOptions
     *        An array of objects that describe the recommendation options for the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withRecommendationOptions(InstanceRecommendationOption... recommendationOptions) {
        if (this.recommendationOptions == null) {
            setRecommendationOptions(new java.util.ArrayList<InstanceRecommendationOption>(recommendationOptions.length));
        }
        for (InstanceRecommendationOption ele : recommendationOptions) {
            this.recommendationOptions.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of objects that describe the recommendation options for the instance.
     * </p>
     * 
     * @param recommendationOptions
     *        An array of objects that describe the recommendation options for the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withRecommendationOptions(java.util.Collection<InstanceRecommendationOption> recommendationOptions) {
        setRecommendationOptions(recommendationOptions);
        return this;
    }

    /**
     * <p>
     * An array of objects that describe the source resource of the recommendation.
     * </p>
     * 
     * @return An array of objects that describe the source resource of the recommendation.
     */

    public java.util.List<RecommendationSource> getRecommendationSources() {
        return recommendationSources;
    }

    /**
     * <p>
     * An array of objects that describe the source resource of the recommendation.
     * </p>
     * 
     * @param recommendationSources
     *        An array of objects that describe the source resource of the recommendation.
     */

    public void setRecommendationSources(java.util.Collection<RecommendationSource> recommendationSources) {
        if (recommendationSources == null) {
            this.recommendationSources = null;
            return;
        }

        this.recommendationSources = new java.util.ArrayList<RecommendationSource>(recommendationSources);
    }

    /**
     * <p>
     * An array of objects that describe the source resource of the recommendation.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRecommendationSources(java.util.Collection)} or
     * {@link #withRecommendationSources(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param recommendationSources
     *        An array of objects that describe the source resource of the recommendation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withRecommendationSources(RecommendationSource... recommendationSources) {
        if (this.recommendationSources == null) {
            setRecommendationSources(new java.util.ArrayList<RecommendationSource>(recommendationSources.length));
        }
        for (RecommendationSource ele : recommendationSources) {
            this.recommendationSources.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of objects that describe the source resource of the recommendation.
     * </p>
     * 
     * @param recommendationSources
     *        An array of objects that describe the source resource of the recommendation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withRecommendationSources(java.util.Collection<RecommendationSource> recommendationSources) {
        setRecommendationSources(recommendationSources);
        return this;
    }

    /**
     * <p>
     * The timestamp of when the instance recommendation was last generated.
     * </p>
     * 
     * @param lastRefreshTimestamp
     *        The timestamp of when the instance recommendation was last generated.
     */

    public void setLastRefreshTimestamp(java.util.Date lastRefreshTimestamp) {
        this.lastRefreshTimestamp = lastRefreshTimestamp;
    }

    /**
     * <p>
     * The timestamp of when the instance recommendation was last generated.
     * </p>
     * 
     * @return The timestamp of when the instance recommendation was last generated.
     */

    public java.util.Date getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    /**
     * <p>
     * The timestamp of when the instance recommendation was last generated.
     * </p>
     * 
     * @param lastRefreshTimestamp
     *        The timestamp of when the instance recommendation was last generated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withLastRefreshTimestamp(java.util.Date lastRefreshTimestamp) {
        setLastRefreshTimestamp(lastRefreshTimestamp);
        return this;
    }

    /**
     * <p>
     * The risk of the current instance not meeting the performance needs of its workloads. The higher the risk, the
     * more likely the current instance cannot meet the performance requirements of its workload.
     * </p>
     * 
     * @param currentPerformanceRisk
     *        The risk of the current instance not meeting the performance needs of its workloads. The higher the risk,
     *        the more likely the current instance cannot meet the performance requirements of its workload.
     * @see CurrentPerformanceRisk
     */

    public void setCurrentPerformanceRisk(String currentPerformanceRisk) {
        this.currentPerformanceRisk = currentPerformanceRisk;
    }

    /**
     * <p>
     * The risk of the current instance not meeting the performance needs of its workloads. The higher the risk, the
     * more likely the current instance cannot meet the performance requirements of its workload.
     * </p>
     * 
     * @return The risk of the current instance not meeting the performance needs of its workloads. The higher the risk,
     *         the more likely the current instance cannot meet the performance requirements of its workload.
     * @see CurrentPerformanceRisk
     */

    public String getCurrentPerformanceRisk() {
        return this.currentPerformanceRisk;
    }

    /**
     * <p>
     * The risk of the current instance not meeting the performance needs of its workloads. The higher the risk, the
     * more likely the current instance cannot meet the performance requirements of its workload.
     * </p>
     * 
     * @param currentPerformanceRisk
     *        The risk of the current instance not meeting the performance needs of its workloads. The higher the risk,
     *        the more likely the current instance cannot meet the performance requirements of its workload.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CurrentPerformanceRisk
     */

    public InstanceRecommendation withCurrentPerformanceRisk(String currentPerformanceRisk) {
        setCurrentPerformanceRisk(currentPerformanceRisk);
        return this;
    }

    /**
     * <p>
     * The risk of the current instance not meeting the performance needs of its workloads. The higher the risk, the
     * more likely the current instance cannot meet the performance requirements of its workload.
     * </p>
     * 
     * @param currentPerformanceRisk
     *        The risk of the current instance not meeting the performance needs of its workloads. The higher the risk,
     *        the more likely the current instance cannot meet the performance requirements of its workload.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CurrentPerformanceRisk
     */

    public InstanceRecommendation withCurrentPerformanceRisk(CurrentPerformanceRisk currentPerformanceRisk) {
        this.currentPerformanceRisk = currentPerformanceRisk.toString();
        return this;
    }

    /**
     * <p>
     * An object that describes the effective recommendation preferences for the instance.
     * </p>
     * 
     * @param effectiveRecommendationPreferences
     *        An object that describes the effective recommendation preferences for the instance.
     */

    public void setEffectiveRecommendationPreferences(EffectiveRecommendationPreferences effectiveRecommendationPreferences) {
        this.effectiveRecommendationPreferences = effectiveRecommendationPreferences;
    }

    /**
     * <p>
     * An object that describes the effective recommendation preferences for the instance.
     * </p>
     * 
     * @return An object that describes the effective recommendation preferences for the instance.
     */

    public EffectiveRecommendationPreferences getEffectiveRecommendationPreferences() {
        return this.effectiveRecommendationPreferences;
    }

    /**
     * <p>
     * An object that describes the effective recommendation preferences for the instance.
     * </p>
     * 
     * @param effectiveRecommendationPreferences
     *        An object that describes the effective recommendation preferences for the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withEffectiveRecommendationPreferences(EffectiveRecommendationPreferences effectiveRecommendationPreferences) {
        setEffectiveRecommendationPreferences(effectiveRecommendationPreferences);
        return this;
    }

    /**
     * <p>
     * The applications that might be running on the instance as inferred by Compute Optimizer.
     * </p>
     * <p>
     * Compute Optimizer can infer if one of the following applications might be running on the instance:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AmazonEmr</code> - Infers that Amazon EMR might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApacheCassandra</code> - Infers that Apache Cassandra might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApacheHadoop</code> - Infers that Apache Hadoop might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Memcached</code> - Infers that Memcached might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NGINX</code> - Infers that NGINX might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PostgreSql</code> - Infers that PostgreSQL might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Redis</code> - Infers that Redis might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Kafka</code> - Infers that Kafka might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SQLServer</code> - Infers that SQLServer might be running on the instance.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The applications that might be running on the instance as inferred by Compute Optimizer.</p>
     *         <p>
     *         Compute Optimizer can infer if one of the following applications might be running on the instance:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AmazonEmr</code> - Infers that Amazon EMR might be running on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApacheCassandra</code> - Infers that Apache Cassandra might be running on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ApacheHadoop</code> - Infers that Apache Hadoop might be running on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Memcached</code> - Infers that Memcached might be running on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NGINX</code> - Infers that NGINX might be running on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PostgreSql</code> - Infers that PostgreSQL might be running on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Redis</code> - Infers that Redis might be running on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Kafka</code> - Infers that Kafka might be running on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SQLServer</code> - Infers that SQLServer might be running on the instance.
     *         </p>
     *         </li>
     * @see InferredWorkloadType
     */

    public java.util.List<String> getInferredWorkloadTypes() {
        return inferredWorkloadTypes;
    }

    /**
     * <p>
     * The applications that might be running on the instance as inferred by Compute Optimizer.
     * </p>
     * <p>
     * Compute Optimizer can infer if one of the following applications might be running on the instance:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AmazonEmr</code> - Infers that Amazon EMR might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApacheCassandra</code> - Infers that Apache Cassandra might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApacheHadoop</code> - Infers that Apache Hadoop might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Memcached</code> - Infers that Memcached might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NGINX</code> - Infers that NGINX might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PostgreSql</code> - Infers that PostgreSQL might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Redis</code> - Infers that Redis might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Kafka</code> - Infers that Kafka might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SQLServer</code> - Infers that SQLServer might be running on the instance.
     * </p>
     * </li>
     * </ul>
     * 
     * @param inferredWorkloadTypes
     *        The applications that might be running on the instance as inferred by Compute Optimizer.</p>
     *        <p>
     *        Compute Optimizer can infer if one of the following applications might be running on the instance:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>AmazonEmr</code> - Infers that Amazon EMR might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>ApacheCassandra</code> - Infers that Apache Cassandra might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>ApacheHadoop</code> - Infers that Apache Hadoop might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Memcached</code> - Infers that Memcached might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>NGINX</code> - Infers that NGINX might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>PostgreSql</code> - Infers that PostgreSQL might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Redis</code> - Infers that Redis might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Kafka</code> - Infers that Kafka might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>SQLServer</code> - Infers that SQLServer might be running on the instance.
     *        </p>
     *        </li>
     * @see InferredWorkloadType
     */

    public void setInferredWorkloadTypes(java.util.Collection<String> inferredWorkloadTypes) {
        if (inferredWorkloadTypes == null) {
            this.inferredWorkloadTypes = null;
            return;
        }

        this.inferredWorkloadTypes = new java.util.ArrayList<String>(inferredWorkloadTypes);
    }

    /**
     * <p>
     * The applications that might be running on the instance as inferred by Compute Optimizer.
     * </p>
     * <p>
     * Compute Optimizer can infer if one of the following applications might be running on the instance:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AmazonEmr</code> - Infers that Amazon EMR might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApacheCassandra</code> - Infers that Apache Cassandra might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApacheHadoop</code> - Infers that Apache Hadoop might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Memcached</code> - Infers that Memcached might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NGINX</code> - Infers that NGINX might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PostgreSql</code> - Infers that PostgreSQL might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Redis</code> - Infers that Redis might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Kafka</code> - Infers that Kafka might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SQLServer</code> - Infers that SQLServer might be running on the instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setInferredWorkloadTypes(java.util.Collection)} or
     * {@link #withInferredWorkloadTypes(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param inferredWorkloadTypes
     *        The applications that might be running on the instance as inferred by Compute Optimizer.</p>
     *        <p>
     *        Compute Optimizer can infer if one of the following applications might be running on the instance:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>AmazonEmr</code> - Infers that Amazon EMR might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>ApacheCassandra</code> - Infers that Apache Cassandra might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>ApacheHadoop</code> - Infers that Apache Hadoop might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Memcached</code> - Infers that Memcached might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>NGINX</code> - Infers that NGINX might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>PostgreSql</code> - Infers that PostgreSQL might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Redis</code> - Infers that Redis might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Kafka</code> - Infers that Kafka might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>SQLServer</code> - Infers that SQLServer might be running on the instance.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InferredWorkloadType
     */

    public InstanceRecommendation withInferredWorkloadTypes(String... inferredWorkloadTypes) {
        if (this.inferredWorkloadTypes == null) {
            setInferredWorkloadTypes(new java.util.ArrayList<String>(inferredWorkloadTypes.length));
        }
        for (String ele : inferredWorkloadTypes) {
            this.inferredWorkloadTypes.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The applications that might be running on the instance as inferred by Compute Optimizer.
     * </p>
     * <p>
     * Compute Optimizer can infer if one of the following applications might be running on the instance:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AmazonEmr</code> - Infers that Amazon EMR might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApacheCassandra</code> - Infers that Apache Cassandra might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApacheHadoop</code> - Infers that Apache Hadoop might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Memcached</code> - Infers that Memcached might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NGINX</code> - Infers that NGINX might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PostgreSql</code> - Infers that PostgreSQL might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Redis</code> - Infers that Redis might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Kafka</code> - Infers that Kafka might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SQLServer</code> - Infers that SQLServer might be running on the instance.
     * </p>
     * </li>
     * </ul>
     * 
     * @param inferredWorkloadTypes
     *        The applications that might be running on the instance as inferred by Compute Optimizer.</p>
     *        <p>
     *        Compute Optimizer can infer if one of the following applications might be running on the instance:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>AmazonEmr</code> - Infers that Amazon EMR might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>ApacheCassandra</code> - Infers that Apache Cassandra might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>ApacheHadoop</code> - Infers that Apache Hadoop might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Memcached</code> - Infers that Memcached might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>NGINX</code> - Infers that NGINX might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>PostgreSql</code> - Infers that PostgreSQL might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Redis</code> - Infers that Redis might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Kafka</code> - Infers that Kafka might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>SQLServer</code> - Infers that SQLServer might be running on the instance.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InferredWorkloadType
     */

    public InstanceRecommendation withInferredWorkloadTypes(java.util.Collection<String> inferredWorkloadTypes) {
        setInferredWorkloadTypes(inferredWorkloadTypes);
        return this;
    }

    /**
     * <p>
     * The applications that might be running on the instance as inferred by Compute Optimizer.
     * </p>
     * <p>
     * Compute Optimizer can infer if one of the following applications might be running on the instance:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AmazonEmr</code> - Infers that Amazon EMR might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApacheCassandra</code> - Infers that Apache Cassandra might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ApacheHadoop</code> - Infers that Apache Hadoop might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Memcached</code> - Infers that Memcached might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NGINX</code> - Infers that NGINX might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PostgreSql</code> - Infers that PostgreSQL might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Redis</code> - Infers that Redis might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Kafka</code> - Infers that Kafka might be running on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SQLServer</code> - Infers that SQLServer might be running on the instance.
     * </p>
     * </li>
     * </ul>
     * 
     * @param inferredWorkloadTypes
     *        The applications that might be running on the instance as inferred by Compute Optimizer.</p>
     *        <p>
     *        Compute Optimizer can infer if one of the following applications might be running on the instance:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>AmazonEmr</code> - Infers that Amazon EMR might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>ApacheCassandra</code> - Infers that Apache Cassandra might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>ApacheHadoop</code> - Infers that Apache Hadoop might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Memcached</code> - Infers that Memcached might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>NGINX</code> - Infers that NGINX might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>PostgreSql</code> - Infers that PostgreSQL might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Redis</code> - Infers that Redis might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Kafka</code> - Infers that Kafka might be running on the instance.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>SQLServer</code> - Infers that SQLServer might be running on the instance.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InferredWorkloadType
     */

    public InstanceRecommendation withInferredWorkloadTypes(InferredWorkloadType... inferredWorkloadTypes) {
        java.util.ArrayList<String> inferredWorkloadTypesCopy = new java.util.ArrayList<String>(inferredWorkloadTypes.length);
        for (InferredWorkloadType value : inferredWorkloadTypes) {
            inferredWorkloadTypesCopy.add(value.toString());
        }
        if (getInferredWorkloadTypes() == null) {
            setInferredWorkloadTypes(inferredWorkloadTypesCopy);
        } else {
            getInferredWorkloadTypes().addAll(inferredWorkloadTypesCopy);
        }
        return this;
    }

    /**
     * <p>
     * The state of the instance when the recommendation was generated.
     * </p>
     * 
     * @param instanceState
     *        The state of the instance when the recommendation was generated.
     * @see InstanceState
     */

    public void setInstanceState(String instanceState) {
        this.instanceState = instanceState;
    }

    /**
     * <p>
     * The state of the instance when the recommendation was generated.
     * </p>
     * 
     * @return The state of the instance when the recommendation was generated.
     * @see InstanceState
     */

    public String getInstanceState() {
        return this.instanceState;
    }

    /**
     * <p>
     * The state of the instance when the recommendation was generated.
     * </p>
     * 
     * @param instanceState
     *        The state of the instance when the recommendation was generated.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InstanceState
     */

    public InstanceRecommendation withInstanceState(String instanceState) {
        setInstanceState(instanceState);
        return this;
    }

    /**
     * <p>
     * The state of the instance when the recommendation was generated.
     * </p>
     * 
     * @param instanceState
     *        The state of the instance when the recommendation was generated.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InstanceState
     */

    public InstanceRecommendation withInstanceState(InstanceState instanceState) {
        this.instanceState = instanceState.toString();
        return this;
    }

    /**
     * <p>
     * A list of tags assigned to your Amazon EC2 instance recommendations.
     * </p>
     * 
     * @return A list of tags assigned to your Amazon EC2 instance recommendations.
     */

    public java.util.List<Tag> getTags() {
        return tags;
    }

    /**
     * <p>
     * A list of tags assigned to your Amazon EC2 instance recommendations.
     * </p>
     * 
     * @param tags
     *        A list of tags assigned to your Amazon EC2 instance recommendations.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new java.util.ArrayList<Tag>(tags);
    }

    /**
     * <p>
     * A list of tags assigned to your Amazon EC2 instance recommendations.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        A list of tags assigned to your Amazon EC2 instance recommendations.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new java.util.ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of tags assigned to your Amazon EC2 instance recommendations.
     * </p>
     * 
     * @param tags
     *        A list of tags assigned to your Amazon EC2 instance recommendations.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * <p>
     * An object that describes Compute Optimizer's integration status with your external metrics provider.
     * </p>
     * 
     * @param externalMetricStatus
     *        An object that describes Compute Optimizer's integration status with your external metrics provider.
     */

    public void setExternalMetricStatus(ExternalMetricStatus externalMetricStatus) {
        this.externalMetricStatus = externalMetricStatus;
    }

    /**
     * <p>
     * An object that describes Compute Optimizer's integration status with your external metrics provider.
     * </p>
     * 
     * @return An object that describes Compute Optimizer's integration status with your external metrics provider.
     */

    public ExternalMetricStatus getExternalMetricStatus() {
        return this.externalMetricStatus;
    }

    /**
     * <p>
     * An object that describes Compute Optimizer's integration status with your external metrics provider.
     * </p>
     * 
     * @param externalMetricStatus
     *        An object that describes Compute Optimizer's integration status with your external metrics provider.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withExternalMetricStatus(ExternalMetricStatus externalMetricStatus) {
        setExternalMetricStatus(externalMetricStatus);
        return this;
    }

    /**
     * <p>
     * Describes the GPU accelerator settings for the current instance type.
     * </p>
     * 
     * @param currentInstanceGpuInfo
     *        Describes the GPU accelerator settings for the current instance type.
     */

    public void setCurrentInstanceGpuInfo(GpuInfo currentInstanceGpuInfo) {
        this.currentInstanceGpuInfo = currentInstanceGpuInfo;
    }

    /**
     * <p>
     * Describes the GPU accelerator settings for the current instance type.
     * </p>
     * 
     * @return Describes the GPU accelerator settings for the current instance type.
     */

    public GpuInfo getCurrentInstanceGpuInfo() {
        return this.currentInstanceGpuInfo;
    }

    /**
     * <p>
     * Describes the GPU accelerator settings for the current instance type.
     * </p>
     * 
     * @param currentInstanceGpuInfo
     *        Describes the GPU accelerator settings for the current instance type.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InstanceRecommendation withCurrentInstanceGpuInfo(GpuInfo currentInstanceGpuInfo) {
        setCurrentInstanceGpuInfo(currentInstanceGpuInfo);
        return this;
    }

    /**
     * <p>
     * Describes if an Amazon EC2 instance is idle.
     * </p>
     * 
     * @param idle
     *        Describes if an Amazon EC2 instance is idle.
     * @see InstanceIdle
     */

    public void setIdle(String idle) {
        this.idle = idle;
    }

    /**
     * <p>
     * Describes if an Amazon EC2 instance is idle.
     * </p>
     * 
     * @return Describes if an Amazon EC2 instance is idle.
     * @see InstanceIdle
     */

    public String getIdle() {
        return this.idle;
    }

    /**
     * <p>
     * Describes if an Amazon EC2 instance is idle.
     * </p>
     * 
     * @param idle
     *        Describes if an Amazon EC2 instance is idle.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InstanceIdle
     */

    public InstanceRecommendation withIdle(String idle) {
        setIdle(idle);
        return this;
    }

    /**
     * <p>
     * Describes if an Amazon EC2 instance is idle.
     * </p>
     * 
     * @param idle
     *        Describes if an Amazon EC2 instance is idle.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see InstanceIdle
     */

    public InstanceRecommendation withIdle(InstanceIdle idle) {
        this.idle = idle.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getInstanceArn() != null)
            sb.append("InstanceArn: ").append(getInstanceArn()).append(",");
        if (getAccountId() != null)
            sb.append("AccountId: ").append(getAccountId()).append(",");
        if (getInstanceName() != null)
            sb.append("InstanceName: ").append(getInstanceName()).append(",");
        if (getCurrentInstanceType() != null)
            sb.append("CurrentInstanceType: ").append(getCurrentInstanceType()).append(",");
        if (getFinding() != null)
            sb.append("Finding: ").append(getFinding()).append(",");
        if (getFindingReasonCodes() != null)
            sb.append("FindingReasonCodes: ").append(getFindingReasonCodes()).append(",");
        if (getUtilizationMetrics() != null)
            sb.append("UtilizationMetrics: ").append(getUtilizationMetrics()).append(",");
        if (getLookBackPeriodInDays() != null)
            sb.append("LookBackPeriodInDays: ").append(getLookBackPeriodInDays()).append(",");
        if (getRecommendationOptions() != null)
            sb.append("RecommendationOptions: ").append(getRecommendationOptions()).append(",");
        if (getRecommendationSources() != null)
            sb.append("RecommendationSources: ").append(getRecommendationSources()).append(",");
        if (getLastRefreshTimestamp() != null)
            sb.append("LastRefreshTimestamp: ").append(getLastRefreshTimestamp()).append(",");
        if (getCurrentPerformanceRisk() != null)
            sb.append("CurrentPerformanceRisk: ").append(getCurrentPerformanceRisk()).append(",");
        if (getEffectiveRecommendationPreferences() != null)
            sb.append("EffectiveRecommendationPreferences: ").append(getEffectiveRecommendationPreferences()).append(",");
        if (getInferredWorkloadTypes() != null)
            sb.append("InferredWorkloadTypes: ").append(getInferredWorkloadTypes()).append(",");
        if (getInstanceState() != null)
            sb.append("InstanceState: ").append(getInstanceState()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getExternalMetricStatus() != null)
            sb.append("ExternalMetricStatus: ").append(getExternalMetricStatus()).append(",");
        if (getCurrentInstanceGpuInfo() != null)
            sb.append("CurrentInstanceGpuInfo: ").append(getCurrentInstanceGpuInfo()).append(",");
        if (getIdle() != null)
            sb.append("Idle: ").append(getIdle());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof InstanceRecommendation == false)
            return false;
        InstanceRecommendation other = (InstanceRecommendation) obj;
        if (other.getInstanceArn() == null ^ this.getInstanceArn() == null)
            return false;
        if (other.getInstanceArn() != null && other.getInstanceArn().equals(this.getInstanceArn()) == false)
            return false;
        if (other.getAccountId() == null ^ this.getAccountId() == null)
            return false;
        if (other.getAccountId() != null && other.getAccountId().equals(this.getAccountId()) == false)
            return false;
        if (other.getInstanceName() == null ^ this.getInstanceName() == null)
            return false;
        if (other.getInstanceName() != null && other.getInstanceName().equals(this.getInstanceName()) == false)
            return false;
        if (other.getCurrentInstanceType() == null ^ this.getCurrentInstanceType() == null)
            return false;
        if (other.getCurrentInstanceType() != null && other.getCurrentInstanceType().equals(this.getCurrentInstanceType()) == false)
            return false;
        if (other.getFinding() == null ^ this.getFinding() == null)
            return false;
        if (other.getFinding() != null && other.getFinding().equals(this.getFinding()) == false)
            return false;
        if (other.getFindingReasonCodes() == null ^ this.getFindingReasonCodes() == null)
            return false;
        if (other.getFindingReasonCodes() != null && other.getFindingReasonCodes().equals(this.getFindingReasonCodes()) == false)
            return false;
        if (other.getUtilizationMetrics() == null ^ this.getUtilizationMetrics() == null)
            return false;
        if (other.getUtilizationMetrics() != null && other.getUtilizationMetrics().equals(this.getUtilizationMetrics()) == false)
            return false;
        if (other.getLookBackPeriodInDays() == null ^ this.getLookBackPeriodInDays() == null)
            return false;
        if (other.getLookBackPeriodInDays() != null && other.getLookBackPeriodInDays().equals(this.getLookBackPeriodInDays()) == false)
            return false;
        if (other.getRecommendationOptions() == null ^ this.getRecommendationOptions() == null)
            return false;
        if (other.getRecommendationOptions() != null && other.getRecommendationOptions().equals(this.getRecommendationOptions()) == false)
            return false;
        if (other.getRecommendationSources() == null ^ this.getRecommendationSources() == null)
            return false;
        if (other.getRecommendationSources() != null && other.getRecommendationSources().equals(this.getRecommendationSources()) == false)
            return false;
        if (other.getLastRefreshTimestamp() == null ^ this.getLastRefreshTimestamp() == null)
            return false;
        if (other.getLastRefreshTimestamp() != null && other.getLastRefreshTimestamp().equals(this.getLastRefreshTimestamp()) == false)
            return false;
        if (other.getCurrentPerformanceRisk() == null ^ this.getCurrentPerformanceRisk() == null)
            return false;
        if (other.getCurrentPerformanceRisk() != null && other.getCurrentPerformanceRisk().equals(this.getCurrentPerformanceRisk()) == false)
            return false;
        if (other.getEffectiveRecommendationPreferences() == null ^ this.getEffectiveRecommendationPreferences() == null)
            return false;
        if (other.getEffectiveRecommendationPreferences() != null
                && other.getEffectiveRecommendationPreferences().equals(this.getEffectiveRecommendationPreferences()) == false)
            return false;
        if (other.getInferredWorkloadTypes() == null ^ this.getInferredWorkloadTypes() == null)
            return false;
        if (other.getInferredWorkloadTypes() != null && other.getInferredWorkloadTypes().equals(this.getInferredWorkloadTypes()) == false)
            return false;
        if (other.getInstanceState() == null ^ this.getInstanceState() == null)
            return false;
        if (other.getInstanceState() != null && other.getInstanceState().equals(this.getInstanceState()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getExternalMetricStatus() == null ^ this.getExternalMetricStatus() == null)
            return false;
        if (other.getExternalMetricStatus() != null && other.getExternalMetricStatus().equals(this.getExternalMetricStatus()) == false)
            return false;
        if (other.getCurrentInstanceGpuInfo() == null ^ this.getCurrentInstanceGpuInfo() == null)
            return false;
        if (other.getCurrentInstanceGpuInfo() != null && other.getCurrentInstanceGpuInfo().equals(this.getCurrentInstanceGpuInfo()) == false)
            return false;
        if (other.getIdle() == null ^ this.getIdle() == null)
            return false;
        if (other.getIdle() != null && other.getIdle().equals(this.getIdle()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getInstanceArn() == null) ? 0 : getInstanceArn().hashCode());
        hashCode = prime * hashCode + ((getAccountId() == null) ? 0 : getAccountId().hashCode());
        hashCode = prime * hashCode + ((getInstanceName() == null) ? 0 : getInstanceName().hashCode());
        hashCode = prime * hashCode + ((getCurrentInstanceType() == null) ? 0 : getCurrentInstanceType().hashCode());
        hashCode = prime * hashCode + ((getFinding() == null) ? 0 : getFinding().hashCode());
        hashCode = prime * hashCode + ((getFindingReasonCodes() == null) ? 0 : getFindingReasonCodes().hashCode());
        hashCode = prime * hashCode + ((getUtilizationMetrics() == null) ? 0 : getUtilizationMetrics().hashCode());
        hashCode = prime * hashCode + ((getLookBackPeriodInDays() == null) ? 0 : getLookBackPeriodInDays().hashCode());
        hashCode = prime * hashCode + ((getRecommendationOptions() == null) ? 0 : getRecommendationOptions().hashCode());
        hashCode = prime * hashCode + ((getRecommendationSources() == null) ? 0 : getRecommendationSources().hashCode());
        hashCode = prime * hashCode + ((getLastRefreshTimestamp() == null) ? 0 : getLastRefreshTimestamp().hashCode());
        hashCode = prime * hashCode + ((getCurrentPerformanceRisk() == null) ? 0 : getCurrentPerformanceRisk().hashCode());
        hashCode = prime * hashCode + ((getEffectiveRecommendationPreferences() == null) ? 0 : getEffectiveRecommendationPreferences().hashCode());
        hashCode = prime * hashCode + ((getInferredWorkloadTypes() == null) ? 0 : getInferredWorkloadTypes().hashCode());
        hashCode = prime * hashCode + ((getInstanceState() == null) ? 0 : getInstanceState().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getExternalMetricStatus() == null) ? 0 : getExternalMetricStatus().hashCode());
        hashCode = prime * hashCode + ((getCurrentInstanceGpuInfo() == null) ? 0 : getCurrentInstanceGpuInfo().hashCode());
        hashCode = prime * hashCode + ((getIdle() == null) ? 0 : getIdle().hashCode());
        return hashCode;
    }

    @Override
    public InstanceRecommendation clone() {
        try {
            return (InstanceRecommendation) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.computeoptimizer.model.transform.InstanceRecommendationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
