/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.LambdaFunctionMemoryProjectedMetric;
import com.amazonaws.services.computeoptimizer.model.transform.LambdaFunctionMemoryRecommendationOptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LambdaFunctionMemoryRecommendationOption
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer rank;
    private Integer memorySize;
    private List<LambdaFunctionMemoryProjectedMetric> projectedUtilizationMetrics;

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Integer getRank() {
        return this.rank;
    }

    public LambdaFunctionMemoryRecommendationOption withRank(Integer rank) {
        this.setRank(rank);
        return this;
    }

    public void setMemorySize(Integer memorySize) {
        this.memorySize = memorySize;
    }

    public Integer getMemorySize() {
        return this.memorySize;
    }

    public LambdaFunctionMemoryRecommendationOption withMemorySize(Integer memorySize) {
        this.setMemorySize(memorySize);
        return this;
    }

    public List<LambdaFunctionMemoryProjectedMetric> getProjectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics;
    }

    public void setProjectedUtilizationMetrics(Collection<LambdaFunctionMemoryProjectedMetric> projectedUtilizationMetrics) {
        if (projectedUtilizationMetrics == null) {
            this.projectedUtilizationMetrics = null;
            return;
        }
        this.projectedUtilizationMetrics = new ArrayList<LambdaFunctionMemoryProjectedMetric>(projectedUtilizationMetrics);
    }

    public LambdaFunctionMemoryRecommendationOption withProjectedUtilizationMetrics(LambdaFunctionMemoryProjectedMetric ... projectedUtilizationMetrics) {
        if (this.projectedUtilizationMetrics == null) {
            this.setProjectedUtilizationMetrics(new ArrayList<LambdaFunctionMemoryProjectedMetric>(projectedUtilizationMetrics.length));
        }
        for (LambdaFunctionMemoryProjectedMetric ele : projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics.add(ele);
        }
        return this;
    }

    public LambdaFunctionMemoryRecommendationOption withProjectedUtilizationMetrics(Collection<LambdaFunctionMemoryProjectedMetric> projectedUtilizationMetrics) {
        this.setProjectedUtilizationMetrics(projectedUtilizationMetrics);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRank() != null) {
            sb.append("Rank: ").append(this.getRank()).append(",");
        }
        if (this.getMemorySize() != null) {
            sb.append("MemorySize: ").append(this.getMemorySize()).append(",");
        }
        if (this.getProjectedUtilizationMetrics() != null) {
            sb.append("ProjectedUtilizationMetrics: ").append(this.getProjectedUtilizationMetrics());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionMemoryRecommendationOption)) {
            return false;
        }
        LambdaFunctionMemoryRecommendationOption other = (LambdaFunctionMemoryRecommendationOption)obj;
        if (other.getRank() == null ^ this.getRank() == null) {
            return false;
        }
        if (other.getRank() != null && !other.getRank().equals(this.getRank())) {
            return false;
        }
        if (other.getMemorySize() == null ^ this.getMemorySize() == null) {
            return false;
        }
        if (other.getMemorySize() != null && !other.getMemorySize().equals(this.getMemorySize())) {
            return false;
        }
        if (other.getProjectedUtilizationMetrics() == null ^ this.getProjectedUtilizationMetrics() == null) {
            return false;
        }
        return other.getProjectedUtilizationMetrics() == null || other.getProjectedUtilizationMetrics().equals(this.getProjectedUtilizationMetrics());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRank() == null ? 0 : this.getRank().hashCode());
        hashCode = 31 * hashCode + (this.getMemorySize() == null ? 0 : this.getMemorySize().hashCode());
        hashCode = 31 * hashCode + (this.getProjectedUtilizationMetrics() == null ? 0 : this.getProjectedUtilizationMetrics().hashCode());
        return hashCode;
    }

    public LambdaFunctionMemoryRecommendationOption clone() {
        try {
            return (LambdaFunctionMemoryRecommendationOption)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaFunctionMemoryRecommendationOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

