/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.config.model.ConfigRule;
import com.amazonaws.services.config.model.transform.ScopeJsonMarshaller;
import com.amazonaws.services.config.model.transform.SourceJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ConfigRuleJsonMarshaller {
    private static ConfigRuleJsonMarshaller instance;

    public void marshall(ConfigRule configRule, JSONWriter jsonWriter) {
        if (configRule == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (configRule.getConfigRuleName() != null) {
                jsonWriter.key("ConfigRuleName").value((Object)configRule.getConfigRuleName());
            }
            if (configRule.getConfigRuleArn() != null) {
                jsonWriter.key("ConfigRuleArn").value((Object)configRule.getConfigRuleArn());
            }
            if (configRule.getConfigRuleId() != null) {
                jsonWriter.key("ConfigRuleId").value((Object)configRule.getConfigRuleId());
            }
            if (configRule.getDescription() != null) {
                jsonWriter.key("Description").value((Object)configRule.getDescription());
            }
            if (configRule.getScope() != null) {
                jsonWriter.key("Scope");
                ScopeJsonMarshaller.getInstance().marshall(configRule.getScope(), jsonWriter);
            }
            if (configRule.getSource() != null) {
                jsonWriter.key("Source");
                SourceJsonMarshaller.getInstance().marshall(configRule.getSource(), jsonWriter);
            }
            if (configRule.getInputParameters() != null) {
                jsonWriter.key("InputParameters").value((Object)configRule.getInputParameters());
            }
            if (configRule.getMaximumExecutionFrequency() != null) {
                jsonWriter.key("MaximumExecutionFrequency").value((Object)configRule.getMaximumExecutionFrequency());
            }
            if (configRule.getConfigRuleState() != null) {
                jsonWriter.key("ConfigRuleState").value((Object)configRule.getConfigRuleState());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConfigRuleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConfigRuleJsonMarshaller();
        }
        return instance;
    }
}

