/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.Scope;
import com.amazonaws.util.json.SdkJsonGenerator;

public class ScopeJsonMarshaller {
    private static ScopeJsonMarshaller instance;

    public void marshall(Scope scope, SdkJsonGenerator jsonGenerator) {
        if (scope == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalList complianceResourceTypesList = (SdkInternalList)scope.getComplianceResourceTypes();
            if (!complianceResourceTypesList.isEmpty() || !complianceResourceTypesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ComplianceResourceTypes");
                jsonGenerator.writeStartArray();
                for (String complianceResourceTypesListValue : complianceResourceTypesList) {
                    if (complianceResourceTypesListValue == null) continue;
                    jsonGenerator.writeValue(complianceResourceTypesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (scope.getTagKey() != null) {
                jsonGenerator.writeFieldName("TagKey").writeValue(scope.getTagKey());
            }
            if (scope.getTagValue() != null) {
                jsonGenerator.writeFieldName("TagValue").writeValue(scope.getTagValue());
            }
            if (scope.getComplianceResourceId() != null) {
                jsonGenerator.writeFieldName("ComplianceResourceId").writeValue(scope.getComplianceResourceId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ScopeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ScopeJsonMarshaller();
        }
        return instance;
    }
}

