/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateHoursOfOperation" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateHoursOfOperationRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     */
    private String instanceId;
    /**
     * <p>
     * The name of the hours of operation.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The description of the hours of operation.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The time zone of the hours of operation.
     * </p>
     */
    private String timeZone;
    /**
     * <p>
     * Configuration information for the hours of operation: day, start time, and end time.
     * </p>
     */
    private java.util.List<HoursOfOperationConfig> config;
    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     */
    private java.util.Map<String, String> tags;

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @param instanceId
     *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */

    public String getInstanceId() {
        return this.instanceId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @param instanceId
     *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateHoursOfOperationRequest withInstanceId(String instanceId) {
        setInstanceId(instanceId);
        return this;
    }

    /**
     * <p>
     * The name of the hours of operation.
     * </p>
     * 
     * @param name
     *        The name of the hours of operation.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the hours of operation.
     * </p>
     * 
     * @return The name of the hours of operation.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the hours of operation.
     * </p>
     * 
     * @param name
     *        The name of the hours of operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateHoursOfOperationRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The description of the hours of operation.
     * </p>
     * 
     * @param description
     *        The description of the hours of operation.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * The description of the hours of operation.
     * </p>
     * 
     * @return The description of the hours of operation.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * The description of the hours of operation.
     * </p>
     * 
     * @param description
     *        The description of the hours of operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateHoursOfOperationRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The time zone of the hours of operation.
     * </p>
     * 
     * @param timeZone
     *        The time zone of the hours of operation.
     */

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    /**
     * <p>
     * The time zone of the hours of operation.
     * </p>
     * 
     * @return The time zone of the hours of operation.
     */

    public String getTimeZone() {
        return this.timeZone;
    }

    /**
     * <p>
     * The time zone of the hours of operation.
     * </p>
     * 
     * @param timeZone
     *        The time zone of the hours of operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateHoursOfOperationRequest withTimeZone(String timeZone) {
        setTimeZone(timeZone);
        return this;
    }

    /**
     * <p>
     * Configuration information for the hours of operation: day, start time, and end time.
     * </p>
     * 
     * @return Configuration information for the hours of operation: day, start time, and end time.
     */

    public java.util.List<HoursOfOperationConfig> getConfig() {
        return config;
    }

    /**
     * <p>
     * Configuration information for the hours of operation: day, start time, and end time.
     * </p>
     * 
     * @param config
     *        Configuration information for the hours of operation: day, start time, and end time.
     */

    public void setConfig(java.util.Collection<HoursOfOperationConfig> config) {
        if (config == null) {
            this.config = null;
            return;
        }

        this.config = new java.util.ArrayList<HoursOfOperationConfig>(config);
    }

    /**
     * <p>
     * Configuration information for the hours of operation: day, start time, and end time.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setConfig(java.util.Collection)} or {@link #withConfig(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param config
     *        Configuration information for the hours of operation: day, start time, and end time.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateHoursOfOperationRequest withConfig(HoursOfOperationConfig... config) {
        if (this.config == null) {
            setConfig(new java.util.ArrayList<HoursOfOperationConfig>(config.length));
        }
        for (HoursOfOperationConfig ele : config) {
            this.config.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Configuration information for the hours of operation: day, start time, and end time.
     * </p>
     * 
     * @param config
     *        Configuration information for the hours of operation: day, start time, and end time.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateHoursOfOperationRequest withConfig(java.util.Collection<HoursOfOperationConfig> config) {
        setConfig(config);
        return this;
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * 
     * @param tags
     *        The tags used to organize, track, or control access for this resource. For example, { "tags":
     *        {"key1":"value1", "key2":"value2"} }.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * 
     * @param tags
     *        The tags used to organize, track, or control access for this resource. For example, { "tags":
     *        {"key1":"value1", "key2":"value2"} }.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateHoursOfOperationRequest withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see CreateHoursOfOperationRequest#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public CreateHoursOfOperationRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateHoursOfOperationRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getInstanceId() != null)
            sb.append("InstanceId: ").append(getInstanceId()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getTimeZone() != null)
            sb.append("TimeZone: ").append(getTimeZone()).append(",");
        if (getConfig() != null)
            sb.append("Config: ").append(getConfig()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateHoursOfOperationRequest == false)
            return false;
        CreateHoursOfOperationRequest other = (CreateHoursOfOperationRequest) obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null)
            return false;
        if (other.getInstanceId() != null && other.getInstanceId().equals(this.getInstanceId()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getTimeZone() == null ^ this.getTimeZone() == null)
            return false;
        if (other.getTimeZone() != null && other.getTimeZone().equals(this.getTimeZone()) == false)
            return false;
        if (other.getConfig() == null ^ this.getConfig() == null)
            return false;
        if (other.getConfig() != null && other.getConfig().equals(this.getConfig()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getInstanceId() == null) ? 0 : getInstanceId().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getTimeZone() == null) ? 0 : getTimeZone().hashCode());
        hashCode = prime * hashCode + ((getConfig() == null) ? 0 : getConfig().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateHoursOfOperationRequest clone() {
        return (CreateHoursOfOperationRequest) super.clone();
    }

}
