/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricDataV2" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetMetricDataV2Request extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource. This includes the <code>instanceId</code> an Amazon Connect
     * instance.
     * </p>
     */
    private String resourceArn;
    /**
     * <p>
     * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
     * historical metrics data. The time must be before the end time timestamp. The time range between the start and end
     * time must be less than 24 hours. The start time cannot be earlier than 14 days before the time of the request.
     * Historical metrics are available for 14 days.
     * </p>
     */
    private java.util.Date startTime;
    /**
     * <p>
     * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical
     * metrics data. The time must be later than the start time timestamp.
     * </p>
     * <p>
     * The time range between the start and end time must be less than 24 hours.
     * </p>
     */
    private java.util.Date endTime;
    /**
     * <p>
     * The filters to apply to returned metrics. You can filter on the following resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Queues
     * </p>
     * </li>
     * <li>
     * <p>
     * Routing profiles
     * </p>
     * </li>
     * <li>
     * <p>
     * Agents
     * </p>
     * </li>
     * <li>
     * <p>
     * Channels
     * </p>
     * </li>
     * <li>
     * <p>
     * User hierarchy groups
     * </p>
     * </li>
     * </ul>
     * <p>
     * At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
     * </p>
     * <p>
     * To filter by phone number, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create a
     * historical metrics report</a> in the <i>Amazon Connect Administrator's Guide</i>.
     * </p>
     * <p>
     * Note the following limits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
     * <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> | <code>CHANNEL</code> |
     * <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     * <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     * <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. For example, a
     * <code>GetMetricDataV2</code> request can filter by 50 queues, 35 agents, and 15 routing profiles for a total of
     * 100 filter values. <code>VOICE</code>, <code>CHAT</code>, and <code>TASK</code> are valid
     * <code>filterValue</code> for the <code>CHANNEL</code> filter key.
     * </p>
     * </li>
     * </ul>
     */
    private java.util.List<FilterV2> filters;
    /**
     * <p>
     * The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the
     * metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue. They are
     * not aggregated for all queues.
     * </p>
     * <p>
     * If no grouping is specified, a summary of all metrics is returned.
     * </p>
     * <p>
     * Valid grouping keys: <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> |
     * <code>CHANNEL</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     * <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     * <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     * </p>
     */
    private java.util.List<String> groupings;
    /**
     * <p>
     * The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following historical
     * metrics are available. For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * metrics definitions</a> in the <i>Amazon Connect Administrator's Guide</i>.
     * </p>
     * <dl>
     * <dt>AGENT_ADHERENT_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_NON_RESPONSE</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_OCCUPANCY</dt>
     * <dd>
     * <p>
     * Unit: Percentage
     * </p>
     * <p>
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_SCHEDULE_ADHERENCE</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_SCHEDULED_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_ABANDON_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_AGENT_CONNECTING_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following as
     * <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
     * <code>API</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_HANDLE_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_INTERACTION_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>AVG_QUEUE_ANSWER_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>CONTACTS_ABANDONED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_CREATED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_HOLD_ABANDONS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_QUEUED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>MAX_QUEUED_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>SERVICE_LEVEL</dt>
     * <dd>
     * <p>
     * You can include up to 20 SERVICE_LEVEL metrics in a request.
     * </p>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_DISCONNECTED</dt>
     * <dd>
     * <p>
     * Valid metric filter key: <code>DISCONNECT_REASON</code>
     * </p>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * </dl>
     */
    private java.util.List<MetricV2> metrics;
    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     */
    private Integer maxResults;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource. This includes the <code>instanceId</code> an Amazon Connect
     * instance.
     * </p>
     * 
     * @param resourceArn
     *        The Amazon Resource Name (ARN) of the resource. This includes the <code>instanceId</code> an Amazon
     *        Connect instance.
     */

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource. This includes the <code>instanceId</code> an Amazon Connect
     * instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource. This includes the <code>instanceId</code> an Amazon
     *         Connect instance.
     */

    public String getResourceArn() {
        return this.resourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource. This includes the <code>instanceId</code> an Amazon Connect
     * instance.
     * </p>
     * 
     * @param resourceArn
     *        The Amazon Resource Name (ARN) of the resource. This includes the <code>instanceId</code> an Amazon
     *        Connect instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMetricDataV2Request withResourceArn(String resourceArn) {
        setResourceArn(resourceArn);
        return this;
    }

    /**
     * <p>
     * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
     * historical metrics data. The time must be before the end time timestamp. The time range between the start and end
     * time must be less than 24 hours. The start time cannot be earlier than 14 days before the time of the request.
     * Historical metrics are available for 14 days.
     * </p>
     * 
     * @param startTime
     *        The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
     *        historical metrics data. The time must be before the end time timestamp. The time range between the start
     *        and end time must be less than 24 hours. The start time cannot be earlier than 14 days before the time of
     *        the request. Historical metrics are available for 14 days.
     */

    public void setStartTime(java.util.Date startTime) {
        this.startTime = startTime;
    }

    /**
     * <p>
     * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
     * historical metrics data. The time must be before the end time timestamp. The time range between the start and end
     * time must be less than 24 hours. The start time cannot be earlier than 14 days before the time of the request.
     * Historical metrics are available for 14 days.
     * </p>
     * 
     * @return The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
     *         historical metrics data. The time must be before the end time timestamp. The time range between the start
     *         and end time must be less than 24 hours. The start time cannot be earlier than 14 days before the time of
     *         the request. Historical metrics are available for 14 days.
     */

    public java.util.Date getStartTime() {
        return this.startTime;
    }

    /**
     * <p>
     * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
     * historical metrics data. The time must be before the end time timestamp. The time range between the start and end
     * time must be less than 24 hours. The start time cannot be earlier than 14 days before the time of the request.
     * Historical metrics are available for 14 days.
     * </p>
     * 
     * @param startTime
     *        The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
     *        historical metrics data. The time must be before the end time timestamp. The time range between the start
     *        and end time must be less than 24 hours. The start time cannot be earlier than 14 days before the time of
     *        the request. Historical metrics are available for 14 days.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMetricDataV2Request withStartTime(java.util.Date startTime) {
        setStartTime(startTime);
        return this;
    }

    /**
     * <p>
     * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical
     * metrics data. The time must be later than the start time timestamp.
     * </p>
     * <p>
     * The time range between the start and end time must be less than 24 hours.
     * </p>
     * 
     * @param endTime
     *        The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of
     *        historical metrics data. The time must be later than the start time timestamp.</p>
     *        <p>
     *        The time range between the start and end time must be less than 24 hours.
     */

    public void setEndTime(java.util.Date endTime) {
        this.endTime = endTime;
    }

    /**
     * <p>
     * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical
     * metrics data. The time must be later than the start time timestamp.
     * </p>
     * <p>
     * The time range between the start and end time must be less than 24 hours.
     * </p>
     * 
     * @return The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of
     *         historical metrics data. The time must be later than the start time timestamp.</p>
     *         <p>
     *         The time range between the start and end time must be less than 24 hours.
     */

    public java.util.Date getEndTime() {
        return this.endTime;
    }

    /**
     * <p>
     * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical
     * metrics data. The time must be later than the start time timestamp.
     * </p>
     * <p>
     * The time range between the start and end time must be less than 24 hours.
     * </p>
     * 
     * @param endTime
     *        The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of
     *        historical metrics data. The time must be later than the start time timestamp.</p>
     *        <p>
     *        The time range between the start and end time must be less than 24 hours.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMetricDataV2Request withEndTime(java.util.Date endTime) {
        setEndTime(endTime);
        return this;
    }

    /**
     * <p>
     * The filters to apply to returned metrics. You can filter on the following resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Queues
     * </p>
     * </li>
     * <li>
     * <p>
     * Routing profiles
     * </p>
     * </li>
     * <li>
     * <p>
     * Agents
     * </p>
     * </li>
     * <li>
     * <p>
     * Channels
     * </p>
     * </li>
     * <li>
     * <p>
     * User hierarchy groups
     * </p>
     * </li>
     * </ul>
     * <p>
     * At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
     * </p>
     * <p>
     * To filter by phone number, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create a
     * historical metrics report</a> in the <i>Amazon Connect Administrator's Guide</i>.
     * </p>
     * <p>
     * Note the following limits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
     * <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> | <code>CHANNEL</code> |
     * <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     * <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     * <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. For example, a
     * <code>GetMetricDataV2</code> request can filter by 50 queues, 35 agents, and 15 routing profiles for a total of
     * 100 filter values. <code>VOICE</code>, <code>CHAT</code>, and <code>TASK</code> are valid
     * <code>filterValue</code> for the <code>CHANNEL</code> filter key.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The filters to apply to returned metrics. You can filter on the following resources:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Queues
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Routing profiles
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Agents
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Channels
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         User hierarchy groups
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
     *         </p>
     *         <p>
     *         To filter by phone number, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create
     *         a historical metrics report</a> in the <i>Amazon Connect Administrator's Guide</i>.
     *         </p>
     *         <p>
     *         Note the following limits:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
     *         <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> | <code>CHANNEL</code> |
     *         <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     *         <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     *         <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. For example, a
     *         <code>GetMetricDataV2</code> request can filter by 50 queues, 35 agents, and 15 routing profiles for a
     *         total of 100 filter values. <code>VOICE</code>, <code>CHAT</code>, and <code>TASK</code> are valid
     *         <code>filterValue</code> for the <code>CHANNEL</code> filter key.
     *         </p>
     *         </li>
     */

    public java.util.List<FilterV2> getFilters() {
        return filters;
    }

    /**
     * <p>
     * The filters to apply to returned metrics. You can filter on the following resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Queues
     * </p>
     * </li>
     * <li>
     * <p>
     * Routing profiles
     * </p>
     * </li>
     * <li>
     * <p>
     * Agents
     * </p>
     * </li>
     * <li>
     * <p>
     * Channels
     * </p>
     * </li>
     * <li>
     * <p>
     * User hierarchy groups
     * </p>
     * </li>
     * </ul>
     * <p>
     * At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
     * </p>
     * <p>
     * To filter by phone number, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create a
     * historical metrics report</a> in the <i>Amazon Connect Administrator's Guide</i>.
     * </p>
     * <p>
     * Note the following limits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
     * <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> | <code>CHANNEL</code> |
     * <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     * <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     * <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. For example, a
     * <code>GetMetricDataV2</code> request can filter by 50 queues, 35 agents, and 15 routing profiles for a total of
     * 100 filter values. <code>VOICE</code>, <code>CHAT</code>, and <code>TASK</code> are valid
     * <code>filterValue</code> for the <code>CHANNEL</code> filter key.
     * </p>
     * </li>
     * </ul>
     * 
     * @param filters
     *        The filters to apply to returned metrics. You can filter on the following resources:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        Queues
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Routing profiles
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Agents
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Channels
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        User hierarchy groups
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
     *        </p>
     *        <p>
     *        To filter by phone number, see <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create
     *        a historical metrics report</a> in the <i>Amazon Connect Administrator's Guide</i>.
     *        </p>
     *        <p>
     *        Note the following limits:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
     *        <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> | <code>CHANNEL</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. For example, a
     *        <code>GetMetricDataV2</code> request can filter by 50 queues, 35 agents, and 15 routing profiles for a
     *        total of 100 filter values. <code>VOICE</code>, <code>CHAT</code>, and <code>TASK</code> are valid
     *        <code>filterValue</code> for the <code>CHANNEL</code> filter key.
     *        </p>
     *        </li>
     */

    public void setFilters(java.util.Collection<FilterV2> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }

        this.filters = new java.util.ArrayList<FilterV2>(filters);
    }

    /**
     * <p>
     * The filters to apply to returned metrics. You can filter on the following resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Queues
     * </p>
     * </li>
     * <li>
     * <p>
     * Routing profiles
     * </p>
     * </li>
     * <li>
     * <p>
     * Agents
     * </p>
     * </li>
     * <li>
     * <p>
     * Channels
     * </p>
     * </li>
     * <li>
     * <p>
     * User hierarchy groups
     * </p>
     * </li>
     * </ul>
     * <p>
     * At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
     * </p>
     * <p>
     * To filter by phone number, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create a
     * historical metrics report</a> in the <i>Amazon Connect Administrator's Guide</i>.
     * </p>
     * <p>
     * Note the following limits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
     * <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> | <code>CHANNEL</code> |
     * <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     * <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     * <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. For example, a
     * <code>GetMetricDataV2</code> request can filter by 50 queues, 35 agents, and 15 routing profiles for a total of
     * 100 filter values. <code>VOICE</code>, <code>CHAT</code>, and <code>TASK</code> are valid
     * <code>filterValue</code> for the <code>CHANNEL</code> filter key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setFilters(java.util.Collection)} or {@link #withFilters(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param filters
     *        The filters to apply to returned metrics. You can filter on the following resources:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        Queues
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Routing profiles
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Agents
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Channels
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        User hierarchy groups
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
     *        </p>
     *        <p>
     *        To filter by phone number, see <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create
     *        a historical metrics report</a> in the <i>Amazon Connect Administrator's Guide</i>.
     *        </p>
     *        <p>
     *        Note the following limits:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
     *        <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> | <code>CHANNEL</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. For example, a
     *        <code>GetMetricDataV2</code> request can filter by 50 queues, 35 agents, and 15 routing profiles for a
     *        total of 100 filter values. <code>VOICE</code>, <code>CHAT</code>, and <code>TASK</code> are valid
     *        <code>filterValue</code> for the <code>CHANNEL</code> filter key.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMetricDataV2Request withFilters(FilterV2... filters) {
        if (this.filters == null) {
            setFilters(new java.util.ArrayList<FilterV2>(filters.length));
        }
        for (FilterV2 ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The filters to apply to returned metrics. You can filter on the following resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Queues
     * </p>
     * </li>
     * <li>
     * <p>
     * Routing profiles
     * </p>
     * </li>
     * <li>
     * <p>
     * Agents
     * </p>
     * </li>
     * <li>
     * <p>
     * Channels
     * </p>
     * </li>
     * <li>
     * <p>
     * User hierarchy groups
     * </p>
     * </li>
     * </ul>
     * <p>
     * At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
     * </p>
     * <p>
     * To filter by phone number, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create a
     * historical metrics report</a> in the <i>Amazon Connect Administrator's Guide</i>.
     * </p>
     * <p>
     * Note the following limits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
     * <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> | <code>CHANNEL</code> |
     * <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     * <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     * <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. For example, a
     * <code>GetMetricDataV2</code> request can filter by 50 queues, 35 agents, and 15 routing profiles for a total of
     * 100 filter values. <code>VOICE</code>, <code>CHAT</code>, and <code>TASK</code> are valid
     * <code>filterValue</code> for the <code>CHANNEL</code> filter key.
     * </p>
     * </li>
     * </ul>
     * 
     * @param filters
     *        The filters to apply to returned metrics. You can filter on the following resources:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        Queues
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Routing profiles
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Agents
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Channels
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        User hierarchy groups
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.
     *        </p>
     *        <p>
     *        To filter by phone number, see <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create
     *        a historical metrics report</a> in the <i>Amazon Connect Administrator's Guide</i>.
     *        </p>
     *        <p>
     *        Note the following limits:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys:
     *        <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> | <code>CHANNEL</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. For example, a
     *        <code>GetMetricDataV2</code> request can filter by 50 queues, 35 agents, and 15 routing profiles for a
     *        total of 100 filter values. <code>VOICE</code>, <code>CHAT</code>, and <code>TASK</code> are valid
     *        <code>filterValue</code> for the <code>CHANNEL</code> filter key.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMetricDataV2Request withFilters(java.util.Collection<FilterV2> filters) {
        setFilters(filters);
        return this;
    }

    /**
     * <p>
     * The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the
     * metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue. They are
     * not aggregated for all queues.
     * </p>
     * <p>
     * If no grouping is specified, a summary of all metrics is returned.
     * </p>
     * <p>
     * Valid grouping keys: <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> |
     * <code>CHANNEL</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     * <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     * <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     * </p>
     * 
     * @return The grouping applied to the metrics that are returned. For example, when results are grouped by queue,
     *         the metrics returned are grouped by queue. The values that are returned apply to the metrics for each
     *         queue. They are not aggregated for all queues.</p>
     *         <p>
     *         If no grouping is specified, a summary of all metrics is returned.
     *         </p>
     *         <p>
     *         Valid grouping keys: <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> |
     *         <code>CHANNEL</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     *         <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     *         <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     */

    public java.util.List<String> getGroupings() {
        return groupings;
    }

    /**
     * <p>
     * The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the
     * metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue. They are
     * not aggregated for all queues.
     * </p>
     * <p>
     * If no grouping is specified, a summary of all metrics is returned.
     * </p>
     * <p>
     * Valid grouping keys: <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> |
     * <code>CHANNEL</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     * <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     * <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     * </p>
     * 
     * @param groupings
     *        The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the
     *        metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue.
     *        They are not aggregated for all queues.</p>
     *        <p>
     *        If no grouping is specified, a summary of all metrics is returned.
     *        </p>
     *        <p>
     *        Valid grouping keys: <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> |
     *        <code>CHANNEL</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     */

    public void setGroupings(java.util.Collection<String> groupings) {
        if (groupings == null) {
            this.groupings = null;
            return;
        }

        this.groupings = new java.util.ArrayList<String>(groupings);
    }

    /**
     * <p>
     * The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the
     * metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue. They are
     * not aggregated for all queues.
     * </p>
     * <p>
     * If no grouping is specified, a summary of all metrics is returned.
     * </p>
     * <p>
     * Valid grouping keys: <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> |
     * <code>CHANNEL</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     * <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     * <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setGroupings(java.util.Collection)} or {@link #withGroupings(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param groupings
     *        The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the
     *        metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue.
     *        They are not aggregated for all queues.</p>
     *        <p>
     *        If no grouping is specified, a summary of all metrics is returned.
     *        </p>
     *        <p>
     *        Valid grouping keys: <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> |
     *        <code>CHANNEL</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMetricDataV2Request withGroupings(String... groupings) {
        if (this.groupings == null) {
            setGroupings(new java.util.ArrayList<String>(groupings.length));
        }
        for (String ele : groupings) {
            this.groupings.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the
     * metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue. They are
     * not aggregated for all queues.
     * </p>
     * <p>
     * If no grouping is specified, a summary of all metrics is returned.
     * </p>
     * <p>
     * Valid grouping keys: <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> |
     * <code>CHANNEL</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     * <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     * <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     * </p>
     * 
     * @param groupings
     *        The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the
     *        metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue.
     *        They are not aggregated for all queues.</p>
     *        <p>
     *        If no grouping is specified, a summary of all metrics is returned.
     *        </p>
     *        <p>
     *        Valid grouping keys: <code>QUEUE</code> | <code>ROUTING_PROFILE</code> | <code>AGENT</code> |
     *        <code>CHANNEL</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> |
     *        <code>AGENT_HIERARCHY_LEVEL_FIVE</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMetricDataV2Request withGroupings(java.util.Collection<String> groupings) {
        setGroupings(groupings);
        return this;
    }

    /**
     * <p>
     * The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following historical
     * metrics are available. For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * metrics definitions</a> in the <i>Amazon Connect Administrator's Guide</i>.
     * </p>
     * <dl>
     * <dt>AGENT_ADHERENT_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_NON_RESPONSE</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_OCCUPANCY</dt>
     * <dd>
     * <p>
     * Unit: Percentage
     * </p>
     * <p>
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_SCHEDULE_ADHERENCE</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_SCHEDULED_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_ABANDON_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_AGENT_CONNECTING_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following as
     * <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
     * <code>API</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_HANDLE_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_INTERACTION_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>AVG_QUEUE_ANSWER_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>CONTACTS_ABANDONED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_CREATED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_HOLD_ABANDONS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_QUEUED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>MAX_QUEUED_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>SERVICE_LEVEL</dt>
     * <dd>
     * <p>
     * You can include up to 20 SERVICE_LEVEL metrics in a request.
     * </p>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_DISCONNECTED</dt>
     * <dd>
     * <p>
     * Valid metric filter key: <code>DISCONNECT_REASON</code>
     * </p>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * </dl>
     * 
     * @return The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following
     *         historical metrics are available. For a description of each metric, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html"
     *         >Historical metrics definitions</a> in the <i>Amazon Connect Administrator's Guide</i>.</p>
     *         <dl>
     *         <dt>AGENT_ADHERENT_TIME</dt>
     *         <dd>
     *         <p>
     *         This metric is available only in Amazon Web Services Regions where <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region"
     *         >Forecasting, capacity planning, and scheduling</a> is available.
     *         </p>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>AGENT_NON_RESPONSE</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>AGENT_OCCUPANCY</dt>
     *         <dd>
     *         <p>
     *         Unit: Percentage
     *         </p>
     *         <p>
     *         Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>AGENT_SCHEDULE_ADHERENCE</dt>
     *         <dd>
     *         <p>
     *         This metric is available only in Amazon Web Services Regions where <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region"
     *         >Forecasting, capacity planning, and scheduling</a> is available.
     *         </p>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>AGENT_SCHEDULED_TIME</dt>
     *         <dd>
     *         <p>
     *         This metric is available only in Amazon Web Services Regions where <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region"
     *         >Forecasting, capacity planning, and scheduling</a> is available.
     *         </p>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>AVG_ABANDON_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>AVG_AGENT_CONNECTING_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following
     *         as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
     *         <code>API</code>
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>AVG_HANDLE_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>AVG_HOLD_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>AVG_INTERACTION_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile
     *         </p>
     *         </dd>
     *         <dt>AVG_QUEUE_ANSWER_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_ABANDONED</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_CREATED</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid metric filter key: <code>INITIATION_METHOD</code>
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HOLD_ABANDONS</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_QUEUED</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>MAX_QUEUED_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: Seconds
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *         </p>
     *         </dd>
     *         <dt>SERVICE_LEVEL</dt>
     *         <dd>
     *         <p>
     *         You can include up to 20 SERVICE_LEVEL metrics in a request.
     *         </p>
     *         <p>
     *         Unit: Percent
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile
     *         </p>
     *         <p>
     *         Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
     *         seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     *         </p>
     *         </dd>
     *         <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile
     *         </p>
     *         </dd>
     *         <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile
     *         </p>
     *         </dd>
     *         <dt>SUM_CONTACTS_DISCONNECTED</dt>
     *         <dd>
     *         <p>
     *         Valid metric filter key: <code>DISCONNECT_REASON</code>
     *         </p>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile
     *         </p>
     *         </dd>
     *         <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
     *         <dd>
     *         <p>
     *         Unit: Count
     *         </p>
     *         <p>
     *         Valid groupings and filters: Queue, Channel, Routing Profile
     *         </p>
     *         </dd>
     */

    public java.util.List<MetricV2> getMetrics() {
        return metrics;
    }

    /**
     * <p>
     * The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following historical
     * metrics are available. For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * metrics definitions</a> in the <i>Amazon Connect Administrator's Guide</i>.
     * </p>
     * <dl>
     * <dt>AGENT_ADHERENT_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_NON_RESPONSE</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_OCCUPANCY</dt>
     * <dd>
     * <p>
     * Unit: Percentage
     * </p>
     * <p>
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_SCHEDULE_ADHERENCE</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_SCHEDULED_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_ABANDON_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_AGENT_CONNECTING_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following as
     * <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
     * <code>API</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_HANDLE_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_INTERACTION_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>AVG_QUEUE_ANSWER_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>CONTACTS_ABANDONED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_CREATED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_HOLD_ABANDONS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_QUEUED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>MAX_QUEUED_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>SERVICE_LEVEL</dt>
     * <dd>
     * <p>
     * You can include up to 20 SERVICE_LEVEL metrics in a request.
     * </p>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_DISCONNECTED</dt>
     * <dd>
     * <p>
     * Valid metric filter key: <code>DISCONNECT_REASON</code>
     * </p>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * </dl>
     * 
     * @param metrics
     *        The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following
     *        historical metrics are available. For a description of each metric, see <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html"
     *        >Historical metrics definitions</a> in the <i>Amazon Connect Administrator's Guide</i>.</p>
     *        <dl>
     *        <dt>AGENT_ADHERENT_TIME</dt>
     *        <dd>
     *        <p>
     *        This metric is available only in Amazon Web Services Regions where <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     *        capacity planning, and scheduling</a> is available.
     *        </p>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AGENT_NON_RESPONSE</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AGENT_OCCUPANCY</dt>
     *        <dd>
     *        <p>
     *        Unit: Percentage
     *        </p>
     *        <p>
     *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AGENT_SCHEDULE_ADHERENCE</dt>
     *        <dd>
     *        <p>
     *        This metric is available only in Amazon Web Services Regions where <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     *        capacity planning, and scheduling</a> is available.
     *        </p>
     *        <p>
     *        Unit: Percent
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AGENT_SCHEDULED_TIME</dt>
     *        <dd>
     *        <p>
     *        This metric is available only in Amazon Web Services Regions where <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     *        capacity planning, and scheduling</a> is available.
     *        </p>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_ABANDON_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_AGENT_CONNECTING_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following
     *        as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
     *        <code>API</code>
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_HANDLE_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_HOLD_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_INTERACTION_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>AVG_QUEUE_ANSWER_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_ABANDONED</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_CREATED</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid metric filter key: <code>INITIATION_METHOD</code>
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_HANDLED</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_HOLD_ABANDONS</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_QUEUED</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_TRANSFERRED_OUT</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>MAX_QUEUED_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>SERVICE_LEVEL</dt>
     *        <dd>
     *        <p>
     *        You can include up to 20 SERVICE_LEVEL metrics in a request.
     *        </p>
     *        <p>
     *        Unit: Percent
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        <p>
     *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
     *        seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     *        </p>
     *        </dd>
     *        <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>SUM_CONTACTS_DISCONNECTED</dt>
     *        <dd>
     *        <p>
     *        Valid metric filter key: <code>DISCONNECT_REASON</code>
     *        </p>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     */

    public void setMetrics(java.util.Collection<MetricV2> metrics) {
        if (metrics == null) {
            this.metrics = null;
            return;
        }

        this.metrics = new java.util.ArrayList<MetricV2>(metrics);
    }

    /**
     * <p>
     * The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following historical
     * metrics are available. For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * metrics definitions</a> in the <i>Amazon Connect Administrator's Guide</i>.
     * </p>
     * <dl>
     * <dt>AGENT_ADHERENT_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_NON_RESPONSE</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_OCCUPANCY</dt>
     * <dd>
     * <p>
     * Unit: Percentage
     * </p>
     * <p>
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_SCHEDULE_ADHERENCE</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_SCHEDULED_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_ABANDON_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_AGENT_CONNECTING_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following as
     * <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
     * <code>API</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_HANDLE_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_INTERACTION_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>AVG_QUEUE_ANSWER_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>CONTACTS_ABANDONED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_CREATED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_HOLD_ABANDONS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_QUEUED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>MAX_QUEUED_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>SERVICE_LEVEL</dt>
     * <dd>
     * <p>
     * You can include up to 20 SERVICE_LEVEL metrics in a request.
     * </p>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_DISCONNECTED</dt>
     * <dd>
     * <p>
     * Valid metric filter key: <code>DISCONNECT_REASON</code>
     * </p>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * </dl>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setMetrics(java.util.Collection)} or {@link #withMetrics(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param metrics
     *        The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following
     *        historical metrics are available. For a description of each metric, see <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html"
     *        >Historical metrics definitions</a> in the <i>Amazon Connect Administrator's Guide</i>.</p>
     *        <dl>
     *        <dt>AGENT_ADHERENT_TIME</dt>
     *        <dd>
     *        <p>
     *        This metric is available only in Amazon Web Services Regions where <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     *        capacity planning, and scheduling</a> is available.
     *        </p>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AGENT_NON_RESPONSE</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AGENT_OCCUPANCY</dt>
     *        <dd>
     *        <p>
     *        Unit: Percentage
     *        </p>
     *        <p>
     *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AGENT_SCHEDULE_ADHERENCE</dt>
     *        <dd>
     *        <p>
     *        This metric is available only in Amazon Web Services Regions where <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     *        capacity planning, and scheduling</a> is available.
     *        </p>
     *        <p>
     *        Unit: Percent
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AGENT_SCHEDULED_TIME</dt>
     *        <dd>
     *        <p>
     *        This metric is available only in Amazon Web Services Regions where <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     *        capacity planning, and scheduling</a> is available.
     *        </p>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_ABANDON_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_AGENT_CONNECTING_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following
     *        as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
     *        <code>API</code>
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_HANDLE_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_HOLD_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_INTERACTION_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>AVG_QUEUE_ANSWER_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_ABANDONED</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_CREATED</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid metric filter key: <code>INITIATION_METHOD</code>
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_HANDLED</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_HOLD_ABANDONS</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_QUEUED</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_TRANSFERRED_OUT</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>MAX_QUEUED_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>SERVICE_LEVEL</dt>
     *        <dd>
     *        <p>
     *        You can include up to 20 SERVICE_LEVEL metrics in a request.
     *        </p>
     *        <p>
     *        Unit: Percent
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        <p>
     *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
     *        seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     *        </p>
     *        </dd>
     *        <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>SUM_CONTACTS_DISCONNECTED</dt>
     *        <dd>
     *        <p>
     *        Valid metric filter key: <code>DISCONNECT_REASON</code>
     *        </p>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMetricDataV2Request withMetrics(MetricV2... metrics) {
        if (this.metrics == null) {
            setMetrics(new java.util.ArrayList<MetricV2>(metrics.length));
        }
        for (MetricV2 ele : metrics) {
            this.metrics.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following historical
     * metrics are available. For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * metrics definitions</a> in the <i>Amazon Connect Administrator's Guide</i>.
     * </p>
     * <dl>
     * <dt>AGENT_ADHERENT_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_NON_RESPONSE</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_OCCUPANCY</dt>
     * <dd>
     * <p>
     * Unit: Percentage
     * </p>
     * <p>
     * Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_SCHEDULE_ADHERENCE</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AGENT_SCHEDULED_TIME</dt>
     * <dd>
     * <p>
     * This metric is available only in Amazon Web Services Regions where <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     * capacity planning, and scheduling</a> is available.
     * </p>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_ABANDON_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_AGENT_CONNECTING_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following as
     * <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
     * <code>API</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_HANDLE_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>AVG_INTERACTION_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>AVG_QUEUE_ANSWER_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>CONTACTS_ABANDONED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_CREATED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_HOLD_ABANDONS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_QUEUED</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>MAX_QUEUED_TIME</dt>
     * <dd>
     * <p>
     * Unit: Seconds
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     * </p>
     * </dd>
     * <dt>SERVICE_LEVEL</dt>
     * <dd>
     * <p>
     * You can include up to 20 SERVICE_LEVEL metrics in a request.
     * </p>
     * <p>
     * Unit: Percent
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_CONTACTS_DISCONNECTED</dt>
     * <dd>
     * <p>
     * Valid metric filter key: <code>DISCONNECT_REASON</code>
     * </p>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
     * <dd>
     * <p>
     * Unit: Count
     * </p>
     * <p>
     * Valid groupings and filters: Queue, Channel, Routing Profile
     * </p>
     * </dd>
     * </dl>
     * 
     * @param metrics
     *        The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following
     *        historical metrics are available. For a description of each metric, see <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html"
     *        >Historical metrics definitions</a> in the <i>Amazon Connect Administrator's Guide</i>.</p>
     *        <dl>
     *        <dt>AGENT_ADHERENT_TIME</dt>
     *        <dd>
     *        <p>
     *        This metric is available only in Amazon Web Services Regions where <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     *        capacity planning, and scheduling</a> is available.
     *        </p>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AGENT_NON_RESPONSE</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AGENT_OCCUPANCY</dt>
     *        <dd>
     *        <p>
     *        Unit: Percentage
     *        </p>
     *        <p>
     *        Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AGENT_SCHEDULE_ADHERENCE</dt>
     *        <dd>
     *        <p>
     *        This metric is available only in Amazon Web Services Regions where <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     *        capacity planning, and scheduling</a> is available.
     *        </p>
     *        <p>
     *        Unit: Percent
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AGENT_SCHEDULED_TIME</dt>
     *        <dd>
     *        <p>
     *        This metric is available only in Amazon Web Services Regions where <a
     *        href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting,
     *        capacity planning, and scheduling</a> is available.
     *        </p>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_ABANDON_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_AFTER_CONTACT_WORK_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_AGENT_CONNECTING_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following
     *        as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> |
     *        <code>API</code>
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_HANDLE_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_HOLD_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_INTERACTION_AND_HOLD_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>AVG_INTERACTION_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>AVG_QUEUE_ANSWER_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_ABANDONED</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_CREATED</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid metric filter key: <code>INITIATION_METHOD</code>
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_HANDLED</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_HOLD_ABANDONS</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_QUEUED</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_TRANSFERRED_OUT</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>MAX_QUEUED_TIME</dt>
     *        <dd>
     *        <p>
     *        Unit: Seconds
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy
     *        </p>
     *        </dd>
     *        <dt>SERVICE_LEVEL</dt>
     *        <dd>
     *        <p>
     *        You can include up to 20 SERVICE_LEVEL metrics in a request.
     *        </p>
     *        <p>
     *        Unit: Percent
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        <p>
     *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
     *        seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     *        </p>
     *        </dd>
     *        <dt>SUM_CONTACTS_ANSWERED_IN_X</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>SUM_CONTACTS_ABANDONED_IN_X</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>SUM_CONTACTS_DISCONNECTED</dt>
     *        <dd>
     *        <p>
     *        Valid metric filter key: <code>DISCONNECT_REASON</code>
     *        </p>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     *        <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt>
     *        <dd>
     *        <p>
     *        Unit: Count
     *        </p>
     *        <p>
     *        Valid groupings and filters: Queue, Channel, Routing Profile
     *        </p>
     *        </dd>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMetricDataV2Request withMetrics(java.util.Collection<MetricV2> metrics) {
        setMetrics(metrics);
        return this;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @param nextToken
     *        The token for the next set of results. Use the value returned in the previous response in the next request
     *        to retrieve the next set of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @param nextToken
     *        The token for the next set of results. Use the value returned in the previous response in the next request
     *        to retrieve the next set of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMetricDataV2Request withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return per page.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return per page.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMetricDataV2Request withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getResourceArn() != null)
            sb.append("ResourceArn: ").append(getResourceArn()).append(",");
        if (getStartTime() != null)
            sb.append("StartTime: ").append(getStartTime()).append(",");
        if (getEndTime() != null)
            sb.append("EndTime: ").append(getEndTime()).append(",");
        if (getFilters() != null)
            sb.append("Filters: ").append(getFilters()).append(",");
        if (getGroupings() != null)
            sb.append("Groupings: ").append(getGroupings()).append(",");
        if (getMetrics() != null)
            sb.append("Metrics: ").append(getMetrics()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetMetricDataV2Request == false)
            return false;
        GetMetricDataV2Request other = (GetMetricDataV2Request) obj;
        if (other.getResourceArn() == null ^ this.getResourceArn() == null)
            return false;
        if (other.getResourceArn() != null && other.getResourceArn().equals(this.getResourceArn()) == false)
            return false;
        if (other.getStartTime() == null ^ this.getStartTime() == null)
            return false;
        if (other.getStartTime() != null && other.getStartTime().equals(this.getStartTime()) == false)
            return false;
        if (other.getEndTime() == null ^ this.getEndTime() == null)
            return false;
        if (other.getEndTime() != null && other.getEndTime().equals(this.getEndTime()) == false)
            return false;
        if (other.getFilters() == null ^ this.getFilters() == null)
            return false;
        if (other.getFilters() != null && other.getFilters().equals(this.getFilters()) == false)
            return false;
        if (other.getGroupings() == null ^ this.getGroupings() == null)
            return false;
        if (other.getGroupings() != null && other.getGroupings().equals(this.getGroupings()) == false)
            return false;
        if (other.getMetrics() == null ^ this.getMetrics() == null)
            return false;
        if (other.getMetrics() != null && other.getMetrics().equals(this.getMetrics()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getResourceArn() == null) ? 0 : getResourceArn().hashCode());
        hashCode = prime * hashCode + ((getStartTime() == null) ? 0 : getStartTime().hashCode());
        hashCode = prime * hashCode + ((getEndTime() == null) ? 0 : getEndTime().hashCode());
        hashCode = prime * hashCode + ((getFilters() == null) ? 0 : getFilters().hashCode());
        hashCode = prime * hashCode + ((getGroupings() == null) ? 0 : getGroupings().hashCode());
        hashCode = prime * hashCode + ((getMetrics() == null) ? 0 : getMetrics().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public GetMetricDataV2Request clone() {
        return (GetMetricDataV2Request) super.clone();
    }

}
