/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.connect.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ClaimedPhoneNumberSummary JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ClaimedPhoneNumberSummaryJsonUnmarshaller implements Unmarshaller<ClaimedPhoneNumberSummary, JsonUnmarshallerContext> {

    public ClaimedPhoneNumberSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        ClaimedPhoneNumberSummary claimedPhoneNumberSummary = new ClaimedPhoneNumberSummary();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("PhoneNumberId", targetDepth)) {
                    context.nextToken();
                    claimedPhoneNumberSummary.setPhoneNumberId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PhoneNumberArn", targetDepth)) {
                    context.nextToken();
                    claimedPhoneNumberSummary.setPhoneNumberArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PhoneNumber", targetDepth)) {
                    context.nextToken();
                    claimedPhoneNumberSummary.setPhoneNumber(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PhoneNumberCountryCode", targetDepth)) {
                    context.nextToken();
                    claimedPhoneNumberSummary.setPhoneNumberCountryCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PhoneNumberType", targetDepth)) {
                    context.nextToken();
                    claimedPhoneNumberSummary.setPhoneNumberType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PhoneNumberDescription", targetDepth)) {
                    context.nextToken();
                    claimedPhoneNumberSummary.setPhoneNumberDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TargetArn", targetDepth)) {
                    context.nextToken();
                    claimedPhoneNumberSummary.setTargetArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InstanceId", targetDepth)) {
                    context.nextToken();
                    claimedPhoneNumberSummary.setInstanceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Tags", targetDepth)) {
                    context.nextToken();
                    claimedPhoneNumberSummary.setTags(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("PhoneNumberStatus", targetDepth)) {
                    context.nextToken();
                    claimedPhoneNumberSummary.setPhoneNumberStatus(PhoneNumberStatusJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SourcePhoneNumberArn", targetDepth)) {
                    context.nextToken();
                    claimedPhoneNumberSummary.setSourcePhoneNumberArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return claimedPhoneNumberSummary;
    }

    private static ClaimedPhoneNumberSummaryJsonUnmarshaller instance;

    public static ClaimedPhoneNumberSummaryJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new ClaimedPhoneNumberSummaryJsonUnmarshaller();
        return instance;
    }
}
