/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model.transform;

import java.util.Map;
import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.connect.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * CreateRoutingProfileRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class CreateRoutingProfileRequestMarshaller {

    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH)
            .marshallLocationName("InstanceId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> DEFAULTOUTBOUNDQUEUEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultOutboundQueueId").build();
    private static final MarshallingInfo<List> QUEUECONFIGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("QueueConfigs").build();
    private static final MarshallingInfo<List> MEDIACONCURRENCIES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MediaConcurrencies").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Tags").build();
    private static final MarshallingInfo<String> AGENTAVAILABILITYTIMER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgentAvailabilityTimer").build();

    private static final CreateRoutingProfileRequestMarshaller instance = new CreateRoutingProfileRequestMarshaller();

    public static CreateRoutingProfileRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(CreateRoutingProfileRequest createRoutingProfileRequest, ProtocolMarshaller protocolMarshaller) {

        if (createRoutingProfileRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(createRoutingProfileRequest.getInstanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall(createRoutingProfileRequest.getName(), NAME_BINDING);
            protocolMarshaller.marshall(createRoutingProfileRequest.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(createRoutingProfileRequest.getDefaultOutboundQueueId(), DEFAULTOUTBOUNDQUEUEID_BINDING);
            protocolMarshaller.marshall(createRoutingProfileRequest.getQueueConfigs(), QUEUECONFIGS_BINDING);
            protocolMarshaller.marshall(createRoutingProfileRequest.getMediaConcurrencies(), MEDIACONCURRENCIES_BINDING);
            protocolMarshaller.marshall(createRoutingProfileRequest.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall(createRoutingProfileRequest.getAgentAvailabilityTimer(), AGENTAVAILABILITYTIMER_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
