/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A leaf node condition which can be used to specify a ProficiencyName, ProficiencyValue and ProficiencyLimit.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/Condition" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Condition implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * A leaf node condition which can be used to specify a string condition.
     * </p>
     * <note>
     * <p>
     * The currently supported values for <code>FieldName</code> are <code>name</code> and&#x2028; <code>value</code>.
     * </p>
     * </note>
     */
    private StringCondition stringCondition;
    /**
     * <p>
     * A leaf node condition which can be used to specify a numeric condition.
     * </p>
     */
    private NumberCondition numberCondition;

    /**
     * <p>
     * A leaf node condition which can be used to specify a string condition.
     * </p>
     * <note>
     * <p>
     * The currently supported values for <code>FieldName</code> are <code>name</code> and&#x2028; <code>value</code>.
     * </p>
     * </note>
     * 
     * @param stringCondition
     *        A leaf node condition which can be used to specify a string condition.</p> <note>
     *        <p>
     *        The currently supported values for <code>FieldName</code> are <code>name</code> and&#x2028;
     *        <code>value</code>.
     *        </p>
     */

    public void setStringCondition(StringCondition stringCondition) {
        this.stringCondition = stringCondition;
    }

    /**
     * <p>
     * A leaf node condition which can be used to specify a string condition.
     * </p>
     * <note>
     * <p>
     * The currently supported values for <code>FieldName</code> are <code>name</code> and&#x2028; <code>value</code>.
     * </p>
     * </note>
     * 
     * @return A leaf node condition which can be used to specify a string condition.</p> <note>
     *         <p>
     *         The currently supported values for <code>FieldName</code> are <code>name</code> and&#x2028;
     *         <code>value</code>.
     *         </p>
     */

    public StringCondition getStringCondition() {
        return this.stringCondition;
    }

    /**
     * <p>
     * A leaf node condition which can be used to specify a string condition.
     * </p>
     * <note>
     * <p>
     * The currently supported values for <code>FieldName</code> are <code>name</code> and&#x2028; <code>value</code>.
     * </p>
     * </note>
     * 
     * @param stringCondition
     *        A leaf node condition which can be used to specify a string condition.</p> <note>
     *        <p>
     *        The currently supported values for <code>FieldName</code> are <code>name</code> and&#x2028;
     *        <code>value</code>.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Condition withStringCondition(StringCondition stringCondition) {
        setStringCondition(stringCondition);
        return this;
    }

    /**
     * <p>
     * A leaf node condition which can be used to specify a numeric condition.
     * </p>
     * 
     * @param numberCondition
     *        A leaf node condition which can be used to specify a numeric condition.
     */

    public void setNumberCondition(NumberCondition numberCondition) {
        this.numberCondition = numberCondition;
    }

    /**
     * <p>
     * A leaf node condition which can be used to specify a numeric condition.
     * </p>
     * 
     * @return A leaf node condition which can be used to specify a numeric condition.
     */

    public NumberCondition getNumberCondition() {
        return this.numberCondition;
    }

    /**
     * <p>
     * A leaf node condition which can be used to specify a numeric condition.
     * </p>
     * 
     * @param numberCondition
     *        A leaf node condition which can be used to specify a numeric condition.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Condition withNumberCondition(NumberCondition numberCondition) {
        setNumberCondition(numberCondition);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStringCondition() != null)
            sb.append("StringCondition: ").append(getStringCondition()).append(",");
        if (getNumberCondition() != null)
            sb.append("NumberCondition: ").append(getNumberCondition());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Condition == false)
            return false;
        Condition other = (Condition) obj;
        if (other.getStringCondition() == null ^ this.getStringCondition() == null)
            return false;
        if (other.getStringCondition() != null && other.getStringCondition().equals(this.getStringCondition()) == false)
            return false;
        if (other.getNumberCondition() == null ^ this.getNumberCondition() == null)
            return false;
        if (other.getNumberCondition() != null && other.getNumberCondition().equals(this.getNumberCondition()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStringCondition() == null) ? 0 : getStringCondition().hashCode());
        hashCode = prime * hashCode + ((getNumberCondition() == null) ? 0 : getNumberCondition().hashCode());
        return hashCode;
    }

    @Override
    public Condition clone() {
        try {
            return (Condition) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.connect.model.transform.ConditionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
