/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about a predefined attribute.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/PredefinedAttribute" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PredefinedAttribute implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the predefined attribute.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The values of the predefined attribute.
     * </p>
     */
    private PredefinedAttributeValues values;
    /**
     * <p>
     * Last modified time.
     * </p>
     */
    private java.util.Date lastModifiedTime;
    /**
     * <p>
     * Last modified region.
     * </p>
     */
    private String lastModifiedRegion;

    /**
     * <p>
     * The name of the predefined attribute.
     * </p>
     * 
     * @param name
     *        The name of the predefined attribute.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the predefined attribute.
     * </p>
     * 
     * @return The name of the predefined attribute.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the predefined attribute.
     * </p>
     * 
     * @param name
     *        The name of the predefined attribute.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PredefinedAttribute withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The values of the predefined attribute.
     * </p>
     * 
     * @param values
     *        The values of the predefined attribute.
     */

    public void setValues(PredefinedAttributeValues values) {
        this.values = values;
    }

    /**
     * <p>
     * The values of the predefined attribute.
     * </p>
     * 
     * @return The values of the predefined attribute.
     */

    public PredefinedAttributeValues getValues() {
        return this.values;
    }

    /**
     * <p>
     * The values of the predefined attribute.
     * </p>
     * 
     * @param values
     *        The values of the predefined attribute.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PredefinedAttribute withValues(PredefinedAttributeValues values) {
        setValues(values);
        return this;
    }

    /**
     * <p>
     * Last modified time.
     * </p>
     * 
     * @param lastModifiedTime
     *        Last modified time.
     */

    public void setLastModifiedTime(java.util.Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * <p>
     * Last modified time.
     * </p>
     * 
     * @return Last modified time.
     */

    public java.util.Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * <p>
     * Last modified time.
     * </p>
     * 
     * @param lastModifiedTime
     *        Last modified time.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PredefinedAttribute withLastModifiedTime(java.util.Date lastModifiedTime) {
        setLastModifiedTime(lastModifiedTime);
        return this;
    }

    /**
     * <p>
     * Last modified region.
     * </p>
     * 
     * @param lastModifiedRegion
     *        Last modified region.
     */

    public void setLastModifiedRegion(String lastModifiedRegion) {
        this.lastModifiedRegion = lastModifiedRegion;
    }

    /**
     * <p>
     * Last modified region.
     * </p>
     * 
     * @return Last modified region.
     */

    public String getLastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    /**
     * <p>
     * Last modified region.
     * </p>
     * 
     * @param lastModifiedRegion
     *        Last modified region.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PredefinedAttribute withLastModifiedRegion(String lastModifiedRegion) {
        setLastModifiedRegion(lastModifiedRegion);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getValues() != null)
            sb.append("Values: ").append(getValues()).append(",");
        if (getLastModifiedTime() != null)
            sb.append("LastModifiedTime: ").append(getLastModifiedTime()).append(",");
        if (getLastModifiedRegion() != null)
            sb.append("LastModifiedRegion: ").append(getLastModifiedRegion());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PredefinedAttribute == false)
            return false;
        PredefinedAttribute other = (PredefinedAttribute) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getValues() == null ^ this.getValues() == null)
            return false;
        if (other.getValues() != null && other.getValues().equals(this.getValues()) == false)
            return false;
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null)
            return false;
        if (other.getLastModifiedTime() != null && other.getLastModifiedTime().equals(this.getLastModifiedTime()) == false)
            return false;
        if (other.getLastModifiedRegion() == null ^ this.getLastModifiedRegion() == null)
            return false;
        if (other.getLastModifiedRegion() != null && other.getLastModifiedRegion().equals(this.getLastModifiedRegion()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getValues() == null) ? 0 : getValues().hashCode());
        hashCode = prime * hashCode + ((getLastModifiedTime() == null) ? 0 : getLastModifiedTime().hashCode());
        hashCode = prime * hashCode + ((getLastModifiedRegion() == null) ? 0 : getLastModifiedRegion().hashCode());
        return hashCode;
    }

    @Override
    public PredefinedAttribute clone() {
        try {
            return (PredefinedAttribute) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.connect.model.transform.PredefinedAttributeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
