/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connectcases;

import javax.annotation.Generated;

import com.amazonaws.services.connectcases.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonConnectCases}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonConnectCases implements AmazonConnectCases {

    protected AbstractAmazonConnectCases() {
    }

    @Override
    public BatchGetFieldResult batchGetField(BatchGetFieldRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchPutFieldOptionsResult batchPutFieldOptions(BatchPutFieldOptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCaseResult createCase(CreateCaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDomainResult createDomain(CreateDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFieldResult createField(CreateFieldRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLayoutResult createLayout(CreateLayoutRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRelatedItemResult createRelatedItem(CreateRelatedItemRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTemplateResult createTemplate(CreateTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDomainResult deleteDomain(DeleteDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCaseResult getCase(GetCaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCaseEventConfigurationResult getCaseEventConfiguration(GetCaseEventConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDomainResult getDomain(GetDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLayoutResult getLayout(GetLayoutRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTemplateResult getTemplate(GetTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCasesForContactResult listCasesForContact(ListCasesForContactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDomainsResult listDomains(ListDomainsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFieldOptionsResult listFieldOptions(ListFieldOptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFieldsResult listFields(ListFieldsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLayoutsResult listLayouts(ListLayoutsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTemplatesResult listTemplates(ListTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutCaseEventConfigurationResult putCaseEventConfiguration(PutCaseEventConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchCasesResult searchCases(SearchCasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchRelatedItemsResult searchRelatedItems(SearchRelatedItemsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCaseResult updateCase(UpdateCaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFieldResult updateField(UpdateFieldRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLayoutResult updateLayout(UpdateLayoutRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTemplateResult updateTemplate(UpdateTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
