/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcases.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connectcases.model.FieldIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetFieldRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainId;
    private List<FieldIdentifier> fields;

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public BatchGetFieldRequest withDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public List<FieldIdentifier> getFields() {
        return this.fields;
    }

    public void setFields(Collection<FieldIdentifier> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }
        this.fields = new ArrayList<FieldIdentifier>(fields);
    }

    public BatchGetFieldRequest withFields(FieldIdentifier ... fields) {
        if (this.fields == null) {
            this.setFields(new ArrayList<FieldIdentifier>(fields.length));
        }
        for (FieldIdentifier ele : fields) {
            this.fields.add(ele);
        }
        return this;
    }

    public BatchGetFieldRequest withFields(Collection<FieldIdentifier> fields) {
        this.setFields(fields);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainId() != null) {
            sb.append("DomainId: ").append(this.getDomainId()).append(",");
        }
        if (this.getFields() != null) {
            sb.append("Fields: ").append(this.getFields());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFieldRequest)) {
            return false;
        }
        BatchGetFieldRequest other = (BatchGetFieldRequest)obj;
        if (other.getDomainId() == null ^ this.getDomainId() == null) {
            return false;
        }
        if (other.getDomainId() != null && !other.getDomainId().equals(this.getDomainId())) {
            return false;
        }
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        return other.getFields() == null || other.getFields().equals(this.getFields());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainId() == null ? 0 : this.getDomainId().hashCode());
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : this.getFields().hashCode());
        return hashCode;
    }

    public BatchGetFieldRequest clone() {
        return (BatchGetFieldRequest)super.clone();
    }
}

