/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connectcases.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Details of what case data is published through the case event stream.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CaseEventIncludedData" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CaseEventIncludedData implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * List of field identifiers.
     * </p>
     */
    private java.util.List<FieldIdentifier> fields;

    /**
     * <p>
     * List of field identifiers.
     * </p>
     * 
     * @return List of field identifiers.
     */

    public java.util.List<FieldIdentifier> getFields() {
        return fields;
    }

    /**
     * <p>
     * List of field identifiers.
     * </p>
     * 
     * @param fields
     *        List of field identifiers.
     */

    public void setFields(java.util.Collection<FieldIdentifier> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }

        this.fields = new java.util.ArrayList<FieldIdentifier>(fields);
    }

    /**
     * <p>
     * List of field identifiers.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setFields(java.util.Collection)} or {@link #withFields(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param fields
     *        List of field identifiers.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CaseEventIncludedData withFields(FieldIdentifier... fields) {
        if (this.fields == null) {
            setFields(new java.util.ArrayList<FieldIdentifier>(fields.length));
        }
        for (FieldIdentifier ele : fields) {
            this.fields.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * List of field identifiers.
     * </p>
     * 
     * @param fields
     *        List of field identifiers.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CaseEventIncludedData withFields(java.util.Collection<FieldIdentifier> fields) {
        setFields(fields);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getFields() != null)
            sb.append("Fields: ").append(getFields());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CaseEventIncludedData == false)
            return false;
        CaseEventIncludedData other = (CaseEventIncludedData) obj;
        if (other.getFields() == null ^ this.getFields() == null)
            return false;
        if (other.getFields() != null && other.getFields().equals(this.getFields()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getFields() == null) ? 0 : getFields().hashCode());
        return hashCode;
    }

    @Override
    public CaseEventIncludedData clone() {
        try {
            return (CaseEventIncludedData) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.connectcases.model.transform.CaseEventIncludedDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
