/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectwisdom.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.connectwisdom.model.RecommendationData;
import com.amazonaws.services.connectwisdom.model.RecommendationTrigger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetRecommendationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<RecommendationData> recommendations;
    private List<RecommendationTrigger> triggers;

    public List<RecommendationData> getRecommendations() {
        return this.recommendations;
    }

    public void setRecommendations(Collection<RecommendationData> recommendations) {
        if (recommendations == null) {
            this.recommendations = null;
            return;
        }
        this.recommendations = new ArrayList<RecommendationData>(recommendations);
    }

    public GetRecommendationsResult withRecommendations(RecommendationData ... recommendations) {
        if (this.recommendations == null) {
            this.setRecommendations(new ArrayList<RecommendationData>(recommendations.length));
        }
        for (RecommendationData ele : recommendations) {
            this.recommendations.add(ele);
        }
        return this;
    }

    public GetRecommendationsResult withRecommendations(Collection<RecommendationData> recommendations) {
        this.setRecommendations(recommendations);
        return this;
    }

    public List<RecommendationTrigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(Collection<RecommendationTrigger> triggers) {
        if (triggers == null) {
            this.triggers = null;
            return;
        }
        this.triggers = new ArrayList<RecommendationTrigger>(triggers);
    }

    public GetRecommendationsResult withTriggers(RecommendationTrigger ... triggers) {
        if (this.triggers == null) {
            this.setTriggers(new ArrayList<RecommendationTrigger>(triggers.length));
        }
        for (RecommendationTrigger ele : triggers) {
            this.triggers.add(ele);
        }
        return this;
    }

    public GetRecommendationsResult withTriggers(Collection<RecommendationTrigger> triggers) {
        this.setTriggers(triggers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecommendations() != null) {
            sb.append("Recommendations: ").append(this.getRecommendations()).append(",");
        }
        if (this.getTriggers() != null) {
            sb.append("Triggers: ").append(this.getTriggers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsResult)) {
            return false;
        }
        GetRecommendationsResult other = (GetRecommendationsResult)obj;
        if (other.getRecommendations() == null ^ this.getRecommendations() == null) {
            return false;
        }
        if (other.getRecommendations() != null && !other.getRecommendations().equals(this.getRecommendations())) {
            return false;
        }
        if (other.getTriggers() == null ^ this.getTriggers() == null) {
            return false;
        }
        return other.getTriggers() == null || other.getTriggers().equals(this.getTriggers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecommendations() == null ? 0 : this.getRecommendations().hashCode());
        hashCode = 31 * hashCode + (this.getTriggers() == null ? 0 : this.getTriggers().hashCode());
        return hashCode;
    }

    public GetRecommendationsResult clone() {
        try {
            return (GetRecommendationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

