/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.controltower;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.controltower.AWSControlTowerAsync;
import com.amazonaws.services.controltower.AWSControlTowerAsyncClientBuilder;
import com.amazonaws.services.controltower.AWSControlTowerClient;
import com.amazonaws.services.controltower.model.DisableControlRequest;
import com.amazonaws.services.controltower.model.DisableControlResult;
import com.amazonaws.services.controltower.model.EnableControlRequest;
import com.amazonaws.services.controltower.model.EnableControlResult;
import com.amazonaws.services.controltower.model.GetControlOperationRequest;
import com.amazonaws.services.controltower.model.GetControlOperationResult;
import com.amazonaws.services.controltower.model.GetEnabledControlRequest;
import com.amazonaws.services.controltower.model.GetEnabledControlResult;
import com.amazonaws.services.controltower.model.ListEnabledControlsRequest;
import com.amazonaws.services.controltower.model.ListEnabledControlsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSControlTowerAsyncClient
extends AWSControlTowerClient
implements AWSControlTowerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSControlTowerAsyncClientBuilder asyncBuilder() {
        return AWSControlTowerAsyncClientBuilder.standard();
    }

    AWSControlTowerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSControlTowerAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DisableControlResult> disableControlAsync(DisableControlRequest request) {
        return this.disableControlAsync(request, null);
    }

    @Override
    public Future<DisableControlResult> disableControlAsync(DisableControlRequest request, final AsyncHandler<DisableControlRequest, DisableControlResult> asyncHandler) {
        final DisableControlRequest finalRequest = (DisableControlRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableControlResult>(){

            @Override
            public DisableControlResult call() throws Exception {
                DisableControlResult result = null;
                try {
                    result = AWSControlTowerAsyncClient.this.executeDisableControl(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableControlResult> enableControlAsync(EnableControlRequest request) {
        return this.enableControlAsync(request, null);
    }

    @Override
    public Future<EnableControlResult> enableControlAsync(EnableControlRequest request, final AsyncHandler<EnableControlRequest, EnableControlResult> asyncHandler) {
        final EnableControlRequest finalRequest = (EnableControlRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableControlResult>(){

            @Override
            public EnableControlResult call() throws Exception {
                EnableControlResult result = null;
                try {
                    result = AWSControlTowerAsyncClient.this.executeEnableControl(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetControlOperationResult> getControlOperationAsync(GetControlOperationRequest request) {
        return this.getControlOperationAsync(request, null);
    }

    @Override
    public Future<GetControlOperationResult> getControlOperationAsync(GetControlOperationRequest request, final AsyncHandler<GetControlOperationRequest, GetControlOperationResult> asyncHandler) {
        final GetControlOperationRequest finalRequest = (GetControlOperationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetControlOperationResult>(){

            @Override
            public GetControlOperationResult call() throws Exception {
                GetControlOperationResult result = null;
                try {
                    result = AWSControlTowerAsyncClient.this.executeGetControlOperation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEnabledControlResult> getEnabledControlAsync(GetEnabledControlRequest request) {
        return this.getEnabledControlAsync(request, null);
    }

    @Override
    public Future<GetEnabledControlResult> getEnabledControlAsync(GetEnabledControlRequest request, final AsyncHandler<GetEnabledControlRequest, GetEnabledControlResult> asyncHandler) {
        final GetEnabledControlRequest finalRequest = (GetEnabledControlRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEnabledControlResult>(){

            @Override
            public GetEnabledControlResult call() throws Exception {
                GetEnabledControlResult result = null;
                try {
                    result = AWSControlTowerAsyncClient.this.executeGetEnabledControl(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEnabledControlsResult> listEnabledControlsAsync(ListEnabledControlsRequest request) {
        return this.listEnabledControlsAsync(request, null);
    }

    @Override
    public Future<ListEnabledControlsResult> listEnabledControlsAsync(ListEnabledControlsRequest request, final AsyncHandler<ListEnabledControlsRequest, ListEnabledControlsResult> asyncHandler) {
        final ListEnabledControlsRequest finalRequest = (ListEnabledControlsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEnabledControlsResult>(){

            @Override
            public ListEnabledControlsResult call() throws Exception {
                ListEnabledControlsResult result = null;
                try {
                    result = AWSControlTowerAsyncClient.this.executeListEnabledControls(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

