/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.controltower;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.controltower.AWSControlTower;
import com.amazonaws.services.controltower.AWSControlTowerClientBuilder;
import com.amazonaws.services.controltower.model.AWSControlTowerException;
import com.amazonaws.services.controltower.model.DeleteLandingZoneRequest;
import com.amazonaws.services.controltower.model.DeleteLandingZoneResult;
import com.amazonaws.services.controltower.model.DisableBaselineRequest;
import com.amazonaws.services.controltower.model.DisableBaselineResult;
import com.amazonaws.services.controltower.model.DisableControlRequest;
import com.amazonaws.services.controltower.model.DisableControlResult;
import com.amazonaws.services.controltower.model.EnableBaselineRequest;
import com.amazonaws.services.controltower.model.EnableBaselineResult;
import com.amazonaws.services.controltower.model.EnableControlRequest;
import com.amazonaws.services.controltower.model.EnableControlResult;
import com.amazonaws.services.controltower.model.GetBaselineOperationRequest;
import com.amazonaws.services.controltower.model.GetBaselineOperationResult;
import com.amazonaws.services.controltower.model.GetBaselineRequest;
import com.amazonaws.services.controltower.model.GetBaselineResult;
import com.amazonaws.services.controltower.model.GetControlOperationRequest;
import com.amazonaws.services.controltower.model.GetControlOperationResult;
import com.amazonaws.services.controltower.model.GetEnabledBaselineRequest;
import com.amazonaws.services.controltower.model.GetEnabledBaselineResult;
import com.amazonaws.services.controltower.model.GetEnabledControlRequest;
import com.amazonaws.services.controltower.model.GetEnabledControlResult;
import com.amazonaws.services.controltower.model.GetLandingZoneOperationRequest;
import com.amazonaws.services.controltower.model.GetLandingZoneOperationResult;
import com.amazonaws.services.controltower.model.ListBaselinesRequest;
import com.amazonaws.services.controltower.model.ListBaselinesResult;
import com.amazonaws.services.controltower.model.ListEnabledBaselinesRequest;
import com.amazonaws.services.controltower.model.ListEnabledBaselinesResult;
import com.amazonaws.services.controltower.model.ListEnabledControlsRequest;
import com.amazonaws.services.controltower.model.ListEnabledControlsResult;
import com.amazonaws.services.controltower.model.ListLandingZonesRequest;
import com.amazonaws.services.controltower.model.ListLandingZonesResult;
import com.amazonaws.services.controltower.model.ListTagsForResourceRequest;
import com.amazonaws.services.controltower.model.ListTagsForResourceResult;
import com.amazonaws.services.controltower.model.ResetEnabledBaselineRequest;
import com.amazonaws.services.controltower.model.ResetEnabledBaselineResult;
import com.amazonaws.services.controltower.model.ResetLandingZoneRequest;
import com.amazonaws.services.controltower.model.ResetLandingZoneResult;
import com.amazonaws.services.controltower.model.TagResourceRequest;
import com.amazonaws.services.controltower.model.TagResourceResult;
import com.amazonaws.services.controltower.model.UntagResourceRequest;
import com.amazonaws.services.controltower.model.UntagResourceResult;
import com.amazonaws.services.controltower.model.UpdateEnabledBaselineRequest;
import com.amazonaws.services.controltower.model.UpdateEnabledBaselineResult;
import com.amazonaws.services.controltower.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.controltower.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.controltower.model.transform.DeleteLandingZoneRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.DeleteLandingZoneResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.DisableBaselineRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.DisableBaselineResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.DisableControlRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.DisableControlResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.EnableBaselineRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.EnableBaselineResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.EnableControlRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.EnableControlResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.GetBaselineOperationRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.GetBaselineOperationResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.GetBaselineRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.GetBaselineResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.GetControlOperationRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.GetControlOperationResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.GetEnabledBaselineRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.GetEnabledBaselineResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.GetEnabledControlRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.GetEnabledControlResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.GetLandingZoneOperationRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.GetLandingZoneOperationResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.controltower.model.transform.ListBaselinesRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.ListBaselinesResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.ListEnabledBaselinesRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.ListEnabledBaselinesResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.ListEnabledControlsRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.ListEnabledControlsResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.ListLandingZonesRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.ListLandingZonesResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.ResetEnabledBaselineRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.ResetEnabledBaselineResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.ResetLandingZoneRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.ResetLandingZoneResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.controltower.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.controltower.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.controltower.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.UpdateEnabledBaselineRequestProtocolMarshaller;
import com.amazonaws.services.controltower.model.transform.UpdateEnabledBaselineResultJsonUnmarshaller;
import com.amazonaws.services.controltower.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSControlTowerClient
extends AmazonWebServiceClient
implements AWSControlTower {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSControlTower.class);
    private static final String DEFAULT_SIGNING_NAME = "controltower";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSControlTowerException.class));

    public static AWSControlTowerClientBuilder builder() {
        return AWSControlTowerClientBuilder.standard();
    }

    AWSControlTowerClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSControlTowerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("controltower.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/controltower/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/controltower/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DeleteLandingZoneResult deleteLandingZone(DeleteLandingZoneRequest request) {
        request = (DeleteLandingZoneRequest)this.beforeClientExecution(request);
        return this.executeDeleteLandingZone(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLandingZoneResult executeDeleteLandingZone(DeleteLandingZoneRequest deleteLandingZoneRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLandingZoneRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLandingZoneRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLandingZoneRequestProtocolMarshaller(protocolFactory).marshall((DeleteLandingZoneRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteLandingZoneRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteLandingZone");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLandingZoneResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLandingZoneResult deleteLandingZoneResult = (DeleteLandingZoneResult)response.getAwsResponse();
            return deleteLandingZoneResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisableBaselineResult disableBaseline(DisableBaselineRequest request) {
        request = (DisableBaselineRequest)this.beforeClientExecution(request);
        return this.executeDisableBaseline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisableBaselineResult executeDisableBaseline(DisableBaselineRequest disableBaselineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableBaselineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableBaselineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableBaselineRequestProtocolMarshaller(protocolFactory).marshall((DisableBaselineRequest)super.beforeMarshalling((AmazonWebServiceRequest)disableBaselineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisableBaseline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableBaselineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableBaselineResult disableBaselineResult = (DisableBaselineResult)response.getAwsResponse();
            return disableBaselineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisableControlResult disableControl(DisableControlRequest request) {
        request = (DisableControlRequest)this.beforeClientExecution(request);
        return this.executeDisableControl(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisableControlResult executeDisableControl(DisableControlRequest disableControlRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableControlRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableControlRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableControlRequestProtocolMarshaller(protocolFactory).marshall((DisableControlRequest)super.beforeMarshalling((AmazonWebServiceRequest)disableControlRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisableControl");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableControlResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableControlResult disableControlResult = (DisableControlResult)response.getAwsResponse();
            return disableControlResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EnableBaselineResult enableBaseline(EnableBaselineRequest request) {
        request = (EnableBaselineRequest)this.beforeClientExecution(request);
        return this.executeEnableBaseline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EnableBaselineResult executeEnableBaseline(EnableBaselineRequest enableBaselineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableBaselineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableBaselineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableBaselineRequestProtocolMarshaller(protocolFactory).marshall((EnableBaselineRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableBaselineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"EnableBaseline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableBaselineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableBaselineResult enableBaselineResult = (EnableBaselineResult)response.getAwsResponse();
            return enableBaselineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EnableControlResult enableControl(EnableControlRequest request) {
        request = (EnableControlRequest)this.beforeClientExecution(request);
        return this.executeEnableControl(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EnableControlResult executeEnableControl(EnableControlRequest enableControlRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableControlRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableControlRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableControlRequestProtocolMarshaller(protocolFactory).marshall((EnableControlRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableControlRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"EnableControl");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableControlResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableControlResult enableControlResult = (EnableControlResult)response.getAwsResponse();
            return enableControlResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBaselineResult getBaseline(GetBaselineRequest request) {
        request = (GetBaselineRequest)this.beforeClientExecution(request);
        return this.executeGetBaseline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBaselineResult executeGetBaseline(GetBaselineRequest getBaselineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBaselineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBaselineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBaselineRequestProtocolMarshaller(protocolFactory).marshall((GetBaselineRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBaselineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBaseline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetBaselineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBaselineResult getBaselineResult = (GetBaselineResult)response.getAwsResponse();
            return getBaselineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBaselineOperationResult getBaselineOperation(GetBaselineOperationRequest request) {
        request = (GetBaselineOperationRequest)this.beforeClientExecution(request);
        return this.executeGetBaselineOperation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBaselineOperationResult executeGetBaselineOperation(GetBaselineOperationRequest getBaselineOperationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBaselineOperationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBaselineOperationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBaselineOperationRequestProtocolMarshaller(protocolFactory).marshall((GetBaselineOperationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBaselineOperationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBaselineOperation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetBaselineOperationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBaselineOperationResult getBaselineOperationResult = (GetBaselineOperationResult)response.getAwsResponse();
            return getBaselineOperationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetControlOperationResult getControlOperation(GetControlOperationRequest request) {
        request = (GetControlOperationRequest)this.beforeClientExecution(request);
        return this.executeGetControlOperation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetControlOperationResult executeGetControlOperation(GetControlOperationRequest getControlOperationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getControlOperationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetControlOperationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetControlOperationRequestProtocolMarshaller(protocolFactory).marshall((GetControlOperationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getControlOperationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetControlOperation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetControlOperationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetControlOperationResult getControlOperationResult = (GetControlOperationResult)response.getAwsResponse();
            return getControlOperationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEnabledBaselineResult getEnabledBaseline(GetEnabledBaselineRequest request) {
        request = (GetEnabledBaselineRequest)this.beforeClientExecution(request);
        return this.executeGetEnabledBaseline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEnabledBaselineResult executeGetEnabledBaseline(GetEnabledBaselineRequest getEnabledBaselineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEnabledBaselineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEnabledBaselineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEnabledBaselineRequestProtocolMarshaller(protocolFactory).marshall((GetEnabledBaselineRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEnabledBaselineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEnabledBaseline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEnabledBaselineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEnabledBaselineResult getEnabledBaselineResult = (GetEnabledBaselineResult)response.getAwsResponse();
            return getEnabledBaselineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEnabledControlResult getEnabledControl(GetEnabledControlRequest request) {
        request = (GetEnabledControlRequest)this.beforeClientExecution(request);
        return this.executeGetEnabledControl(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEnabledControlResult executeGetEnabledControl(GetEnabledControlRequest getEnabledControlRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEnabledControlRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEnabledControlRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEnabledControlRequestProtocolMarshaller(protocolFactory).marshall((GetEnabledControlRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEnabledControlRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEnabledControl");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEnabledControlResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEnabledControlResult getEnabledControlResult = (GetEnabledControlResult)response.getAwsResponse();
            return getEnabledControlResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLandingZoneOperationResult getLandingZoneOperation(GetLandingZoneOperationRequest request) {
        request = (GetLandingZoneOperationRequest)this.beforeClientExecution(request);
        return this.executeGetLandingZoneOperation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLandingZoneOperationResult executeGetLandingZoneOperation(GetLandingZoneOperationRequest getLandingZoneOperationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLandingZoneOperationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLandingZoneOperationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLandingZoneOperationRequestProtocolMarshaller(protocolFactory).marshall((GetLandingZoneOperationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLandingZoneOperationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetLandingZoneOperation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLandingZoneOperationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLandingZoneOperationResult getLandingZoneOperationResult = (GetLandingZoneOperationResult)response.getAwsResponse();
            return getLandingZoneOperationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListBaselinesResult listBaselines(ListBaselinesRequest request) {
        request = (ListBaselinesRequest)this.beforeClientExecution(request);
        return this.executeListBaselines(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListBaselinesResult executeListBaselines(ListBaselinesRequest listBaselinesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBaselinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBaselinesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBaselinesRequestProtocolMarshaller(protocolFactory).marshall((ListBaselinesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listBaselinesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListBaselines");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListBaselinesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBaselinesResult listBaselinesResult = (ListBaselinesResult)response.getAwsResponse();
            return listBaselinesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEnabledBaselinesResult listEnabledBaselines(ListEnabledBaselinesRequest request) {
        request = (ListEnabledBaselinesRequest)this.beforeClientExecution(request);
        return this.executeListEnabledBaselines(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEnabledBaselinesResult executeListEnabledBaselines(ListEnabledBaselinesRequest listEnabledBaselinesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEnabledBaselinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEnabledBaselinesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEnabledBaselinesRequestProtocolMarshaller(protocolFactory).marshall((ListEnabledBaselinesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEnabledBaselinesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEnabledBaselines");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEnabledBaselinesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEnabledBaselinesResult listEnabledBaselinesResult = (ListEnabledBaselinesResult)response.getAwsResponse();
            return listEnabledBaselinesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEnabledControlsResult listEnabledControls(ListEnabledControlsRequest request) {
        request = (ListEnabledControlsRequest)this.beforeClientExecution(request);
        return this.executeListEnabledControls(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEnabledControlsResult executeListEnabledControls(ListEnabledControlsRequest listEnabledControlsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEnabledControlsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEnabledControlsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEnabledControlsRequestProtocolMarshaller(protocolFactory).marshall((ListEnabledControlsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEnabledControlsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEnabledControls");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEnabledControlsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEnabledControlsResult listEnabledControlsResult = (ListEnabledControlsResult)response.getAwsResponse();
            return listEnabledControlsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListLandingZonesResult listLandingZones(ListLandingZonesRequest request) {
        request = (ListLandingZonesRequest)this.beforeClientExecution(request);
        return this.executeListLandingZones(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListLandingZonesResult executeListLandingZones(ListLandingZonesRequest listLandingZonesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLandingZonesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLandingZonesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLandingZonesRequestProtocolMarshaller(protocolFactory).marshall((ListLandingZonesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLandingZonesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListLandingZones");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLandingZonesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListLandingZonesResult listLandingZonesResult = (ListLandingZonesResult)response.getAwsResponse();
            return listLandingZonesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResetEnabledBaselineResult resetEnabledBaseline(ResetEnabledBaselineRequest request) {
        request = (ResetEnabledBaselineRequest)this.beforeClientExecution(request);
        return this.executeResetEnabledBaseline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ResetEnabledBaselineResult executeResetEnabledBaseline(ResetEnabledBaselineRequest resetEnabledBaselineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(resetEnabledBaselineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ResetEnabledBaselineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ResetEnabledBaselineRequestProtocolMarshaller(protocolFactory).marshall((ResetEnabledBaselineRequest)super.beforeMarshalling((AmazonWebServiceRequest)resetEnabledBaselineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ResetEnabledBaseline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ResetEnabledBaselineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ResetEnabledBaselineResult resetEnabledBaselineResult = (ResetEnabledBaselineResult)response.getAwsResponse();
            return resetEnabledBaselineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResetLandingZoneResult resetLandingZone(ResetLandingZoneRequest request) {
        request = (ResetLandingZoneRequest)this.beforeClientExecution(request);
        return this.executeResetLandingZone(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ResetLandingZoneResult executeResetLandingZone(ResetLandingZoneRequest resetLandingZoneRequest) {
        ExecutionContext executionContext = this.createExecutionContext(resetLandingZoneRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ResetLandingZoneRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ResetLandingZoneRequestProtocolMarshaller(protocolFactory).marshall((ResetLandingZoneRequest)super.beforeMarshalling((AmazonWebServiceRequest)resetLandingZoneRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ResetLandingZone");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ResetLandingZoneResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ResetLandingZoneResult resetLandingZoneResult = (ResetLandingZoneResult)response.getAwsResponse();
            return resetLandingZoneResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateEnabledBaselineResult updateEnabledBaseline(UpdateEnabledBaselineRequest request) {
        request = (UpdateEnabledBaselineRequest)this.beforeClientExecution(request);
        return this.executeUpdateEnabledBaseline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateEnabledBaselineResult executeUpdateEnabledBaseline(UpdateEnabledBaselineRequest updateEnabledBaselineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEnabledBaselineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEnabledBaselineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEnabledBaselineRequestProtocolMarshaller(protocolFactory).marshall((UpdateEnabledBaselineRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateEnabledBaselineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ControlTower");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateEnabledBaseline");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEnabledBaselineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEnabledBaselineResult updateEnabledBaselineResult = (UpdateEnabledBaselineResult)response.getAwsResponse();
            return updateEnabledBaselineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

