/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.http.timertask.HttpRequestAbortTask;
import com.amazonaws.http.timertask.HttpRequestAbortTaskTracker;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.methods.HttpRequestBase;

@ThreadSafe
public class HttpRequestTimer {
    private final ScheduledThreadPoolExecutor executor;
    private final long requestTimeoutMillis;
    private final boolean enabled;

    private static ScheduledThreadPoolExecutor createExecutor() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(5);
        executor.setRemoveOnCancelPolicy(true);
        executor.setKeepAliveTime(5L, TimeUnit.SECONDS);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public HttpRequestTimer(ClientConfiguration config) {
        this.requestTimeoutMillis = config.getRequestTimeout();
        this.enabled = this.requestTimeoutMillis > 0L;
        this.executor = this.enabled ? HttpRequestTimer.createExecutor() : null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public HttpRequestAbortTaskTracker schedule(HttpRequestBase apacheRequest) {
        if (!this.enabled) {
            throw new IllegalStateException("Trying to schedule a task on a disabled timer.");
        }
        HttpRequestAbortTask timerTask = new HttpRequestAbortTask(apacheRequest);
        ScheduledFuture<?> timerTaskFuture = this.executor.schedule(timerTask, this.requestTimeoutMillis, TimeUnit.MILLISECONDS);
        return new HttpRequestAbortTaskTracker(timerTask, timerTaskFuture);
    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    ScheduledThreadPoolExecutor getExecutor() {
        return this.executor;
    }
}

