/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.timers;

import com.amazonaws.AmazonClientException;
import com.amazonaws.annotation.SdkInternalApi;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

@SdkInternalApi
public class TimeoutThreadPoolBuilder {
    public static ScheduledThreadPoolExecutor buildDefaultTimeoutThreadPool() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(5);
        TimeoutThreadPoolBuilder.safeSetRemoveOnCancel(executor);
        executor.setKeepAliveTime(5L, TimeUnit.SECONDS);
        executor.allowCoreThreadTimeOut(true);
        executor.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setPriority(10);
                return thread;
            }
        });
        return executor;
    }

    private static void safeSetRemoveOnCancel(ScheduledThreadPoolExecutor executor) {
        try {
            executor.getClass().getMethod("setRemoveOnCancelPolicy", Boolean.TYPE).invoke((Object)executor, Boolean.TRUE);
        }
        catch (IllegalAccessException e) {
            TimeoutThreadPoolBuilder.throwSetRemoveOnCancelException(e);
        }
        catch (IllegalArgumentException e) {
            TimeoutThreadPoolBuilder.throwSetRemoveOnCancelException(e);
        }
        catch (InvocationTargetException e) {
            TimeoutThreadPoolBuilder.throwSetRemoveOnCancelException(e.getCause());
        }
        catch (NoSuchMethodException e) {
            throw new AmazonClientException("The request timeout feature is only available for Java 1.7 and above.");
        }
        catch (SecurityException e) {
            throw new AmazonClientException("The request timeout feature needs additional permissions to function.", e);
        }
    }

    private static void throwSetRemoveOnCancelException(Throwable cause) {
        throw new AmazonClientException("Unable to setRemoveOnCancelPolicy for request timeout thread pool", cause);
    }
}

