/*
 * Copyright 2011-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *    http://aws.amazon.com/apache2.0
 *
 * This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
 * OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and
 * limitations under the License.
 */
package com.amazonaws.internal;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

import com.amazonaws.annotation.SdkInternalApi;

/**
 * <p>
 * Provides an interface that returns an endpoint URI
 * from which the credentials can be loaded.
 * </p>
 */
@SdkInternalApi
public interface CredentialsEndpointProvider {
    /**
     * Returns the URI that contains the credentials.
     * @return
     * 		URI to retrieve the credentials.
     *
     * @throws URISyntaxException
     * 				If the endpoint string could not be parsed as a URI reference.
     *
     * @throws IOException
     * 				If any problems are encountered while connecting to the
     *             	service to retrieve the endpoint.
     */
    URI getCredentialsEndpoint() throws URISyntaxException, IOException;
}
