/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.annotation.Immutable;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.http.SdkHttpMetadata;
import java.nio.ByteBuffer;
import java.util.Map;

@Immutable
public class SdkErrorHttpMetadata {
    private final ByteBuffer responseContent;
    private final SdkHttpMetadata httpMetadata;

    @SdkProtectedApi
    public SdkErrorHttpMetadata(SdkHttpMetadata httpMetadata, byte[] responseContent) {
        this.httpMetadata = httpMetadata;
        this.responseContent = ByteBuffer.wrap(responseContent).asReadOnlyBuffer();
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpMetadata.getHttpHeaders();
    }

    public int getHttpStatusCode() {
        return this.httpMetadata.getHttpStatusCode();
    }

    public ByteBuffer getResponseContent() {
        return this.responseContent;
    }
}

