/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.RequestClientOptions;
import com.amazonaws.ResetException;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.Signer;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressInputStream;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.handlers.CredentialsRequestHandler;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpClientFactory;
import com.amazonaws.http.HttpRequestFactory;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.internal.CRC32MismatchException;
import com.amazonaws.internal.ReleasableInputStream;
import com.amazonaws.internal.ResettableInputStream;
import com.amazonaws.internal.SdkBufferedInputStream;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CountingInputStream;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.FakeIOException;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.ResponseMetadataCache;
import com.amazonaws.util.TimingInfo;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.StatusLine;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

@ThreadSafe
public class AmazonHttpClient {
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final Log requestLog;
    static final Log log;
    private static final HttpRequestFactory httpRequestFactory;
    private static final HttpClientFactory httpClientFactory;
    private final HttpClient httpClient;
    private final ClientConfiguration config;
    private final ResponseMetadataCache responseMetadataCache = new ResponseMetadataCache(50);
    private final RequestMetricCollector requestMetricCollector;
    private volatile int timeOffset = SDKGlobalConfiguration.getGlobalTimeOffset();

    public AmazonHttpClient(ClientConfiguration config) {
        this(config, null);
    }

    public AmazonHttpClient(ClientConfiguration config, RequestMetricCollector requestMetricCollector) {
        this(config, httpClientFactory.createHttpClient(config), requestMetricCollector);
    }

    AmazonHttpClient(ClientConfiguration config, HttpClient httpClient, RequestMetricCollector requestMetricCollector) {
        this.config = config;
        this.httpClient = httpClient;
        this.requestMetricCollector = requestMetricCollector;
    }

    public ResponseMetadata getResponseMetadataForRequest(AmazonWebServiceRequest request) {
        return this.responseMetadataCache.get(request);
    }

    public void disableStrictHostnameVerification() {
        if (System.getProperty("com.amazonaws.sdk.disableCertChecking") != null) {
            return;
        }
        try {
            SchemeRegistry schemeRegistry = this.httpClient.getConnectionManager().getSchemeRegistry();
            SSLSocketFactory sf = new SSLSocketFactory(SSLContext.getDefault(), SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            Scheme https = new Scheme("https", 443, (SchemeSocketFactory)sf);
            schemeRegistry.register(https);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AmazonClientException("Unable to access default SSL context to disable strict hostname verification");
        }
    }

    public <T> Response<T> execute(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext) {
        if (executionContext == null) {
            throw new AmazonClientException("Internal SDK Error: No execution context parameter specified.");
        }
        List<RequestHandler2> requestHandler2s = this.requestHandler2s(request, executionContext);
        AmazonWebServiceRequest awsreq = request.getOriginalRequest();
        ProgressListener listener = awsreq.getGeneralProgressListener();
        Map<String, String> customHeaders = awsreq.getCustomRequestHeaders();
        if (customHeaders != null) {
            request.getHeaders().putAll(customHeaders);
        }
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Response<T> response = null;
        InputStream origContent = request.getContent();
        InputStream toBeClosed = this.beforeRequest(request);
        InputStream notCloseable = toBeClosed == null ? null : (InputStream)ReleasableInputStream.wrap(toBeClosed).disableClose();
        request.setContent(notCloseable);
        try {
            SDKProgressPublisher.publishProgress(listener, ProgressEventType.CLIENT_REQUEST_STARTED_EVENT);
            response = this.executeHelper(request, responseHandler, errorResponseHandler, executionContext);
            SDKProgressPublisher.publishProgress(listener, ProgressEventType.CLIENT_REQUEST_SUCCESS_EVENT);
            TimingInfo timingInfo = awsRequestMetrics.getTimingInfo().endTiming();
            this.afterResponse(request, requestHandler2s, response, timingInfo);
            Response<T> response2 = response;
            return response2;
        }
        catch (AmazonClientException e) {
            SDKProgressPublisher.publishProgress(listener, ProgressEventType.CLIENT_REQUEST_FAILED_EVENT);
            this.afterError(request, response, requestHandler2s, e);
            throw e;
        }
        finally {
            IOUtils.closeQuietly(toBeClosed, log);
            request.setContent(origContent);
        }
    }

    private InputStream beforeRequest(Request<?> request) {
        InputStream content;
        AmazonWebServiceRequest awsreq;
        block8: {
            awsreq = request.getOriginalRequest();
            ProgressListener listener = awsreq.getGeneralProgressListener();
            Map<String, String> headers = request.getHeaders();
            String s = headers.get("Content-Length");
            if (s != null) {
                try {
                    long contentLength = Long.parseLong(s);
                    SDKProgressPublisher.publishRequestContentLength(listener, contentLength);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)"Cannot parse the Content-Length header of the request.");
                }
            }
            if ((content = request.getContent()) == null) {
                return null;
            }
            if (!content.markSupported() && content instanceof FileInputStream) {
                try {
                    content = new ResettableInputStream((FileInputStream)content);
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block8;
                    log.debug((Object)"For the record; ignore otherwise", (Throwable)e);
                }
            }
        }
        if (!content.markSupported()) {
            content = new SdkBufferedInputStream(content);
        }
        return ProgressInputStream.inputStreamForRequest(content, awsreq);
    }

    private void afterError(Request<?> request, Response<?> response, List<RequestHandler2> requestHandler2s, AmazonClientException e) {
        for (RequestHandler2 handler2 : requestHandler2s) {
            handler2.afterError(request, response, e);
        }
    }

    private <T> void afterResponse(Request<?> request, List<RequestHandler2> requestHandler2s, Response<T> response, TimingInfo timingInfo) {
        for (RequestHandler2 handler2 : requestHandler2s) {
            handler2.afterResponse(request, response);
        }
    }

    private List<RequestHandler2> requestHandler2s(Request<?> request, ExecutionContext executionContext) {
        List<RequestHandler2> requestHandler2s = executionContext.getRequestHandler2s();
        if (requestHandler2s == null) {
            return Collections.emptyList();
        }
        for (RequestHandler2 requestHandler2 : requestHandler2s) {
            if (requestHandler2 instanceof CredentialsRequestHandler) {
                ((CredentialsRequestHandler)requestHandler2).setCredentials(executionContext.getCredentials());
            }
            requestHandler2.beforeRequest(request);
        }
        return requestHandler2s;
    }

    private <T> Response<T> executeHelper(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext) {
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics().addPropertyWith(AWSRequestMetrics.Field.ServiceName, (Object)request.getServiceName()).addPropertyWith(AWSRequestMetrics.Field.ServiceEndpoint, (Object)request.getEndpoint());
        this.setUserAgent(request);
        LinkedHashMap<String, String> originalParameters = new LinkedHashMap<String, String>(request.getParameters());
        HashMap<String, String> originalHeaders = new HashMap<String, String>(request.getHeaders());
        InputStream requestInputStream = request.getContent();
        if (requestInputStream != null && requestInputStream.markSupported()) {
            AmazonWebServiceRequest awsreq = request.getOriginalRequest();
            int readLimit = awsreq.getRequestClientOptions().getReadLimit();
            requestInputStream.mark(readLimit);
        }
        ExecOneRequestParams p = new ExecOneRequestParams();
        while (true) {
            p.initPerRetry();
            awsRequestMetrics.setCounter(AWSRequestMetrics.Field.RequestCount, (long)p.requestCount);
            if (p.requestCount > 1) {
                request.setParameters(originalParameters);
                request.setHeaders(originalHeaders);
            }
            try {
                Response<T> response = this.executeOneRequest(request, responseHandler, errorResponseHandler, executionContext, awsRequestMetrics, p);
                if (response == null) continue;
                Response<T> response2 = response;
                return response2;
            }
            catch (IOException ioe) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Unable to execute HTTP request: " + ioe.getMessage()), (Throwable)ioe);
                }
                this.captureExceptionMetrics(ioe, awsRequestMetrics);
                awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, null);
                AmazonClientException ace = new AmazonClientException("Unable to execute HTTP request: " + ioe.getMessage(), ioe);
                if (!this.shouldRetry(request.getOriginalRequest(), p.apacheRequest, ace, p.requestCount, this.config.getRetryPolicy())) {
                    throw this.lastReset(ace, request);
                }
                p.retriedException = ace;
                continue;
            }
            catch (RuntimeException e) {
                throw this.lastReset(this.captureExceptionMetrics(e, awsRequestMetrics), request);
            }
            catch (Error e) {
                throw this.lastReset(this.captureExceptionMetrics(e, awsRequestMetrics), request);
            }
            finally {
                HttpEntity entity;
                if (p.leaveHttpConnectionOpen || p.apacheResponse == null || (entity = p.apacheResponse.getEntity()) == null) continue;
                try {
                    IOUtils.closeQuietly(entity.getContent(), log);
                }
                catch (IOException e) {
                    log.warn((Object)"Cannot close the response content.", (Throwable)e);
                }
                continue;
            }
            break;
        }
    }

    private <T extends Throwable> T lastReset(T t, Request<?> req) {
        try {
            InputStream content = req.getContent();
            if (content != null && content.markSupported()) {
                content.reset();
            }
        }
        catch (Exception ex) {
            log.debug((Object)"FYI: failed to reset content inputstream before throwing up", (Throwable)ex);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Response<T> executeOneRequest(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext execContext, AWSRequestMetrics awsRequestMetrics, ExecOneRequestParams p) throws IOException {
        int statusCode;
        InputStream requestInputStream;
        if (p.requestCount > 1 && (requestInputStream = request.getContent()) != null && requestInputStream.markSupported()) {
            try {
                requestInputStream.reset();
            }
            catch (IOException ex) {
                throw new ResetException("Failed to reset the request input stream", ex);
            }
        }
        if (requestLog.isDebugEnabled()) {
            requestLog.debug((Object)("Sending Request: " + request));
        }
        AWSCredentials credentials = execContext.getCredentials();
        AmazonWebServiceRequest awsreq = request.getOriginalRequest();
        p.newSigner(request, execContext);
        if (p.signer != null && credentials != null) {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestSigningTime);
            try {
                if (this.timeOffset != 0) {
                    request.setTimeOffset(this.timeOffset);
                }
                p.signer.sign(request, credentials);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestSigningTime);
            }
        }
        p.newApacheRequest(httpRequestFactory, request, this.config, execContext);
        ProgressListener listener = awsreq.getGeneralProgressListener();
        if (p.requestCount > 1) {
            SDKProgressPublisher.publishProgress(listener, ProgressEventType.CLIENT_REQUEST_RETRY_EVENT);
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RetryPauseTime);
            try {
                if (p.retriedException != null) {
                    this.pauseBeforeNextRetry(request.getOriginalRequest(), p.retriedException, p.requestCount, this.config.getRetryPolicy());
                }
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RetryPauseTime);
            }
        }
        this.captureConnectionPoolMetrics(this.httpClient.getConnectionManager(), awsRequestMetrics);
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute(AWSRequestMetrics.class.getSimpleName(), (Object)awsRequestMetrics);
        p.retriedException = null;
        SDKProgressPublisher.publishProgress(listener, ProgressEventType.HTTP_REQUEST_STARTED_EVENT);
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpRequestTime);
        try {
            p.apacheResponse = this.httpClient.execute((HttpUriRequest)p.apacheRequest, (HttpContext)httpContext);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpRequestTime);
        }
        SDKProgressPublisher.publishProgress(listener, ProgressEventType.HTTP_REQUEST_COMPLETED_EVENT);
        StatusLine statusLine = p.apacheResponse.getStatusLine();
        int n = statusCode = statusLine == null ? -1 : statusLine.getStatusCode();
        if (this.isRequestSuccessful(p.apacheResponse)) {
            awsRequestMetrics.addProperty(AWSRequestMetrics.Field.StatusCode, (Object)statusCode);
            p.leaveHttpConnectionOpen = responseHandler.needsConnectionLeftOpen();
            HttpResponse httpResponse = this.createResponse(p.apacheRequest, request, p.apacheResponse);
            T response = this.handleResponse(request, responseHandler, p.apacheRequest, httpResponse, p.apacheResponse, execContext);
            return new Response<T>(response, httpResponse);
        }
        if (AmazonHttpClient.isTemporaryRedirect(p.apacheResponse)) {
            Header[] locationHeaders = p.apacheResponse.getHeaders("location");
            String redirectedLocation = locationHeaders[0].getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Redirecting to: " + redirectedLocation));
            }
            p.redirectedURI = URI.create(redirectedLocation);
            awsRequestMetrics.addPropertyWith(AWSRequestMetrics.Field.StatusCode, (Object)statusCode).addPropertyWith(AWSRequestMetrics.Field.RedirectLocation, (Object)redirectedLocation).addPropertyWith(AWSRequestMetrics.Field.AWSRequestID, null);
            return null;
        }
        p.leaveHttpConnectionOpen = errorResponseHandler.needsConnectionLeftOpen();
        AmazonServiceException ase = this.handleErrorResponse(request, errorResponseHandler, p.apacheRequest, p.apacheResponse);
        awsRequestMetrics.addPropertyWith(AWSRequestMetrics.Field.AWSRequestID, (Object)ase.getRequestId()).addPropertyWith(AWSRequestMetrics.Field.AWSErrorCode, (Object)ase.getErrorCode()).addPropertyWith(AWSRequestMetrics.Field.StatusCode, (Object)ase.getStatusCode());
        if (!this.shouldRetry(request.getOriginalRequest(), p.apacheRequest, ase, p.requestCount, this.config.getRetryPolicy())) {
            throw ase;
        }
        if (RetryUtils.isThrottlingException(ase)) {
            awsRequestMetrics.incrementCounterWith(AWSRequestMetrics.Field.ThrottleException).addProperty(AWSRequestMetrics.Field.ThrottleException, (Object)ase);
        }
        p.retriedException = ase;
        if (RetryUtils.isClockSkewError(ase)) {
            int clockSkew;
            this.timeOffset = clockSkew = this.parseClockSkewOffset(p.apacheResponse, ase);
            SDKGlobalConfiguration.setGlobalTimeOffset(this.timeOffset);
        }
        return null;
    }

    private void captureConnectionPoolMetrics(ClientConnectionManager connectionManager, AWSRequestMetrics awsRequestMetrics) {
        if (awsRequestMetrics.isEnabled() && connectionManager instanceof ConnPoolControl) {
            ConnPoolControl control = (ConnPoolControl)connectionManager;
            PoolStats stats = control.getTotalStats();
            awsRequestMetrics.withCounter(AWSRequestMetrics.Field.HttpClientPoolAvailableCount, (long)stats.getAvailable()).withCounter(AWSRequestMetrics.Field.HttpClientPoolLeasedCount, (long)stats.getLeased()).withCounter(AWSRequestMetrics.Field.HttpClientPoolPendingCount, (long)stats.getPending());
        }
    }

    private <T extends Throwable> T captureExceptionMetrics(T t, AWSRequestMetrics awsRequestMetrics) {
        AmazonServiceException ase;
        awsRequestMetrics.incrementCounterWith(AWSRequestMetrics.Field.Exception).addProperty(AWSRequestMetrics.Field.Exception, t);
        if (t instanceof AmazonServiceException && RetryUtils.isThrottlingException(ase = (AmazonServiceException)t)) {
            awsRequestMetrics.incrementCounterWith(AWSRequestMetrics.Field.ThrottleException).addProperty(AWSRequestMetrics.Field.ThrottleException, (Object)ase);
        }
        return t;
    }

    private void setUserAgent(Request<?> request) {
        String userAgentMarker;
        AmazonWebServiceRequest awsreq;
        RequestClientOptions opts;
        String userAgent = this.config.getUserAgent();
        if (!userAgent.equals(ClientConfiguration.DEFAULT_USER_AGENT)) {
            userAgent = userAgent + ", " + ClientConfiguration.DEFAULT_USER_AGENT;
        }
        if (userAgent != null) {
            request.addHeader(HEADER_USER_AGENT, userAgent);
        }
        if ((opts = (awsreq = request.getOriginalRequest()).getRequestClientOptions()) != null && (userAgentMarker = opts.getClientMarker(RequestClientOptions.Marker.USER_AGENT)) != null) {
            request.addHeader(HEADER_USER_AGENT, AmazonHttpClient.createUserAgentString(userAgent, userAgentMarker));
        }
    }

    private static String createUserAgentString(String existingUserAgentString, String userAgent) {
        if (existingUserAgentString.contains(userAgent)) {
            return existingUserAgentString;
        }
        return existingUserAgentString.trim() + " " + userAgent.trim();
    }

    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.httpClient.getConnectionManager());
        this.httpClient.getConnectionManager().shutdown();
    }

    private boolean shouldRetry(AmazonWebServiceRequest originalRequest, HttpRequestBase method, AmazonClientException exception, int requestCount, RetryPolicy retryPolicy) {
        HttpEntity entity;
        int retries = requestCount - 1;
        int maxErrorRetry = this.config.getMaxErrorRetry();
        if (maxErrorRetry < 0 || !retryPolicy.isMaxErrorRetryInClientConfigHonored()) {
            maxErrorRetry = retryPolicy.getMaxErrorRetry();
        }
        if (retries >= maxErrorRetry) {
            return false;
        }
        if (method instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)method).getEntity()) != null && !entity.isRepeatable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Entity not repeatable");
            }
            return false;
        }
        return retryPolicy.getRetryCondition().shouldRetry(originalRequest, exception, retries);
    }

    private static boolean isTemporaryRedirect(org.apache.http.HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status == 307 && response.getHeaders("Location") != null && response.getHeaders("Location").length > 0;
    }

    private boolean isRequestSuccessful(org.apache.http.HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status / 100 == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T handleResponse(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpRequestBase method, HttpResponse httpResponse, org.apache.http.HttpResponse apacheHttpResponse, ExecutionContext executionContext) throws IOException {
        AmazonWebServiceRequest awsreq = request.getOriginalRequest();
        ProgressListener listener = awsreq.getGeneralProgressListener();
        try {
            AmazonWebServiceResponse<T> awsResponse;
            Map<String, String> headers;
            String s;
            CountingInputStream countingInputStream = null;
            InputStream is = httpResponse.getContent();
            if (is != null) {
                if (System.getProperty("com.amazonaws.sdk.enableRuntimeProfiling") != null) {
                    countingInputStream = new CountingInputStream(is);
                    is = countingInputStream;
                    httpResponse.setContent(is);
                }
                httpResponse.setContent(ProgressInputStream.inputStreamForResponse(is, awsreq));
            }
            if ((s = (headers = httpResponse.getHeaders()).get("Content-Length")) != null) {
                try {
                    long contentLength = Long.parseLong(s);
                    SDKProgressPublisher.publishResponseContentLength(listener, contentLength);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)"Cannot parse the Content-Length header of the response.");
                }
            }
            AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ResponseProcessingTime);
            SDKProgressPublisher.publishProgress(listener, ProgressEventType.HTTP_RESPONSE_STARTED_EVENT);
            try {
                awsResponse = responseHandler.handle(httpResponse);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ResponseProcessingTime);
            }
            SDKProgressPublisher.publishProgress(listener, ProgressEventType.HTTP_RESPONSE_COMPLETED_EVENT);
            if (countingInputStream != null) {
                awsRequestMetrics.setCounter(AWSRequestMetrics.Field.BytesProcessed, countingInputStream.getByteCount());
            }
            if (awsResponse == null) {
                throw new RuntimeException("Unable to unmarshall response metadata. Response Code: " + httpResponse.getStatusCode() + ", Response Text: " + httpResponse.getStatusText());
            }
            this.responseMetadataCache.add(request.getOriginalRequest(), awsResponse.getResponseMetadata());
            if (requestLog.isDebugEnabled()) {
                StatusLine statusLine = apacheHttpResponse.getStatusLine();
                requestLog.debug((Object)("Received successful response: " + (statusLine == null ? null : Integer.valueOf(statusLine.getStatusCode())) + ", AWS Request ID: " + awsResponse.getRequestId()));
            }
            awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, (Object)awsResponse.getRequestId());
            return awsResponse.getResult();
        }
        catch (CRC32MismatchException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (AmazonClientException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = "Unable to unmarshall response (" + e.getMessage() + "). Response Code: " + httpResponse.getStatusCode() + ", Response Text: " + httpResponse.getStatusText();
            throw new AmazonClientException(errorMessage, e);
        }
    }

    private AmazonServiceException handleErrorResponse(Request<?> request, HttpResponseHandler<AmazonServiceException> errorResponseHandler, HttpRequestBase method, org.apache.http.HttpResponse apacheHttpResponse) throws IOException {
        String reasonPhrase;
        int statusCode;
        StatusLine statusLine = apacheHttpResponse.getStatusLine();
        if (statusLine == null) {
            statusCode = -1;
            reasonPhrase = null;
        } else {
            statusCode = statusLine.getStatusCode();
            reasonPhrase = statusLine.getReasonPhrase();
        }
        HttpResponse response = this.createResponse(method, request, apacheHttpResponse);
        AmazonServiceException exception = null;
        try {
            exception = errorResponseHandler.handle(response);
            if (requestLog.isDebugEnabled()) {
                requestLog.debug((Object)("Received error response: " + exception));
            }
        }
        catch (Exception e) {
            if (statusCode == 413) {
                exception = new AmazonServiceException("Request entity too large");
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(statusCode);
                exception.setErrorType(AmazonServiceException.ErrorType.Client);
                exception.setErrorCode("Request entity too large");
            }
            if (statusCode == 503 && "Service Unavailable".equalsIgnoreCase(reasonPhrase)) {
                exception = new AmazonServiceException("Service unavailable");
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(statusCode);
                exception.setErrorType(AmazonServiceException.ErrorType.Service);
                exception.setErrorCode("Service unavailable");
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            String errorMessage = "Unable to unmarshall error response (" + e.getMessage() + "). Response Code: " + (statusLine == null ? "None" : Integer.valueOf(statusCode)) + ", Response Text: " + reasonPhrase;
            throw new AmazonClientException(errorMessage, e);
        }
        exception.setStatusCode(statusCode);
        exception.setServiceName(request.getServiceName());
        exception.fillInStackTrace();
        return exception;
    }

    private HttpResponse createResponse(HttpRequestBase method, Request<?> request, org.apache.http.HttpResponse apacheHttpResponse) throws IOException {
        HttpResponse httpResponse = new HttpResponse(request, method);
        if (apacheHttpResponse.getEntity() != null) {
            httpResponse.setContent(apacheHttpResponse.getEntity().getContent());
        }
        httpResponse.setStatusCode(apacheHttpResponse.getStatusLine().getStatusCode());
        httpResponse.setStatusText(apacheHttpResponse.getStatusLine().getReasonPhrase());
        for (Header header : apacheHttpResponse.getAllHeaders()) {
            httpResponse.addHeader(header.getName(), header.getValue());
        }
        return httpResponse;
    }

    private void pauseBeforeNextRetry(AmazonWebServiceRequest originalRequest, AmazonClientException previousException, int requestCount, RetryPolicy retryPolicy) {
        int retries = requestCount - 1 - 1;
        long delay = retryPolicy.getBackoffStrategy().delayBeforeNextRetry(originalRequest, previousException, retries);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retriable error detected, will retry in " + delay + "ms, attempt number: " + retries));
        }
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AmazonClientException(e.getMessage(), e);
        }
    }

    private String getServerDateFromException(String body) {
        int startPos = body.indexOf("(");
        int endPos = body.indexOf(" + ");
        if (endPos == -1) {
            endPos = body.indexOf(" - ");
        }
        return endPos == -1 ? null : body.substring(startPos + 1, endPos);
    }

    private int parseClockSkewOffset(org.apache.http.HttpResponse response, AmazonServiceException exception) {
        long currentTimeMilli = System.currentTimeMillis();
        Date serverDate = null;
        String serverDateStr = null;
        Header[] responseDateHeader = response.getHeaders("Date");
        try {
            if (responseDateHeader.length == 0) {
                String errmsg = exception.getMessage();
                serverDateStr = this.getServerDateFromException(errmsg);
                if (serverDateStr == null) {
                    log.warn((Object)("Unable to parse clock skew offset from errmsg: " + errmsg));
                    return 0;
                }
                serverDate = DateUtils.parseCompressedISO8601Date(serverDateStr);
            } else {
                serverDateStr = responseDateHeader[0].getValue();
                serverDate = DateUtils.parseRFC822Date(serverDateStr);
            }
        }
        catch (RuntimeException e) {
            log.warn((Object)("Unable to parse clock skew offset from response: " + serverDateStr), (Throwable)e);
            return 0;
        }
        long diff = currentTimeMilli - serverDate.getTime();
        return (int)(diff / 1000L);
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }

    static {
        String jvmVersion;
        requestLog = LogFactory.getLog((String)"com.amazonaws.request");
        log = LogFactory.getLog(AmazonHttpClient.class);
        httpRequestFactory = new HttpRequestFactory();
        httpClientFactory = new HttpClientFactory();
        List<String> problematicJvmVersions = Arrays.asList("1.6.0_06", "1.6.0_13", "1.6.0_17", "1.6.0_65", "1.7.0_45");
        if (problematicJvmVersions.contains(jvmVersion = System.getProperty("java.version"))) {
            log.warn((Object)("Detected a possible problem with the current JVM version (" + jvmVersion + ").  " + "If you experience XML parsing problems using the SDK, try upgrading to a more recent JVM update."));
        }
    }

    private static class ExecOneRequestParams {
        private Signer signer;
        private URI signerURI;
        int requestCount;
        AmazonClientException retriedException;
        HttpRequestBase apacheRequest;
        org.apache.http.HttpResponse apacheResponse;
        URI redirectedURI;
        boolean leaveHttpConnectionOpen;

        private ExecOneRequestParams() {
        }

        void initPerRetry() {
            ++this.requestCount;
            this.apacheRequest = null;
            this.apacheResponse = null;
            this.leaveHttpConnectionOpen = false;
        }

        Signer newSigner(Request<?> request, ExecutionContext execContext) {
            if (this.redirectedURI != null && !this.redirectedURI.equals(this.signerURI)) {
                this.signerURI = this.redirectedURI;
                this.signer = execContext.getSignerByURI(this.signerURI);
            } else if (this.signer == null) {
                this.signerURI = request.getEndpoint();
                this.signer = execContext.getSignerByURI(this.signerURI);
            }
            return this.signer;
        }

        HttpRequestBase newApacheRequest(HttpRequestFactory httpRequestFactory, Request<?> request, ClientConfiguration config, ExecutionContext execContext) throws FakeIOException {
            this.apacheRequest = httpRequestFactory.createHttpRequest(request, config, execContext);
            if (this.redirectedURI != null) {
                this.apacheRequest.setURI(this.redirectedURI);
            }
            return this.apacheRequest;
        }
    }
}

