/*
 * Copyright 2012-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.costandusagereport.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * Request of PutReportDefinition
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cur-2017-01-06/PutReportDefinition" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PutReportDefinitionRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    private ReportDefinition reportDefinition;

    /**
     * @param reportDefinition
     */

    public void setReportDefinition(ReportDefinition reportDefinition) {
        this.reportDefinition = reportDefinition;
    }

    /**
     * @return
     */

    public ReportDefinition getReportDefinition() {
        return this.reportDefinition;
    }

    /**
     * @param reportDefinition
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutReportDefinitionRequest withReportDefinition(ReportDefinition reportDefinition) {
        setReportDefinition(reportDefinition);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getReportDefinition() != null)
            sb.append("ReportDefinition: ").append(getReportDefinition());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PutReportDefinitionRequest == false)
            return false;
        PutReportDefinitionRequest other = (PutReportDefinitionRequest) obj;
        if (other.getReportDefinition() == null ^ this.getReportDefinition() == null)
            return false;
        if (other.getReportDefinition() != null && other.getReportDefinition().equals(this.getReportDefinition()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getReportDefinition() == null) ? 0 : getReportDefinition().hashCode());
        return hashCode;
    }

    @Override
    public PutReportDefinitionRequest clone() {
        return (PutReportDefinitionRequest) super.clone();
    }

}
