/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.costexplorer.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/StartCostAllocationTagBackfill" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StartCostAllocationTagBackfillResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * An object containing detailed metadata of your new backfill request.
     * </p>
     */
    private CostAllocationTagBackfillRequest backfillRequest;

    /**
     * <p>
     * An object containing detailed metadata of your new backfill request.
     * </p>
     * 
     * @param backfillRequest
     *        An object containing detailed metadata of your new backfill request.
     */

    public void setBackfillRequest(CostAllocationTagBackfillRequest backfillRequest) {
        this.backfillRequest = backfillRequest;
    }

    /**
     * <p>
     * An object containing detailed metadata of your new backfill request.
     * </p>
     * 
     * @return An object containing detailed metadata of your new backfill request.
     */

    public CostAllocationTagBackfillRequest getBackfillRequest() {
        return this.backfillRequest;
    }

    /**
     * <p>
     * An object containing detailed metadata of your new backfill request.
     * </p>
     * 
     * @param backfillRequest
     *        An object containing detailed metadata of your new backfill request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartCostAllocationTagBackfillResult withBackfillRequest(CostAllocationTagBackfillRequest backfillRequest) {
        setBackfillRequest(backfillRequest);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBackfillRequest() != null)
            sb.append("BackfillRequest: ").append(getBackfillRequest());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StartCostAllocationTagBackfillResult == false)
            return false;
        StartCostAllocationTagBackfillResult other = (StartCostAllocationTagBackfillResult) obj;
        if (other.getBackfillRequest() == null ^ this.getBackfillRequest() == null)
            return false;
        if (other.getBackfillRequest() != null && other.getBackfillRequest().equals(this.getBackfillRequest()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBackfillRequest() == null) ? 0 : getBackfillRequest().hashCode());
        return hashCode;
    }

    @Override
    public StartCostAllocationTagBackfillResult clone() {
        try {
            return (StartCostAllocationTagBackfillResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
