/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costoptimizationhub;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.costoptimizationhub.AWSCostOptimizationHub;
import com.amazonaws.services.costoptimizationhub.AWSCostOptimizationHubClientBuilder;
import com.amazonaws.services.costoptimizationhub.model.AWSCostOptimizationHubException;
import com.amazonaws.services.costoptimizationhub.model.GetPreferencesRequest;
import com.amazonaws.services.costoptimizationhub.model.GetPreferencesResult;
import com.amazonaws.services.costoptimizationhub.model.GetRecommendationRequest;
import com.amazonaws.services.costoptimizationhub.model.GetRecommendationResult;
import com.amazonaws.services.costoptimizationhub.model.ListEnrollmentStatusesRequest;
import com.amazonaws.services.costoptimizationhub.model.ListEnrollmentStatusesResult;
import com.amazonaws.services.costoptimizationhub.model.ListRecommendationSummariesRequest;
import com.amazonaws.services.costoptimizationhub.model.ListRecommendationSummariesResult;
import com.amazonaws.services.costoptimizationhub.model.ListRecommendationsRequest;
import com.amazonaws.services.costoptimizationhub.model.ListRecommendationsResult;
import com.amazonaws.services.costoptimizationhub.model.UpdateEnrollmentStatusRequest;
import com.amazonaws.services.costoptimizationhub.model.UpdateEnrollmentStatusResult;
import com.amazonaws.services.costoptimizationhub.model.UpdatePreferencesRequest;
import com.amazonaws.services.costoptimizationhub.model.UpdatePreferencesResult;
import com.amazonaws.services.costoptimizationhub.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.GetPreferencesRequestProtocolMarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.GetPreferencesResultJsonUnmarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.GetRecommendationRequestProtocolMarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.GetRecommendationResultJsonUnmarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.ListEnrollmentStatusesRequestProtocolMarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.ListEnrollmentStatusesResultJsonUnmarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.ListRecommendationSummariesRequestProtocolMarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.ListRecommendationSummariesResultJsonUnmarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.ListRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.ListRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.UpdateEnrollmentStatusRequestProtocolMarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.UpdateEnrollmentStatusResultJsonUnmarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.UpdatePreferencesRequestProtocolMarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.UpdatePreferencesResultJsonUnmarshaller;
import com.amazonaws.services.costoptimizationhub.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCostOptimizationHubClient
extends AmazonWebServiceClient
implements AWSCostOptimizationHub {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCostOptimizationHub.class);
    private static final String DEFAULT_SIGNING_NAME = "cost-optimization-hub";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSCostOptimizationHubException.class));

    public static AWSCostOptimizationHubClientBuilder builder() {
        return AWSCostOptimizationHubClientBuilder.standard();
    }

    AWSCostOptimizationHubClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSCostOptimizationHubClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("cost-optimization-hub.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/costoptimizationhub/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/costoptimizationhub/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public GetPreferencesResult getPreferences(GetPreferencesRequest request) {
        request = (GetPreferencesRequest)this.beforeClientExecution(request);
        return this.executeGetPreferences(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPreferencesResult executeGetPreferences(GetPreferencesRequest getPreferencesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPreferencesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPreferencesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPreferencesRequestProtocolMarshaller(protocolFactory).marshall((GetPreferencesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPreferencesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Optimization Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPreferences");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPreferencesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPreferencesResult getPreferencesResult = (GetPreferencesResult)response.getAwsResponse();
            return getPreferencesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRecommendationResult getRecommendation(GetRecommendationRequest request) {
        request = (GetRecommendationRequest)this.beforeClientExecution(request);
        return this.executeGetRecommendation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRecommendationResult executeGetRecommendation(GetRecommendationRequest getRecommendationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRecommendationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRecommendationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRecommendationRequestProtocolMarshaller(protocolFactory).marshall((GetRecommendationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRecommendationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Optimization Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRecommendation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRecommendationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRecommendationResult getRecommendationResult = (GetRecommendationResult)response.getAwsResponse();
            return getRecommendationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEnrollmentStatusesResult listEnrollmentStatuses(ListEnrollmentStatusesRequest request) {
        request = (ListEnrollmentStatusesRequest)this.beforeClientExecution(request);
        return this.executeListEnrollmentStatuses(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEnrollmentStatusesResult executeListEnrollmentStatuses(ListEnrollmentStatusesRequest listEnrollmentStatusesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEnrollmentStatusesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEnrollmentStatusesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEnrollmentStatusesRequestProtocolMarshaller(protocolFactory).marshall((ListEnrollmentStatusesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEnrollmentStatusesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Optimization Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEnrollmentStatuses");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEnrollmentStatusesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEnrollmentStatusesResult listEnrollmentStatusesResult = (ListEnrollmentStatusesResult)response.getAwsResponse();
            return listEnrollmentStatusesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRecommendationSummariesResult listRecommendationSummaries(ListRecommendationSummariesRequest request) {
        request = (ListRecommendationSummariesRequest)this.beforeClientExecution(request);
        return this.executeListRecommendationSummaries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRecommendationSummariesResult executeListRecommendationSummaries(ListRecommendationSummariesRequest listRecommendationSummariesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecommendationSummariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecommendationSummariesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecommendationSummariesRequestProtocolMarshaller(protocolFactory).marshall((ListRecommendationSummariesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRecommendationSummariesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Optimization Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRecommendationSummaries");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRecommendationSummariesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRecommendationSummariesResult listRecommendationSummariesResult = (ListRecommendationSummariesResult)response.getAwsResponse();
            return listRecommendationSummariesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRecommendationsResult listRecommendations(ListRecommendationsRequest request) {
        request = (ListRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeListRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRecommendationsResult executeListRecommendations(ListRecommendationsRequest listRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ListRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Optimization Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRecommendationsResult listRecommendationsResult = (ListRecommendationsResult)response.getAwsResponse();
            return listRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateEnrollmentStatusResult updateEnrollmentStatus(UpdateEnrollmentStatusRequest request) {
        request = (UpdateEnrollmentStatusRequest)this.beforeClientExecution(request);
        return this.executeUpdateEnrollmentStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateEnrollmentStatusResult executeUpdateEnrollmentStatus(UpdateEnrollmentStatusRequest updateEnrollmentStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEnrollmentStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEnrollmentStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEnrollmentStatusRequestProtocolMarshaller(protocolFactory).marshall((UpdateEnrollmentStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateEnrollmentStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Optimization Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateEnrollmentStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEnrollmentStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEnrollmentStatusResult updateEnrollmentStatusResult = (UpdateEnrollmentStatusResult)response.getAwsResponse();
            return updateEnrollmentStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePreferencesResult updatePreferences(UpdatePreferencesRequest request) {
        request = (UpdatePreferencesRequest)this.beforeClientExecution(request);
        return this.executeUpdatePreferences(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePreferencesResult executeUpdatePreferences(UpdatePreferencesRequest updatePreferencesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePreferencesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePreferencesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePreferencesRequestProtocolMarshaller(protocolFactory).marshall((UpdatePreferencesRequest)super.beforeMarshalling((AmazonWebServiceRequest)updatePreferencesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Cost Optimization Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdatePreferences");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePreferencesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePreferencesResult updatePreferencesResult = (UpdatePreferencesResult)response.getAwsResponse();
            return updatePreferencesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

