/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.customerprofiles.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A ProfileObject in a list of ProfileObjects.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectsItem"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListProfileObjectsItem implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Specifies the kind of object being added to a profile, such as "Salesforce-Account."
     * </p>
     */
    private String objectTypeName;
    /**
     * <p>
     * The unique identifier of the ProfileObject generated by the service.
     * </p>
     */
    private String profileObjectUniqueKey;
    /**
     * <p>
     * A JSON representation of a ProfileObject that belongs to a profile.
     * </p>
     */
    private String object;

    /**
     * <p>
     * Specifies the kind of object being added to a profile, such as "Salesforce-Account."
     * </p>
     * 
     * @param objectTypeName
     *        Specifies the kind of object being added to a profile, such as "Salesforce-Account."
     */

    public void setObjectTypeName(String objectTypeName) {
        this.objectTypeName = objectTypeName;
    }

    /**
     * <p>
     * Specifies the kind of object being added to a profile, such as "Salesforce-Account."
     * </p>
     * 
     * @return Specifies the kind of object being added to a profile, such as "Salesforce-Account."
     */

    public String getObjectTypeName() {
        return this.objectTypeName;
    }

    /**
     * <p>
     * Specifies the kind of object being added to a profile, such as "Salesforce-Account."
     * </p>
     * 
     * @param objectTypeName
     *        Specifies the kind of object being added to a profile, such as "Salesforce-Account."
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListProfileObjectsItem withObjectTypeName(String objectTypeName) {
        setObjectTypeName(objectTypeName);
        return this;
    }

    /**
     * <p>
     * The unique identifier of the ProfileObject generated by the service.
     * </p>
     * 
     * @param profileObjectUniqueKey
     *        The unique identifier of the ProfileObject generated by the service.
     */

    public void setProfileObjectUniqueKey(String profileObjectUniqueKey) {
        this.profileObjectUniqueKey = profileObjectUniqueKey;
    }

    /**
     * <p>
     * The unique identifier of the ProfileObject generated by the service.
     * </p>
     * 
     * @return The unique identifier of the ProfileObject generated by the service.
     */

    public String getProfileObjectUniqueKey() {
        return this.profileObjectUniqueKey;
    }

    /**
     * <p>
     * The unique identifier of the ProfileObject generated by the service.
     * </p>
     * 
     * @param profileObjectUniqueKey
     *        The unique identifier of the ProfileObject generated by the service.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListProfileObjectsItem withProfileObjectUniqueKey(String profileObjectUniqueKey) {
        setProfileObjectUniqueKey(profileObjectUniqueKey);
        return this;
    }

    /**
     * <p>
     * A JSON representation of a ProfileObject that belongs to a profile.
     * </p>
     * 
     * @param object
     *        A JSON representation of a ProfileObject that belongs to a profile.
     */

    public void setObject(String object) {
        this.object = object;
    }

    /**
     * <p>
     * A JSON representation of a ProfileObject that belongs to a profile.
     * </p>
     * 
     * @return A JSON representation of a ProfileObject that belongs to a profile.
     */

    public String getObject() {
        return this.object;
    }

    /**
     * <p>
     * A JSON representation of a ProfileObject that belongs to a profile.
     * </p>
     * 
     * @param object
     *        A JSON representation of a ProfileObject that belongs to a profile.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListProfileObjectsItem withObject(String object) {
        setObject(object);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getObjectTypeName() != null)
            sb.append("ObjectTypeName: ").append(getObjectTypeName()).append(",");
        if (getProfileObjectUniqueKey() != null)
            sb.append("ProfileObjectUniqueKey: ").append(getProfileObjectUniqueKey()).append(",");
        if (getObject() != null)
            sb.append("Object: ").append(getObject());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListProfileObjectsItem == false)
            return false;
        ListProfileObjectsItem other = (ListProfileObjectsItem) obj;
        if (other.getObjectTypeName() == null ^ this.getObjectTypeName() == null)
            return false;
        if (other.getObjectTypeName() != null && other.getObjectTypeName().equals(this.getObjectTypeName()) == false)
            return false;
        if (other.getProfileObjectUniqueKey() == null ^ this.getProfileObjectUniqueKey() == null)
            return false;
        if (other.getProfileObjectUniqueKey() != null && other.getProfileObjectUniqueKey().equals(this.getProfileObjectUniqueKey()) == false)
            return false;
        if (other.getObject() == null ^ this.getObject() == null)
            return false;
        if (other.getObject() != null && other.getObject().equals(this.getObject()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getObjectTypeName() == null) ? 0 : getObjectTypeName().hashCode());
        hashCode = prime * hashCode + ((getProfileObjectUniqueKey() == null) ? 0 : getProfileObjectUniqueKey().hashCode());
        hashCode = prime * hashCode + ((getObject() == null) ? 0 : getObject().hashCode());
        return hashCode;
    }

    @Override
    public ListProfileObjectsItem clone() {
        try {
            return (ListProfileObjectsItem) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.customerprofiles.model.transform.ListProfileObjectsItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
