/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.customerprofiles.model.transform;

import java.util.Map;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.customerprofiles.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * CreateCalculatedAttributeDefinitionRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class CreateCalculatedAttributeDefinitionRequestMarshaller {

    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH)
            .marshallLocationName("DomainName").build();
    private static final MarshallingInfo<String> CALCULATEDATTRIBUTENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("CalculatedAttributeName").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTEDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeDetails").build();
    private static final MarshallingInfo<StructuredPojo> CONDITIONS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Conditions").build();
    private static final MarshallingInfo<String> STATISTIC_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Statistic").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Tags").build();

    private static final CreateCalculatedAttributeDefinitionRequestMarshaller instance = new CreateCalculatedAttributeDefinitionRequestMarshaller();

    public static CreateCalculatedAttributeDefinitionRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(CreateCalculatedAttributeDefinitionRequest createCalculatedAttributeDefinitionRequest, ProtocolMarshaller protocolMarshaller) {

        if (createCalculatedAttributeDefinitionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(createCalculatedAttributeDefinitionRequest.getDomainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(createCalculatedAttributeDefinitionRequest.getCalculatedAttributeName(), CALCULATEDATTRIBUTENAME_BINDING);
            protocolMarshaller.marshall(createCalculatedAttributeDefinitionRequest.getDisplayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall(createCalculatedAttributeDefinitionRequest.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(createCalculatedAttributeDefinitionRequest.getAttributeDetails(), ATTRIBUTEDETAILS_BINDING);
            protocolMarshaller.marshall(createCalculatedAttributeDefinitionRequest.getConditions(), CONDITIONS_BINDING);
            protocolMarshaller.marshall(createCalculatedAttributeDefinitionRequest.getStatistic(), STATISTIC_BINDING);
            protocolMarshaller.marshall(createCalculatedAttributeDefinitionRequest.getTags(), TAGS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
