/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.customerprofiles;

import javax.annotation.Generated;

import com.amazonaws.services.customerprofiles.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonCustomerProfiles}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonCustomerProfiles implements AmazonCustomerProfiles {

    protected AbstractAmazonCustomerProfiles() {
    }

    @Override
    public AddProfileKeyResult addProfileKey(AddProfileKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCalculatedAttributeDefinitionResult createCalculatedAttributeDefinition(CreateCalculatedAttributeDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDomainResult createDomain(CreateDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEventStreamResult createEventStream(CreateEventStreamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIntegrationWorkflowResult createIntegrationWorkflow(CreateIntegrationWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProfileResult createProfile(CreateProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCalculatedAttributeDefinitionResult deleteCalculatedAttributeDefinition(DeleteCalculatedAttributeDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDomainResult deleteDomain(DeleteDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEventStreamResult deleteEventStream(DeleteEventStreamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIntegrationResult deleteIntegration(DeleteIntegrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProfileResult deleteProfile(DeleteProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProfileKeyResult deleteProfileKey(DeleteProfileKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProfileObjectResult deleteProfileObject(DeleteProfileObjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProfileObjectTypeResult deleteProfileObjectType(DeleteProfileObjectTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkflowResult deleteWorkflow(DeleteWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectProfileObjectTypeResult detectProfileObjectType(DetectProfileObjectTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAutoMergingPreviewResult getAutoMergingPreview(GetAutoMergingPreviewRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCalculatedAttributeDefinitionResult getCalculatedAttributeDefinition(GetCalculatedAttributeDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCalculatedAttributeForProfileResult getCalculatedAttributeForProfile(GetCalculatedAttributeForProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDomainResult getDomain(GetDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEventStreamResult getEventStream(GetEventStreamRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIdentityResolutionJobResult getIdentityResolutionJob(GetIdentityResolutionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIntegrationResult getIntegration(GetIntegrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMatchesResult getMatches(GetMatchesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProfileObjectTypeResult getProfileObjectType(GetProfileObjectTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProfileObjectTypeTemplateResult getProfileObjectTypeTemplate(GetProfileObjectTypeTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSimilarProfilesResult getSimilarProfiles(GetSimilarProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkflowResult getWorkflow(GetWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkflowStepsResult getWorkflowSteps(GetWorkflowStepsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountIntegrationsResult listAccountIntegrations(ListAccountIntegrationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCalculatedAttributeDefinitionsResult listCalculatedAttributeDefinitions(ListCalculatedAttributeDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCalculatedAttributesForProfileResult listCalculatedAttributesForProfile(ListCalculatedAttributesForProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDomainsResult listDomains(ListDomainsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEventStreamsResult listEventStreams(ListEventStreamsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIdentityResolutionJobsResult listIdentityResolutionJobs(ListIdentityResolutionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIntegrationsResult listIntegrations(ListIntegrationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProfileObjectTypeTemplatesResult listProfileObjectTypeTemplates(ListProfileObjectTypeTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProfileObjectTypesResult listProfileObjectTypes(ListProfileObjectTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProfileObjectsResult listProfileObjects(ListProfileObjectsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRuleBasedMatchesResult listRuleBasedMatches(ListRuleBasedMatchesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkflowsResult listWorkflows(ListWorkflowsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public MergeProfilesResult mergeProfiles(MergeProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutIntegrationResult putIntegration(PutIntegrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutProfileObjectResult putProfileObject(PutProfileObjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutProfileObjectTypeResult putProfileObjectType(PutProfileObjectTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchProfilesResult searchProfiles(SearchProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCalculatedAttributeDefinitionResult updateCalculatedAttributeDefinition(UpdateCalculatedAttributeDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDomainResult updateDomain(UpdateDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProfileResult updateProfile(UpdateProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
