/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.dataexchange.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateAsset" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateAssetRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The unique identifier for an asset.
     * </p>
     */
    private String assetId;
    /**
     * <p>
     * The unique identifier for a data set.
     * </p>
     */
    private String dataSetId;
    /**
     * <p>
     * The name of the asset. When importing from Amazon S3, the Amazon S3 object key is used as the asset name. When
     * exporting to Amazon S3, the asset name is used as default target Amazon S3 object key. When importing from Amazon
     * API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name
     * is used as the asset name. When importing from AWS Lake Formation, the static values of
     * "Database(s) included in the LF-tag policy" or "Table(s) included in LF-tag policy" are used as the name.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The unique identifier for a revision.
     * </p>
     */
    private String revisionId;

    /**
     * <p>
     * The unique identifier for an asset.
     * </p>
     * 
     * @param assetId
     *        The unique identifier for an asset.
     */

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    /**
     * <p>
     * The unique identifier for an asset.
     * </p>
     * 
     * @return The unique identifier for an asset.
     */

    public String getAssetId() {
        return this.assetId;
    }

    /**
     * <p>
     * The unique identifier for an asset.
     * </p>
     * 
     * @param assetId
     *        The unique identifier for an asset.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateAssetRequest withAssetId(String assetId) {
        setAssetId(assetId);
        return this;
    }

    /**
     * <p>
     * The unique identifier for a data set.
     * </p>
     * 
     * @param dataSetId
     *        The unique identifier for a data set.
     */

    public void setDataSetId(String dataSetId) {
        this.dataSetId = dataSetId;
    }

    /**
     * <p>
     * The unique identifier for a data set.
     * </p>
     * 
     * @return The unique identifier for a data set.
     */

    public String getDataSetId() {
        return this.dataSetId;
    }

    /**
     * <p>
     * The unique identifier for a data set.
     * </p>
     * 
     * @param dataSetId
     *        The unique identifier for a data set.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateAssetRequest withDataSetId(String dataSetId) {
        setDataSetId(dataSetId);
        return this;
    }

    /**
     * <p>
     * The name of the asset. When importing from Amazon S3, the Amazon S3 object key is used as the asset name. When
     * exporting to Amazon S3, the asset name is used as default target Amazon S3 object key. When importing from Amazon
     * API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name
     * is used as the asset name. When importing from AWS Lake Formation, the static values of
     * "Database(s) included in the LF-tag policy" or "Table(s) included in LF-tag policy" are used as the name.
     * </p>
     * 
     * @param name
     *        The name of the asset. When importing from Amazon S3, the Amazon S3 object key is used as the asset name.
     *        When exporting to Amazon S3, the asset name is used as default target Amazon S3 object key. When importing
     *        from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift,
     *        the datashare name is used as the asset name. When importing from AWS Lake Formation, the static values of
     *        "Database(s) included in the LF-tag policy" or "Table(s) included in LF-tag policy" are used as the name.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the asset. When importing from Amazon S3, the Amazon S3 object key is used as the asset name. When
     * exporting to Amazon S3, the asset name is used as default target Amazon S3 object key. When importing from Amazon
     * API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name
     * is used as the asset name. When importing from AWS Lake Formation, the static values of
     * "Database(s) included in the LF-tag policy" or "Table(s) included in LF-tag policy" are used as the name.
     * </p>
     * 
     * @return The name of the asset. When importing from Amazon S3, the Amazon S3 object key is used as the asset name.
     *         When exporting to Amazon S3, the asset name is used as default target Amazon S3 object key. When
     *         importing from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon
     *         Redshift, the datashare name is used as the asset name. When importing from AWS Lake Formation, the
     *         static values of "Database(s) included in the LF-tag policy" or "Table(s) included in LF-tag policy" are
     *         used as the name.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the asset. When importing from Amazon S3, the Amazon S3 object key is used as the asset name. When
     * exporting to Amazon S3, the asset name is used as default target Amazon S3 object key. When importing from Amazon
     * API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift, the datashare name
     * is used as the asset name. When importing from AWS Lake Formation, the static values of
     * "Database(s) included in the LF-tag policy" or "Table(s) included in LF-tag policy" are used as the name.
     * </p>
     * 
     * @param name
     *        The name of the asset. When importing from Amazon S3, the Amazon S3 object key is used as the asset name.
     *        When exporting to Amazon S3, the asset name is used as default target Amazon S3 object key. When importing
     *        from Amazon API Gateway API, the API name is used as the asset name. When importing from Amazon Redshift,
     *        the datashare name is used as the asset name. When importing from AWS Lake Formation, the static values of
     *        "Database(s) included in the LF-tag policy" or "Table(s) included in LF-tag policy" are used as the name.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateAssetRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The unique identifier for a revision.
     * </p>
     * 
     * @param revisionId
     *        The unique identifier for a revision.
     */

    public void setRevisionId(String revisionId) {
        this.revisionId = revisionId;
    }

    /**
     * <p>
     * The unique identifier for a revision.
     * </p>
     * 
     * @return The unique identifier for a revision.
     */

    public String getRevisionId() {
        return this.revisionId;
    }

    /**
     * <p>
     * The unique identifier for a revision.
     * </p>
     * 
     * @param revisionId
     *        The unique identifier for a revision.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateAssetRequest withRevisionId(String revisionId) {
        setRevisionId(revisionId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAssetId() != null)
            sb.append("AssetId: ").append(getAssetId()).append(",");
        if (getDataSetId() != null)
            sb.append("DataSetId: ").append(getDataSetId()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getRevisionId() != null)
            sb.append("RevisionId: ").append(getRevisionId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateAssetRequest == false)
            return false;
        UpdateAssetRequest other = (UpdateAssetRequest) obj;
        if (other.getAssetId() == null ^ this.getAssetId() == null)
            return false;
        if (other.getAssetId() != null && other.getAssetId().equals(this.getAssetId()) == false)
            return false;
        if (other.getDataSetId() == null ^ this.getDataSetId() == null)
            return false;
        if (other.getDataSetId() != null && other.getDataSetId().equals(this.getDataSetId()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getRevisionId() == null ^ this.getRevisionId() == null)
            return false;
        if (other.getRevisionId() != null && other.getRevisionId().equals(this.getRevisionId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAssetId() == null) ? 0 : getAssetId().hashCode());
        hashCode = prime * hashCode + ((getDataSetId() == null) ? 0 : getDataSetId().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getRevisionId() == null) ? 0 : getRevisionId().hashCode());
        return hashCode;
    }

    @Override
    public UpdateAssetRequest clone() {
        return (UpdateAssetRequest) super.clone();
    }

}
