/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.dataexchange;

import javax.annotation.Generated;

import com.amazonaws.services.dataexchange.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSDataExchange}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSDataExchange implements AWSDataExchange {

    protected AbstractAWSDataExchange() {
    }

    @Override
    public CancelJobResult cancelJob(CancelJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataSetResult createDataSet(CreateDataSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEventActionResult createEventAction(CreateEventActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateJobResult createJob(CreateJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRevisionResult createRevision(CreateRevisionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAssetResult deleteAsset(DeleteAssetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataSetResult deleteDataSet(DeleteDataSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEventActionResult deleteEventAction(DeleteEventActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRevisionResult deleteRevision(DeleteRevisionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssetResult getAsset(GetAssetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataSetResult getDataSet(GetDataSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEventActionResult getEventAction(GetEventActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetJobResult getJob(GetJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRevisionResult getRevision(GetRevisionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataSetRevisionsResult listDataSetRevisions(ListDataSetRevisionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataSetsResult listDataSets(ListDataSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEventActionsResult listEventActions(ListEventActionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRevisionAssetsResult listRevisionAssets(ListRevisionAssetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RevokeRevisionResult revokeRevision(RevokeRevisionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendDataSetNotificationResult sendDataSetNotification(SendDataSetNotificationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartJobResult startJob(StartJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAssetResult updateAsset(UpdateAssetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataSetResult updateDataSet(UpdateDataSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEventActionResult updateEventAction(UpdateEventActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRevisionResult updateRevision(UpdateRevisionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
