/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.dataexchange.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.dataexchange.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AssetDetails JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AssetDetailsJsonUnmarshaller implements Unmarshaller<AssetDetails, JsonUnmarshallerContext> {

    public AssetDetails unmarshall(JsonUnmarshallerContext context) throws Exception {
        AssetDetails assetDetails = new AssetDetails();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("S3SnapshotAsset", targetDepth)) {
                    context.nextToken();
                    assetDetails.setS3SnapshotAsset(S3SnapshotAssetJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("RedshiftDataShareAsset", targetDepth)) {
                    context.nextToken();
                    assetDetails.setRedshiftDataShareAsset(RedshiftDataShareAssetJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ApiGatewayApiAsset", targetDepth)) {
                    context.nextToken();
                    assetDetails.setApiGatewayApiAsset(ApiGatewayApiAssetJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("S3DataAccessAsset", targetDepth)) {
                    context.nextToken();
                    assetDetails.setS3DataAccessAsset(S3DataAccessAssetJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LakeFormationDataPermissionAsset", targetDepth)) {
                    context.nextToken();
                    assetDetails.setLakeFormationDataPermissionAsset(LakeFormationDataPermissionAssetJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return assetDetails;
    }

    private static AssetDetailsJsonUnmarshaller instance;

    public static AssetDetailsJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new AssetDetailsJsonUnmarshaller();
        return instance;
    }
}
