/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dataexchange.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dataexchange.model.transform.S3DataAccessDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class S3DataAccessDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> keyPrefixes;
    private List<String> keys;

    public List<String> getKeyPrefixes() {
        return this.keyPrefixes;
    }

    public void setKeyPrefixes(Collection<String> keyPrefixes) {
        if (keyPrefixes == null) {
            this.keyPrefixes = null;
            return;
        }
        this.keyPrefixes = new ArrayList<String>(keyPrefixes);
    }

    public S3DataAccessDetails withKeyPrefixes(String ... keyPrefixes) {
        if (this.keyPrefixes == null) {
            this.setKeyPrefixes(new ArrayList<String>(keyPrefixes.length));
        }
        for (String ele : keyPrefixes) {
            this.keyPrefixes.add(ele);
        }
        return this;
    }

    public S3DataAccessDetails withKeyPrefixes(Collection<String> keyPrefixes) {
        this.setKeyPrefixes(keyPrefixes);
        return this;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public void setKeys(Collection<String> keys) {
        if (keys == null) {
            this.keys = null;
            return;
        }
        this.keys = new ArrayList<String>(keys);
    }

    public S3DataAccessDetails withKeys(String ... keys) {
        if (this.keys == null) {
            this.setKeys(new ArrayList<String>(keys.length));
        }
        for (String ele : keys) {
            this.keys.add(ele);
        }
        return this;
    }

    public S3DataAccessDetails withKeys(Collection<String> keys) {
        this.setKeys(keys);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyPrefixes() != null) {
            sb.append("KeyPrefixes: ").append(this.getKeyPrefixes()).append(",");
        }
        if (this.getKeys() != null) {
            sb.append("Keys: ").append(this.getKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataAccessDetails)) {
            return false;
        }
        S3DataAccessDetails other = (S3DataAccessDetails)obj;
        if (other.getKeyPrefixes() == null ^ this.getKeyPrefixes() == null) {
            return false;
        }
        if (other.getKeyPrefixes() != null && !other.getKeyPrefixes().equals(this.getKeyPrefixes())) {
            return false;
        }
        if (other.getKeys() == null ^ this.getKeys() == null) {
            return false;
        }
        return other.getKeys() == null || other.getKeys().equals(this.getKeys());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyPrefixes() == null ? 0 : this.getKeyPrefixes().hashCode());
        hashCode = 31 * hashCode + (this.getKeys() == null ? 0 : this.getKeys().hashCode());
        return hashCode;
    }

    public S3DataAccessDetails clone() {
        try {
            return (S3DataAccessDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DataAccessDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

