/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.datapipeline.DataPipelineAsync;
import com.amazonaws.services.datapipeline.DataPipelineClient;
import com.amazonaws.services.datapipeline.model.ActivatePipelineRequest;
import com.amazonaws.services.datapipeline.model.ActivatePipelineResult;
import com.amazonaws.services.datapipeline.model.AddTagsRequest;
import com.amazonaws.services.datapipeline.model.AddTagsResult;
import com.amazonaws.services.datapipeline.model.CreatePipelineRequest;
import com.amazonaws.services.datapipeline.model.CreatePipelineResult;
import com.amazonaws.services.datapipeline.model.DeactivatePipelineRequest;
import com.amazonaws.services.datapipeline.model.DeactivatePipelineResult;
import com.amazonaws.services.datapipeline.model.DeletePipelineRequest;
import com.amazonaws.services.datapipeline.model.DescribeObjectsRequest;
import com.amazonaws.services.datapipeline.model.DescribeObjectsResult;
import com.amazonaws.services.datapipeline.model.DescribePipelinesRequest;
import com.amazonaws.services.datapipeline.model.DescribePipelinesResult;
import com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest;
import com.amazonaws.services.datapipeline.model.EvaluateExpressionResult;
import com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.GetPipelineDefinitionResult;
import com.amazonaws.services.datapipeline.model.ListPipelinesRequest;
import com.amazonaws.services.datapipeline.model.ListPipelinesResult;
import com.amazonaws.services.datapipeline.model.PollForTaskRequest;
import com.amazonaws.services.datapipeline.model.PollForTaskResult;
import com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.PutPipelineDefinitionResult;
import com.amazonaws.services.datapipeline.model.QueryObjectsRequest;
import com.amazonaws.services.datapipeline.model.QueryObjectsResult;
import com.amazonaws.services.datapipeline.model.RemoveTagsRequest;
import com.amazonaws.services.datapipeline.model.RemoveTagsResult;
import com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest;
import com.amazonaws.services.datapipeline.model.ReportTaskProgressResult;
import com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest;
import com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatResult;
import com.amazonaws.services.datapipeline.model.SetStatusRequest;
import com.amazonaws.services.datapipeline.model.SetTaskStatusRequest;
import com.amazonaws.services.datapipeline.model.SetTaskStatusResult;
import com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class DataPipelineAsyncClient
extends DataPipelineClient
implements DataPipelineAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public DataPipelineAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public DataPipelineAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public DataPipelineAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public DataPipelineAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, new ClientConfiguration(), executorService);
    }

    public DataPipelineAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public DataPipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public DataPipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public DataPipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public DataPipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<ActivatePipelineResult> activatePipelineAsync(ActivatePipelineRequest request) {
        return this.activatePipelineAsync(request, null);
    }

    @Override
    public Future<ActivatePipelineResult> activatePipelineAsync(final ActivatePipelineRequest request, final AsyncHandler<ActivatePipelineRequest, ActivatePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<ActivatePipelineResult>(){

            @Override
            public ActivatePipelineResult call() throws Exception {
                ActivatePipelineResult result;
                try {
                    result = DataPipelineAsyncClient.this.activatePipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(AddTagsRequest request) {
        return this.addTagsAsync(request, null);
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(final AddTagsRequest request, final AsyncHandler<AddTagsRequest, AddTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddTagsResult>(){

            @Override
            public AddTagsResult call() throws Exception {
                AddTagsResult result;
                try {
                    result = DataPipelineAsyncClient.this.addTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(CreatePipelineRequest request) {
        return this.createPipelineAsync(request, null);
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(final CreatePipelineRequest request, final AsyncHandler<CreatePipelineRequest, CreatePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                CreatePipelineResult result;
                try {
                    result = DataPipelineAsyncClient.this.createPipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeactivatePipelineResult> deactivatePipelineAsync(DeactivatePipelineRequest request) {
        return this.deactivatePipelineAsync(request, null);
    }

    @Override
    public Future<DeactivatePipelineResult> deactivatePipelineAsync(final DeactivatePipelineRequest request, final AsyncHandler<DeactivatePipelineRequest, DeactivatePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeactivatePipelineResult>(){

            @Override
            public DeactivatePipelineResult call() throws Exception {
                DeactivatePipelineResult result;
                try {
                    result = DataPipelineAsyncClient.this.deactivatePipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deletePipelineAsync(DeletePipelineRequest request) {
        return this.deletePipelineAsync(request, null);
    }

    @Override
    public Future<Void> deletePipelineAsync(final DeletePipelineRequest request, final AsyncHandler<DeletePipelineRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    DataPipelineAsyncClient.this.deletePipeline(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeObjectsResult> describeObjectsAsync(DescribeObjectsRequest request) {
        return this.describeObjectsAsync(request, null);
    }

    @Override
    public Future<DescribeObjectsResult> describeObjectsAsync(final DescribeObjectsRequest request, final AsyncHandler<DescribeObjectsRequest, DescribeObjectsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeObjectsResult>(){

            @Override
            public DescribeObjectsResult call() throws Exception {
                DescribeObjectsResult result;
                try {
                    result = DataPipelineAsyncClient.this.describeObjects(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePipelinesResult> describePipelinesAsync(DescribePipelinesRequest request) {
        return this.describePipelinesAsync(request, null);
    }

    @Override
    public Future<DescribePipelinesResult> describePipelinesAsync(final DescribePipelinesRequest request, final AsyncHandler<DescribePipelinesRequest, DescribePipelinesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribePipelinesResult>(){

            @Override
            public DescribePipelinesResult call() throws Exception {
                DescribePipelinesResult result;
                try {
                    result = DataPipelineAsyncClient.this.describePipelines(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EvaluateExpressionResult> evaluateExpressionAsync(EvaluateExpressionRequest request) {
        return this.evaluateExpressionAsync(request, null);
    }

    @Override
    public Future<EvaluateExpressionResult> evaluateExpressionAsync(final EvaluateExpressionRequest request, final AsyncHandler<EvaluateExpressionRequest, EvaluateExpressionResult> asyncHandler) {
        return this.executorService.submit(new Callable<EvaluateExpressionResult>(){

            @Override
            public EvaluateExpressionResult call() throws Exception {
                EvaluateExpressionResult result;
                try {
                    result = DataPipelineAsyncClient.this.evaluateExpression(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineDefinitionResult> getPipelineDefinitionAsync(GetPipelineDefinitionRequest request) {
        return this.getPipelineDefinitionAsync(request, null);
    }

    @Override
    public Future<GetPipelineDefinitionResult> getPipelineDefinitionAsync(final GetPipelineDefinitionRequest request, final AsyncHandler<GetPipelineDefinitionRequest, GetPipelineDefinitionResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPipelineDefinitionResult>(){

            @Override
            public GetPipelineDefinitionResult call() throws Exception {
                GetPipelineDefinitionResult result;
                try {
                    result = DataPipelineAsyncClient.this.getPipelineDefinition(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(ListPipelinesRequest request) {
        return this.listPipelinesAsync(request, null);
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(final ListPipelinesRequest request, final AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                ListPipelinesResult result;
                try {
                    result = DataPipelineAsyncClient.this.listPipelines(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync() {
        return this.listPipelinesAsync(new ListPipelinesRequest());
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        return this.listPipelinesAsync(new ListPipelinesRequest(), asyncHandler);
    }

    @Override
    public Future<PollForTaskResult> pollForTaskAsync(PollForTaskRequest request) {
        return this.pollForTaskAsync(request, null);
    }

    @Override
    public Future<PollForTaskResult> pollForTaskAsync(final PollForTaskRequest request, final AsyncHandler<PollForTaskRequest, PollForTaskResult> asyncHandler) {
        return this.executorService.submit(new Callable<PollForTaskResult>(){

            @Override
            public PollForTaskResult call() throws Exception {
                PollForTaskResult result;
                try {
                    result = DataPipelineAsyncClient.this.pollForTask(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutPipelineDefinitionResult> putPipelineDefinitionAsync(PutPipelineDefinitionRequest request) {
        return this.putPipelineDefinitionAsync(request, null);
    }

    @Override
    public Future<PutPipelineDefinitionResult> putPipelineDefinitionAsync(final PutPipelineDefinitionRequest request, final AsyncHandler<PutPipelineDefinitionRequest, PutPipelineDefinitionResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutPipelineDefinitionResult>(){

            @Override
            public PutPipelineDefinitionResult call() throws Exception {
                PutPipelineDefinitionResult result;
                try {
                    result = DataPipelineAsyncClient.this.putPipelineDefinition(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<QueryObjectsResult> queryObjectsAsync(QueryObjectsRequest request) {
        return this.queryObjectsAsync(request, null);
    }

    @Override
    public Future<QueryObjectsResult> queryObjectsAsync(final QueryObjectsRequest request, final AsyncHandler<QueryObjectsRequest, QueryObjectsResult> asyncHandler) {
        return this.executorService.submit(new Callable<QueryObjectsResult>(){

            @Override
            public QueryObjectsResult call() throws Exception {
                QueryObjectsResult result;
                try {
                    result = DataPipelineAsyncClient.this.queryObjects(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsResult> removeTagsAsync(RemoveTagsRequest request) {
        return this.removeTagsAsync(request, null);
    }

    @Override
    public Future<RemoveTagsResult> removeTagsAsync(final RemoveTagsRequest request, final AsyncHandler<RemoveTagsRequest, RemoveTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemoveTagsResult>(){

            @Override
            public RemoveTagsResult call() throws Exception {
                RemoveTagsResult result;
                try {
                    result = DataPipelineAsyncClient.this.removeTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReportTaskProgressResult> reportTaskProgressAsync(ReportTaskProgressRequest request) {
        return this.reportTaskProgressAsync(request, null);
    }

    @Override
    public Future<ReportTaskProgressResult> reportTaskProgressAsync(final ReportTaskProgressRequest request, final AsyncHandler<ReportTaskProgressRequest, ReportTaskProgressResult> asyncHandler) {
        return this.executorService.submit(new Callable<ReportTaskProgressResult>(){

            @Override
            public ReportTaskProgressResult call() throws Exception {
                ReportTaskProgressResult result;
                try {
                    result = DataPipelineAsyncClient.this.reportTaskProgress(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReportTaskRunnerHeartbeatResult> reportTaskRunnerHeartbeatAsync(ReportTaskRunnerHeartbeatRequest request) {
        return this.reportTaskRunnerHeartbeatAsync(request, null);
    }

    @Override
    public Future<ReportTaskRunnerHeartbeatResult> reportTaskRunnerHeartbeatAsync(final ReportTaskRunnerHeartbeatRequest request, final AsyncHandler<ReportTaskRunnerHeartbeatRequest, ReportTaskRunnerHeartbeatResult> asyncHandler) {
        return this.executorService.submit(new Callable<ReportTaskRunnerHeartbeatResult>(){

            @Override
            public ReportTaskRunnerHeartbeatResult call() throws Exception {
                ReportTaskRunnerHeartbeatResult result;
                try {
                    result = DataPipelineAsyncClient.this.reportTaskRunnerHeartbeat(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> setStatusAsync(SetStatusRequest request) {
        return this.setStatusAsync(request, null);
    }

    @Override
    public Future<Void> setStatusAsync(final SetStatusRequest request, final AsyncHandler<SetStatusRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    DataPipelineAsyncClient.this.setStatus(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetTaskStatusResult> setTaskStatusAsync(SetTaskStatusRequest request) {
        return this.setTaskStatusAsync(request, null);
    }

    @Override
    public Future<SetTaskStatusResult> setTaskStatusAsync(final SetTaskStatusRequest request, final AsyncHandler<SetTaskStatusRequest, SetTaskStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetTaskStatusResult>(){

            @Override
            public SetTaskStatusResult call() throws Exception {
                SetTaskStatusResult result;
                try {
                    result = DataPipelineAsyncClient.this.setTaskStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ValidatePipelineDefinitionResult> validatePipelineDefinitionAsync(ValidatePipelineDefinitionRequest request) {
        return this.validatePipelineDefinitionAsync(request, null);
    }

    @Override
    public Future<ValidatePipelineDefinitionResult> validatePipelineDefinitionAsync(final ValidatePipelineDefinitionRequest request, final AsyncHandler<ValidatePipelineDefinitionRequest, ValidatePipelineDefinitionResult> asyncHandler) {
        return this.executorService.submit(new Callable<ValidatePipelineDefinitionResult>(){

            @Override
            public ValidatePipelineDefinitionResult call() throws Exception {
                ValidatePipelineDefinitionResult result;
                try {
                    result = DataPipelineAsyncClient.this.validatePipelineDefinition(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

