/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.ValidationError;
import com.amazonaws.util.json.JSONWriter;

public class ValidationErrorJsonMarshaller {
    private static ValidationErrorJsonMarshaller instance;

    public void marshall(ValidationError validationError, JSONWriter jsonWriter) {
        if (validationError == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList errorsList;
            jsonWriter.object();
            if (validationError.getId() != null) {
                jsonWriter.key("id").value((Object)validationError.getId());
            }
            if (!(errorsList = (SdkInternalList)validationError.getErrors()).isEmpty() || !errorsList.isAutoConstruct()) {
                jsonWriter.key("errors");
                jsonWriter.array();
                for (String errorsListValue : errorsList) {
                    if (errorsListValue == null) continue;
                    jsonWriter.value((Object)errorsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ValidationErrorJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ValidationErrorJsonMarshaller();
        }
        return instance;
    }
}

