/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.DescribePipelinesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribePipelinesRequestMarshaller
implements Marshaller<Request<DescribePipelinesRequest>, DescribePipelinesRequest> {
    public Request<DescribePipelinesRequest> marshall(DescribePipelinesRequest describePipelinesRequest) {
        if (describePipelinesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describePipelinesRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.DescribePipelines");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            SdkInternalList pipelineIdsList = (SdkInternalList)describePipelinesRequest.getPipelineIds();
            if (!pipelineIdsList.isEmpty() || !pipelineIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("pipelineIds");
                jsonGenerator.writeStartArray();
                for (String pipelineIdsListValue : pipelineIdsList) {
                    if (pipelineIdsListValue == null) continue;
                    jsonGenerator.writeValue(pipelineIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

