/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.datapipeline.model.QueryObjectsRequest;
import com.amazonaws.services.datapipeline.model.transform.QueryJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class QueryObjectsRequestMarshaller
implements Marshaller<Request<QueryObjectsRequest>, QueryObjectsRequest> {
    public Request<QueryObjectsRequest> marshall(QueryObjectsRequest queryObjectsRequest) {
        if (queryObjectsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)queryObjectsRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.QueryObjects");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (queryObjectsRequest.getPipelineId() != null) {
                jsonGenerator.writeFieldName("pipelineId").writeValue(queryObjectsRequest.getPipelineId());
            }
            if (queryObjectsRequest.getQuery() != null) {
                jsonGenerator.writeFieldName("query");
                QueryJsonMarshaller.getInstance().marshall(queryObjectsRequest.getQuery(), jsonGenerator);
            }
            if (queryObjectsRequest.getSphere() != null) {
                jsonGenerator.writeFieldName("sphere").writeValue(queryObjectsRequest.getSphere());
            }
            if (queryObjectsRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("marker").writeValue(queryObjectsRequest.getMarker());
            }
            if (queryObjectsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("limit").writeValue(queryObjectsRequest.getLimit().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

