/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.ParameterObject;
import com.amazonaws.services.datapipeline.model.ParameterValue;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ValidatePipelineDefinitionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String pipelineId;
    private SdkInternalList<PipelineObject> pipelineObjects;
    private SdkInternalList<ParameterObject> parameterObjects;
    private SdkInternalList<ParameterValue> parameterValues;

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public ValidatePipelineDefinitionRequest withPipelineId(String pipelineId) {
        this.setPipelineId(pipelineId);
        return this;
    }

    public List<PipelineObject> getPipelineObjects() {
        if (this.pipelineObjects == null) {
            this.pipelineObjects = new SdkInternalList();
        }
        return this.pipelineObjects;
    }

    public void setPipelineObjects(Collection<PipelineObject> pipelineObjects) {
        if (pipelineObjects == null) {
            this.pipelineObjects = null;
            return;
        }
        this.pipelineObjects = new SdkInternalList(pipelineObjects);
    }

    public ValidatePipelineDefinitionRequest withPipelineObjects(PipelineObject ... pipelineObjects) {
        if (this.pipelineObjects == null) {
            this.setPipelineObjects((Collection<PipelineObject>)new SdkInternalList(pipelineObjects.length));
        }
        for (PipelineObject ele : pipelineObjects) {
            this.pipelineObjects.add((Object)ele);
        }
        return this;
    }

    public ValidatePipelineDefinitionRequest withPipelineObjects(Collection<PipelineObject> pipelineObjects) {
        this.setPipelineObjects(pipelineObjects);
        return this;
    }

    public List<ParameterObject> getParameterObjects() {
        if (this.parameterObjects == null) {
            this.parameterObjects = new SdkInternalList();
        }
        return this.parameterObjects;
    }

    public void setParameterObjects(Collection<ParameterObject> parameterObjects) {
        if (parameterObjects == null) {
            this.parameterObjects = null;
            return;
        }
        this.parameterObjects = new SdkInternalList(parameterObjects);
    }

    public ValidatePipelineDefinitionRequest withParameterObjects(ParameterObject ... parameterObjects) {
        if (this.parameterObjects == null) {
            this.setParameterObjects((Collection<ParameterObject>)new SdkInternalList(parameterObjects.length));
        }
        for (ParameterObject ele : parameterObjects) {
            this.parameterObjects.add((Object)ele);
        }
        return this;
    }

    public ValidatePipelineDefinitionRequest withParameterObjects(Collection<ParameterObject> parameterObjects) {
        this.setParameterObjects(parameterObjects);
        return this;
    }

    public List<ParameterValue> getParameterValues() {
        if (this.parameterValues == null) {
            this.parameterValues = new SdkInternalList();
        }
        return this.parameterValues;
    }

    public void setParameterValues(Collection<ParameterValue> parameterValues) {
        if (parameterValues == null) {
            this.parameterValues = null;
            return;
        }
        this.parameterValues = new SdkInternalList(parameterValues);
    }

    public ValidatePipelineDefinitionRequest withParameterValues(ParameterValue ... parameterValues) {
        if (this.parameterValues == null) {
            this.setParameterValues((Collection<ParameterValue>)new SdkInternalList(parameterValues.length));
        }
        for (ParameterValue ele : parameterValues) {
            this.parameterValues.add((Object)ele);
        }
        return this;
    }

    public ValidatePipelineDefinitionRequest withParameterValues(Collection<ParameterValue> parameterValues) {
        this.setParameterValues(parameterValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: " + this.getPipelineId() + ",");
        }
        if (this.getPipelineObjects() != null) {
            sb.append("PipelineObjects: " + this.getPipelineObjects() + ",");
        }
        if (this.getParameterObjects() != null) {
            sb.append("ParameterObjects: " + this.getParameterObjects() + ",");
        }
        if (this.getParameterValues() != null) {
            sb.append("ParameterValues: " + this.getParameterValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatePipelineDefinitionRequest)) {
            return false;
        }
        ValidatePipelineDefinitionRequest other = (ValidatePipelineDefinitionRequest)obj;
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getPipelineObjects() == null ^ this.getPipelineObjects() == null) {
            return false;
        }
        if (other.getPipelineObjects() != null && !other.getPipelineObjects().equals(this.getPipelineObjects())) {
            return false;
        }
        if (other.getParameterObjects() == null ^ this.getParameterObjects() == null) {
            return false;
        }
        if (other.getParameterObjects() != null && !other.getParameterObjects().equals(this.getParameterObjects())) {
            return false;
        }
        if (other.getParameterValues() == null ^ this.getParameterValues() == null) {
            return false;
        }
        return other.getParameterValues() == null || other.getParameterValues().equals(this.getParameterValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineObjects() == null ? 0 : this.getPipelineObjects().hashCode());
        hashCode = 31 * hashCode + (this.getParameterObjects() == null ? 0 : this.getParameterObjects().hashCode());
        hashCode = 31 * hashCode + (this.getParameterValues() == null ? 0 : this.getParameterValues().hashCode());
        return hashCode;
    }

    public ValidatePipelineDefinitionRequest clone() {
        return (ValidatePipelineDefinitionRequest)super.clone();
    }
}

