/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.PipelineIdName;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListPipelinesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<PipelineIdName> pipelineIdList;
    private String marker;
    private Boolean hasMoreResults;

    public List<PipelineIdName> getPipelineIdList() {
        if (this.pipelineIdList == null) {
            this.pipelineIdList = new SdkInternalList();
        }
        return this.pipelineIdList;
    }

    public void setPipelineIdList(Collection<PipelineIdName> pipelineIdList) {
        if (pipelineIdList == null) {
            this.pipelineIdList = null;
            return;
        }
        this.pipelineIdList = new SdkInternalList(pipelineIdList);
    }

    public ListPipelinesResult withPipelineIdList(PipelineIdName ... pipelineIdList) {
        if (this.pipelineIdList == null) {
            this.setPipelineIdList((Collection<PipelineIdName>)new SdkInternalList(pipelineIdList.length));
        }
        for (PipelineIdName ele : pipelineIdList) {
            this.pipelineIdList.add((Object)ele);
        }
        return this;
    }

    public ListPipelinesResult withPipelineIdList(Collection<PipelineIdName> pipelineIdList) {
        this.setPipelineIdList(pipelineIdList);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListPipelinesResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public void setHasMoreResults(Boolean hasMoreResults) {
        this.hasMoreResults = hasMoreResults;
    }

    public Boolean getHasMoreResults() {
        return this.hasMoreResults;
    }

    public ListPipelinesResult withHasMoreResults(Boolean hasMoreResults) {
        this.setHasMoreResults(hasMoreResults);
        return this;
    }

    public Boolean isHasMoreResults() {
        return this.hasMoreResults;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineIdList() != null) {
            sb.append("PipelineIdList: " + this.getPipelineIdList() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getHasMoreResults() != null) {
            sb.append("HasMoreResults: " + this.getHasMoreResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelinesResult)) {
            return false;
        }
        ListPipelinesResult other = (ListPipelinesResult)obj;
        if (other.getPipelineIdList() == null ^ this.getPipelineIdList() == null) {
            return false;
        }
        if (other.getPipelineIdList() != null && !other.getPipelineIdList().equals(this.getPipelineIdList())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getHasMoreResults() == null ^ this.getHasMoreResults() == null) {
            return false;
        }
        return other.getHasMoreResults() == null || other.getHasMoreResults().equals(this.getHasMoreResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineIdList() == null ? 0 : this.getPipelineIdList().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getHasMoreResults() == null ? 0 : this.getHasMoreResults().hashCode());
        return hashCode;
    }

    public ListPipelinesResult clone() {
        try {
            return (ListPipelinesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

