/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetPipelineDefinitionRequestMarshaller
implements Marshaller<Request<GetPipelineDefinitionRequest>, GetPipelineDefinitionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetPipelineDefinitionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetPipelineDefinitionRequest> marshall(GetPipelineDefinitionRequest getPipelineDefinitionRequest) {
        if (getPipelineDefinitionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getPipelineDefinitionRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.GetPipelineDefinition");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getPipelineDefinitionRequest.getPipelineId() != null) {
                jsonGenerator.writeFieldName("pipelineId").writeValue(getPipelineDefinitionRequest.getPipelineId());
            }
            if (getPipelineDefinitionRequest.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(getPipelineDefinitionRequest.getVersion());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

