/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.RemoveTagsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RemoveTagsRequestMarshaller
implements Marshaller<Request<RemoveTagsRequest>, RemoveTagsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RemoveTagsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RemoveTagsRequest> marshall(RemoveTagsRequest removeTagsRequest) {
        if (removeTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removeTagsRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.RemoveTags");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tagKeysList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (removeTagsRequest.getPipelineId() != null) {
                jsonGenerator.writeFieldName("pipelineId").writeValue(removeTagsRequest.getPipelineId());
            }
            if (!(tagKeysList = (SdkInternalList)removeTagsRequest.getTagKeys()).isEmpty() || !tagKeysList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("tagKeys");
                jsonGenerator.writeStartArray();
                for (String tagKeysListValue : tagKeysList) {
                    if (tagKeysListValue == null) continue;
                    jsonGenerator.writeValue(tagKeysListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

