/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.ParameterObject;
import com.amazonaws.services.datapipeline.model.ParameterValue;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.transform.ParameterObjectJsonMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ParameterValueJsonMarshaller;
import com.amazonaws.services.datapipeline.model.transform.PipelineObjectJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutPipelineDefinitionRequestMarshaller
implements Marshaller<Request<PutPipelineDefinitionRequest>, PutPipelineDefinitionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutPipelineDefinitionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutPipelineDefinitionRequest> marshall(PutPipelineDefinitionRequest putPipelineDefinitionRequest) {
        if (putPipelineDefinitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putPipelineDefinitionRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.PutPipelineDefinition");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList parameterValuesList;
            SdkInternalList parameterObjectsList;
            SdkInternalList pipelineObjectsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putPipelineDefinitionRequest.getPipelineId() != null) {
                jsonGenerator.writeFieldName("pipelineId").writeValue(putPipelineDefinitionRequest.getPipelineId());
            }
            if (!(pipelineObjectsList = (SdkInternalList)putPipelineDefinitionRequest.getPipelineObjects()).isEmpty() || !pipelineObjectsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("pipelineObjects");
                jsonGenerator.writeStartArray();
                for (PipelineObject pipelineObjectsListValue : pipelineObjectsList) {
                    if (pipelineObjectsListValue == null) continue;
                    PipelineObjectJsonMarshaller.getInstance().marshall(pipelineObjectsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(parameterObjectsList = (SdkInternalList)putPipelineDefinitionRequest.getParameterObjects()).isEmpty() || !parameterObjectsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("parameterObjects");
                jsonGenerator.writeStartArray();
                for (ParameterObject parameterObjectsListValue : parameterObjectsList) {
                    if (parameterObjectsListValue == null) continue;
                    ParameterObjectJsonMarshaller.getInstance().marshall(parameterObjectsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(parameterValuesList = (SdkInternalList)putPipelineDefinitionRequest.getParameterValues()).isEmpty() || !parameterValuesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("parameterValues");
                jsonGenerator.writeStartArray();
                for (ParameterValue parameterValuesListValue : parameterValuesList) {
                    if (parameterValuesListValue == null) continue;
                    ParameterValueJsonMarshaller.getInstance().marshall(parameterValuesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

