/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.Selector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Query
implements Serializable {
    private ListWithAutoConstructFlag<Selector> selectors;

    public List<Selector> getSelectors() {
        if (this.selectors == null) {
            this.selectors = new ListWithAutoConstructFlag();
            this.selectors.setAutoConstruct(true);
        }
        return this.selectors;
    }

    public void setSelectors(Collection<Selector> selectors) {
        if (selectors == null) {
            this.selectors = null;
            return;
        }
        ListWithAutoConstructFlag selectorsCopy = new ListWithAutoConstructFlag(selectors.size());
        selectorsCopy.addAll(selectors);
        this.selectors = selectorsCopy;
    }

    public Query withSelectors(Selector ... selectors) {
        if (this.getSelectors() == null) {
            this.setSelectors(new ArrayList<Selector>(selectors.length));
        }
        for (Selector value : selectors) {
            this.getSelectors().add(value);
        }
        return this;
    }

    public Query withSelectors(Collection<Selector> selectors) {
        if (selectors == null) {
            this.selectors = null;
        } else {
            ListWithAutoConstructFlag selectorsCopy = new ListWithAutoConstructFlag(selectors.size());
            selectorsCopy.addAll(selectors);
            this.selectors = selectorsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSelectors() != null) {
            sb.append("Selectors: " + this.getSelectors());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSelectors() == null ? 0 : this.getSelectors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query other = (Query)obj;
        if (other.getSelectors() == null ^ this.getSelectors() == null) {
            return false;
        }
        return other.getSelectors() == null || other.getSelectors().equals(this.getSelectors());
    }
}

