/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.Field;
import com.amazonaws.services.datapipeline.model.ParameterAttribute;
import com.amazonaws.services.datapipeline.model.ParameterObject;
import com.amazonaws.services.datapipeline.model.ParameterValue;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class PutPipelineDefinitionRequestMarshaller
implements Marshaller<Request<PutPipelineDefinitionRequest>, PutPipelineDefinitionRequest> {
    public Request<PutPipelineDefinitionRequest> marshall(PutPipelineDefinitionRequest putPipelineDefinitionRequest) {
        if (putPipelineDefinitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putPipelineDefinitionRequest, "DataPipeline");
        String target = "DataPipeline.PutPipelineDefinition";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag parameterValuesList;
            ListWithAutoConstructFlag parameterObjectsList;
            ListWithAutoConstructFlag pipelineObjectsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (putPipelineDefinitionRequest.getPipelineId() != null) {
                jsonWriter.key("pipelineId").value((Object)putPipelineDefinitionRequest.getPipelineId());
            }
            if (!((pipelineObjectsList = (ListWithAutoConstructFlag)putPipelineDefinitionRequest.getPipelineObjects()) == null || pipelineObjectsList.isAutoConstruct() && pipelineObjectsList.isEmpty())) {
                jsonWriter.key("pipelineObjects");
                jsonWriter.array();
                for (PipelineObject pipelineObjectsListValue : pipelineObjectsList) {
                    ListWithAutoConstructFlag fieldsList;
                    if (pipelineObjectsListValue == null) continue;
                    jsonWriter.object();
                    if (pipelineObjectsListValue.getId() != null) {
                        jsonWriter.key("id").value((Object)pipelineObjectsListValue.getId());
                    }
                    if (pipelineObjectsListValue.getName() != null) {
                        jsonWriter.key("name").value((Object)pipelineObjectsListValue.getName());
                    }
                    if (!((fieldsList = (ListWithAutoConstructFlag)pipelineObjectsListValue.getFields()) == null || fieldsList.isAutoConstruct() && fieldsList.isEmpty())) {
                        jsonWriter.key("fields");
                        jsonWriter.array();
                        for (Field fieldsListValue : fieldsList) {
                            if (fieldsListValue == null) continue;
                            jsonWriter.object();
                            if (fieldsListValue.getKey() != null) {
                                jsonWriter.key("key").value((Object)fieldsListValue.getKey());
                            }
                            if (fieldsListValue.getStringValue() != null) {
                                jsonWriter.key("stringValue").value((Object)fieldsListValue.getStringValue());
                            }
                            if (fieldsListValue.getRefValue() != null) {
                                jsonWriter.key("refValue").value((Object)fieldsListValue.getRefValue());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((parameterObjectsList = (ListWithAutoConstructFlag)putPipelineDefinitionRequest.getParameterObjects()) == null || parameterObjectsList.isAutoConstruct() && parameterObjectsList.isEmpty())) {
                jsonWriter.key("parameterObjects");
                jsonWriter.array();
                for (ParameterObject parameterObjectsListValue : parameterObjectsList) {
                    ListWithAutoConstructFlag attributesList;
                    if (parameterObjectsListValue == null) continue;
                    jsonWriter.object();
                    if (parameterObjectsListValue.getId() != null) {
                        jsonWriter.key("id").value((Object)parameterObjectsListValue.getId());
                    }
                    if (!((attributesList = (ListWithAutoConstructFlag)parameterObjectsListValue.getAttributes()) == null || attributesList.isAutoConstruct() && attributesList.isEmpty())) {
                        jsonWriter.key("attributes");
                        jsonWriter.array();
                        for (ParameterAttribute attributesListValue : attributesList) {
                            if (attributesListValue == null) continue;
                            jsonWriter.object();
                            if (attributesListValue.getKey() != null) {
                                jsonWriter.key("key").value((Object)attributesListValue.getKey());
                            }
                            if (attributesListValue.getStringValue() != null) {
                                jsonWriter.key("stringValue").value((Object)attributesListValue.getStringValue());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((parameterValuesList = (ListWithAutoConstructFlag)putPipelineDefinitionRequest.getParameterValues()) == null || parameterValuesList.isAutoConstruct() && parameterValuesList.isEmpty())) {
                jsonWriter.key("parameterValues");
                jsonWriter.array();
                for (ParameterValue parameterValuesListValue : parameterValuesList) {
                    if (parameterValuesListValue == null) continue;
                    jsonWriter.object();
                    if (parameterValuesListValue.getId() != null) {
                        jsonWriter.key("id").value((Object)parameterValuesListValue.getId());
                    }
                    if (parameterValuesListValue.getStringValue() != null) {
                        jsonWriter.key("stringValue").value((Object)parameterValuesListValue.getStringValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

