/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.datasync.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The platform-related details about the DataSync agent, such as the version number.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/Platform" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Platform implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The version of the DataSync agent.
     * </p>
     * <important>
     * <p>
     * Beginning December 7, 2023, we will discontinue version 1 DataSync agents. Check the DataSync console to see if
     * you have affected agents. If you do, <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/replacing-agent.html">replace</a> those agents before
     * then to avoid data transfer or storage discovery disruptions. If you need more help, contact <a
     * href="https://aws.amazon.com/contact-us/">Amazon Web Services Support</a>.
     * </p>
     * </important>
     */
    private String version;

    /**
     * <p>
     * The version of the DataSync agent.
     * </p>
     * <important>
     * <p>
     * Beginning December 7, 2023, we will discontinue version 1 DataSync agents. Check the DataSync console to see if
     * you have affected agents. If you do, <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/replacing-agent.html">replace</a> those agents before
     * then to avoid data transfer or storage discovery disruptions. If you need more help, contact <a
     * href="https://aws.amazon.com/contact-us/">Amazon Web Services Support</a>.
     * </p>
     * </important>
     * 
     * @param version
     *        The version of the DataSync agent.</p> <important>
     *        <p>
     *        Beginning December 7, 2023, we will discontinue version 1 DataSync agents. Check the DataSync console to
     *        see if you have affected agents. If you do, <a
     *        href="https://docs.aws.amazon.com/datasync/latest/userguide/replacing-agent.html">replace</a> those agents
     *        before then to avoid data transfer or storage discovery disruptions. If you need more help, contact <a
     *        href="https://aws.amazon.com/contact-us/">Amazon Web Services Support</a>.
     *        </p>
     */

    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * <p>
     * The version of the DataSync agent.
     * </p>
     * <important>
     * <p>
     * Beginning December 7, 2023, we will discontinue version 1 DataSync agents. Check the DataSync console to see if
     * you have affected agents. If you do, <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/replacing-agent.html">replace</a> those agents before
     * then to avoid data transfer or storage discovery disruptions. If you need more help, contact <a
     * href="https://aws.amazon.com/contact-us/">Amazon Web Services Support</a>.
     * </p>
     * </important>
     * 
     * @return The version of the DataSync agent.</p> <important>
     *         <p>
     *         Beginning December 7, 2023, we will discontinue version 1 DataSync agents. Check the DataSync console to
     *         see if you have affected agents. If you do, <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/replacing-agent.html">replace</a> those
     *         agents before then to avoid data transfer or storage discovery disruptions. If you need more help,
     *         contact <a href="https://aws.amazon.com/contact-us/">Amazon Web Services Support</a>.
     *         </p>
     */

    public String getVersion() {
        return this.version;
    }

    /**
     * <p>
     * The version of the DataSync agent.
     * </p>
     * <important>
     * <p>
     * Beginning December 7, 2023, we will discontinue version 1 DataSync agents. Check the DataSync console to see if
     * you have affected agents. If you do, <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/replacing-agent.html">replace</a> those agents before
     * then to avoid data transfer or storage discovery disruptions. If you need more help, contact <a
     * href="https://aws.amazon.com/contact-us/">Amazon Web Services Support</a>.
     * </p>
     * </important>
     * 
     * @param version
     *        The version of the DataSync agent.</p> <important>
     *        <p>
     *        Beginning December 7, 2023, we will discontinue version 1 DataSync agents. Check the DataSync console to
     *        see if you have affected agents. If you do, <a
     *        href="https://docs.aws.amazon.com/datasync/latest/userguide/replacing-agent.html">replace</a> those agents
     *        before then to avoid data transfer or storage discovery disruptions. If you need more help, contact <a
     *        href="https://aws.amazon.com/contact-us/">Amazon Web Services Support</a>.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Platform withVersion(String version) {
        setVersion(version);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getVersion() != null)
            sb.append("Version: ").append(getVersion());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Platform == false)
            return false;
        Platform other = (Platform) obj;
        if (other.getVersion() == null ^ this.getVersion() == null)
            return false;
        if (other.getVersion() != null && other.getVersion().equals(this.getVersion()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getVersion() == null) ? 0 : getVersion().hashCode());
        return hashCode;
    }

    @Override
    public Platform clone() {
        try {
            return (Platform) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.datasync.model.transform.PlatformMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
