/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datazone.model.EnvironmentParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateEnvironmentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String description;
    private String domainIdentifier;
    private String environmentProfileIdentifier;
    private List<String> glossaryTerms;
    private String name;
    private String projectIdentifier;
    private List<EnvironmentParameter> userParameters;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateEnvironmentRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDomainIdentifier(String domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    public String getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public CreateEnvironmentRequest withDomainIdentifier(String domainIdentifier) {
        this.setDomainIdentifier(domainIdentifier);
        return this;
    }

    public void setEnvironmentProfileIdentifier(String environmentProfileIdentifier) {
        this.environmentProfileIdentifier = environmentProfileIdentifier;
    }

    public String getEnvironmentProfileIdentifier() {
        return this.environmentProfileIdentifier;
    }

    public CreateEnvironmentRequest withEnvironmentProfileIdentifier(String environmentProfileIdentifier) {
        this.setEnvironmentProfileIdentifier(environmentProfileIdentifier);
        return this;
    }

    public List<String> getGlossaryTerms() {
        return this.glossaryTerms;
    }

    public void setGlossaryTerms(Collection<String> glossaryTerms) {
        if (glossaryTerms == null) {
            this.glossaryTerms = null;
            return;
        }
        this.glossaryTerms = new ArrayList<String>(glossaryTerms);
    }

    public CreateEnvironmentRequest withGlossaryTerms(String ... glossaryTerms) {
        if (this.glossaryTerms == null) {
            this.setGlossaryTerms(new ArrayList<String>(glossaryTerms.length));
        }
        for (String ele : glossaryTerms) {
            this.glossaryTerms.add(ele);
        }
        return this;
    }

    public CreateEnvironmentRequest withGlossaryTerms(Collection<String> glossaryTerms) {
        this.setGlossaryTerms(glossaryTerms);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateEnvironmentRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setProjectIdentifier(String projectIdentifier) {
        this.projectIdentifier = projectIdentifier;
    }

    public String getProjectIdentifier() {
        return this.projectIdentifier;
    }

    public CreateEnvironmentRequest withProjectIdentifier(String projectIdentifier) {
        this.setProjectIdentifier(projectIdentifier);
        return this;
    }

    public List<EnvironmentParameter> getUserParameters() {
        return this.userParameters;
    }

    public void setUserParameters(Collection<EnvironmentParameter> userParameters) {
        if (userParameters == null) {
            this.userParameters = null;
            return;
        }
        this.userParameters = new ArrayList<EnvironmentParameter>(userParameters);
    }

    public CreateEnvironmentRequest withUserParameters(EnvironmentParameter ... userParameters) {
        if (this.userParameters == null) {
            this.setUserParameters(new ArrayList<EnvironmentParameter>(userParameters.length));
        }
        for (EnvironmentParameter ele : userParameters) {
            this.userParameters.add(ele);
        }
        return this;
    }

    public CreateEnvironmentRequest withUserParameters(Collection<EnvironmentParameter> userParameters) {
        this.setUserParameters(userParameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDomainIdentifier() != null) {
            sb.append("DomainIdentifier: ").append(this.getDomainIdentifier()).append(",");
        }
        if (this.getEnvironmentProfileIdentifier() != null) {
            sb.append("EnvironmentProfileIdentifier: ").append(this.getEnvironmentProfileIdentifier()).append(",");
        }
        if (this.getGlossaryTerms() != null) {
            sb.append("GlossaryTerms: ").append(this.getGlossaryTerms()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getProjectIdentifier() != null) {
            sb.append("ProjectIdentifier: ").append(this.getProjectIdentifier()).append(",");
        }
        if (this.getUserParameters() != null) {
            sb.append("UserParameters: ").append(this.getUserParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDomainIdentifier() == null ^ this.getDomainIdentifier() == null) {
            return false;
        }
        if (other.getDomainIdentifier() != null && !other.getDomainIdentifier().equals(this.getDomainIdentifier())) {
            return false;
        }
        if (other.getEnvironmentProfileIdentifier() == null ^ this.getEnvironmentProfileIdentifier() == null) {
            return false;
        }
        if (other.getEnvironmentProfileIdentifier() != null && !other.getEnvironmentProfileIdentifier().equals(this.getEnvironmentProfileIdentifier())) {
            return false;
        }
        if (other.getGlossaryTerms() == null ^ this.getGlossaryTerms() == null) {
            return false;
        }
        if (other.getGlossaryTerms() != null && !other.getGlossaryTerms().equals(this.getGlossaryTerms())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getProjectIdentifier() == null ^ this.getProjectIdentifier() == null) {
            return false;
        }
        if (other.getProjectIdentifier() != null && !other.getProjectIdentifier().equals(this.getProjectIdentifier())) {
            return false;
        }
        if (other.getUserParameters() == null ^ this.getUserParameters() == null) {
            return false;
        }
        return other.getUserParameters() == null || other.getUserParameters().equals(this.getUserParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDomainIdentifier() == null ? 0 : this.getDomainIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentProfileIdentifier() == null ? 0 : this.getEnvironmentProfileIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getGlossaryTerms() == null ? 0 : this.getGlossaryTerms().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getProjectIdentifier() == null ? 0 : this.getProjectIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getUserParameters() == null ? 0 : this.getUserParameters().hashCode());
        return hashCode;
    }

    public CreateEnvironmentRequest clone() {
        return (CreateEnvironmentRequest)super.clone();
    }
}

