/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datazone.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.datazone.model.AssetListing;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class AssetListingMarshaller {
    private static final MarshallingInfo<String> ASSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("assetId").build();
    private static final MarshallingInfo<String> ASSETREVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("assetRevision").build();
    private static final MarshallingInfo<String> ASSETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("assetType").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> FORMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("forms").build();
    private static final MarshallingInfo<List> GLOSSARYTERMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("glossaryTerms").build();
    private static final MarshallingInfo<String> OWNINGPROJECTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("owningProjectId").build();
    private static final AssetListingMarshaller instance = new AssetListingMarshaller();

    public static AssetListingMarshaller getInstance() {
        return instance;
    }

    public void marshall(AssetListing assetListing, ProtocolMarshaller protocolMarshaller) {
        if (assetListing == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)assetListing.getAssetId(), ASSETID_BINDING);
            protocolMarshaller.marshall((Object)assetListing.getAssetRevision(), ASSETREVISION_BINDING);
            protocolMarshaller.marshall((Object)assetListing.getAssetType(), ASSETTYPE_BINDING);
            protocolMarshaller.marshall((Object)assetListing.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)assetListing.getForms(), FORMS_BINDING);
            protocolMarshaller.marshall(assetListing.getGlossaryTerms(), GLOSSARYTERMS_BINDING);
            protocolMarshaller.marshall((Object)assetListing.getOwningProjectId(), OWNINGPROJECTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

