/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.datazone;

import javax.annotation.Generated;

import com.amazonaws.services.datazone.model.*;

/**
 * Abstract implementation of {@code AmazonDataZoneAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonDataZoneAsync extends AbstractAmazonDataZone implements AmazonDataZoneAsync {

    protected AbstractAmazonDataZoneAsync() {
    }

    @Override
    public java.util.concurrent.Future<AcceptPredictionsResult> acceptPredictionsAsync(AcceptPredictionsRequest request) {

        return acceptPredictionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AcceptPredictionsResult> acceptPredictionsAsync(AcceptPredictionsRequest request,
            com.amazonaws.handlers.AsyncHandler<AcceptPredictionsRequest, AcceptPredictionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AcceptSubscriptionRequestResult> acceptSubscriptionRequestAsync(AcceptSubscriptionRequestRequest request) {

        return acceptSubscriptionRequestAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AcceptSubscriptionRequestResult> acceptSubscriptionRequestAsync(AcceptSubscriptionRequestRequest request,
            com.amazonaws.handlers.AsyncHandler<AcceptSubscriptionRequestRequest, AcceptSubscriptionRequestResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CancelMetadataGenerationRunResult> cancelMetadataGenerationRunAsync(CancelMetadataGenerationRunRequest request) {

        return cancelMetadataGenerationRunAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CancelMetadataGenerationRunResult> cancelMetadataGenerationRunAsync(CancelMetadataGenerationRunRequest request,
            com.amazonaws.handlers.AsyncHandler<CancelMetadataGenerationRunRequest, CancelMetadataGenerationRunResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CancelSubscriptionResult> cancelSubscriptionAsync(CancelSubscriptionRequest request) {

        return cancelSubscriptionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CancelSubscriptionResult> cancelSubscriptionAsync(CancelSubscriptionRequest request,
            com.amazonaws.handlers.AsyncHandler<CancelSubscriptionRequest, CancelSubscriptionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateAssetResult> createAssetAsync(CreateAssetRequest request) {

        return createAssetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAssetResult> createAssetAsync(CreateAssetRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAssetRequest, CreateAssetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateAssetRevisionResult> createAssetRevisionAsync(CreateAssetRevisionRequest request) {

        return createAssetRevisionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAssetRevisionResult> createAssetRevisionAsync(CreateAssetRevisionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAssetRevisionRequest, CreateAssetRevisionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateAssetTypeResult> createAssetTypeAsync(CreateAssetTypeRequest request) {

        return createAssetTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAssetTypeResult> createAssetTypeAsync(CreateAssetTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAssetTypeRequest, CreateAssetTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateDataSourceResult> createDataSourceAsync(CreateDataSourceRequest request) {

        return createDataSourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateDataSourceResult> createDataSourceAsync(CreateDataSourceRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateDataSourceRequest, CreateDataSourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateDomainResult> createDomainAsync(CreateDomainRequest request) {

        return createDomainAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateDomainResult> createDomainAsync(CreateDomainRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateDomainRequest, CreateDomainResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateEnvironmentResult> createEnvironmentAsync(CreateEnvironmentRequest request) {

        return createEnvironmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateEnvironmentResult> createEnvironmentAsync(CreateEnvironmentRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateEnvironmentRequest, CreateEnvironmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateEnvironmentProfileResult> createEnvironmentProfileAsync(CreateEnvironmentProfileRequest request) {

        return createEnvironmentProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateEnvironmentProfileResult> createEnvironmentProfileAsync(CreateEnvironmentProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateEnvironmentProfileRequest, CreateEnvironmentProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateFormTypeResult> createFormTypeAsync(CreateFormTypeRequest request) {

        return createFormTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateFormTypeResult> createFormTypeAsync(CreateFormTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateFormTypeRequest, CreateFormTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateGlossaryResult> createGlossaryAsync(CreateGlossaryRequest request) {

        return createGlossaryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateGlossaryResult> createGlossaryAsync(CreateGlossaryRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateGlossaryRequest, CreateGlossaryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateGlossaryTermResult> createGlossaryTermAsync(CreateGlossaryTermRequest request) {

        return createGlossaryTermAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateGlossaryTermResult> createGlossaryTermAsync(CreateGlossaryTermRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateGlossaryTermRequest, CreateGlossaryTermResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateGroupProfileResult> createGroupProfileAsync(CreateGroupProfileRequest request) {

        return createGroupProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateGroupProfileResult> createGroupProfileAsync(CreateGroupProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateGroupProfileRequest, CreateGroupProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateListingChangeSetResult> createListingChangeSetAsync(CreateListingChangeSetRequest request) {

        return createListingChangeSetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateListingChangeSetResult> createListingChangeSetAsync(CreateListingChangeSetRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateListingChangeSetRequest, CreateListingChangeSetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request) {

        return createProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateProjectRequest, CreateProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateProjectMembershipResult> createProjectMembershipAsync(CreateProjectMembershipRequest request) {

        return createProjectMembershipAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateProjectMembershipResult> createProjectMembershipAsync(CreateProjectMembershipRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateProjectMembershipRequest, CreateProjectMembershipResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSubscriptionGrantResult> createSubscriptionGrantAsync(CreateSubscriptionGrantRequest request) {

        return createSubscriptionGrantAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSubscriptionGrantResult> createSubscriptionGrantAsync(CreateSubscriptionGrantRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSubscriptionGrantRequest, CreateSubscriptionGrantResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSubscriptionRequestResult> createSubscriptionRequestAsync(CreateSubscriptionRequestRequest request) {

        return createSubscriptionRequestAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSubscriptionRequestResult> createSubscriptionRequestAsync(CreateSubscriptionRequestRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSubscriptionRequestRequest, CreateSubscriptionRequestResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSubscriptionTargetResult> createSubscriptionTargetAsync(CreateSubscriptionTargetRequest request) {

        return createSubscriptionTargetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSubscriptionTargetResult> createSubscriptionTargetAsync(CreateSubscriptionTargetRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSubscriptionTargetRequest, CreateSubscriptionTargetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateUserProfileResult> createUserProfileAsync(CreateUserProfileRequest request) {

        return createUserProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateUserProfileResult> createUserProfileAsync(CreateUserProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateUserProfileRequest, CreateUserProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAssetResult> deleteAssetAsync(DeleteAssetRequest request) {

        return deleteAssetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAssetResult> deleteAssetAsync(DeleteAssetRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAssetRequest, DeleteAssetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAssetTypeResult> deleteAssetTypeAsync(DeleteAssetTypeRequest request) {

        return deleteAssetTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAssetTypeResult> deleteAssetTypeAsync(DeleteAssetTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAssetTypeRequest, DeleteAssetTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteDataSourceResult> deleteDataSourceAsync(DeleteDataSourceRequest request) {

        return deleteDataSourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteDataSourceResult> deleteDataSourceAsync(DeleteDataSourceRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteDataSourceRequest, DeleteDataSourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteDomainResult> deleteDomainAsync(DeleteDomainRequest request) {

        return deleteDomainAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteDomainResult> deleteDomainAsync(DeleteDomainRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteDomainRequest, DeleteDomainResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteEnvironmentResult> deleteEnvironmentAsync(DeleteEnvironmentRequest request) {

        return deleteEnvironmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteEnvironmentResult> deleteEnvironmentAsync(DeleteEnvironmentRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteEnvironmentRequest, DeleteEnvironmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteEnvironmentBlueprintConfigurationResult> deleteEnvironmentBlueprintConfigurationAsync(
            DeleteEnvironmentBlueprintConfigurationRequest request) {

        return deleteEnvironmentBlueprintConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteEnvironmentBlueprintConfigurationResult> deleteEnvironmentBlueprintConfigurationAsync(
            DeleteEnvironmentBlueprintConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteEnvironmentBlueprintConfigurationRequest, DeleteEnvironmentBlueprintConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteEnvironmentProfileResult> deleteEnvironmentProfileAsync(DeleteEnvironmentProfileRequest request) {

        return deleteEnvironmentProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteEnvironmentProfileResult> deleteEnvironmentProfileAsync(DeleteEnvironmentProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteEnvironmentProfileRequest, DeleteEnvironmentProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteFormTypeResult> deleteFormTypeAsync(DeleteFormTypeRequest request) {

        return deleteFormTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteFormTypeResult> deleteFormTypeAsync(DeleteFormTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteFormTypeRequest, DeleteFormTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteGlossaryResult> deleteGlossaryAsync(DeleteGlossaryRequest request) {

        return deleteGlossaryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteGlossaryResult> deleteGlossaryAsync(DeleteGlossaryRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteGlossaryRequest, DeleteGlossaryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteGlossaryTermResult> deleteGlossaryTermAsync(DeleteGlossaryTermRequest request) {

        return deleteGlossaryTermAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteGlossaryTermResult> deleteGlossaryTermAsync(DeleteGlossaryTermRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteGlossaryTermRequest, DeleteGlossaryTermResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteListingResult> deleteListingAsync(DeleteListingRequest request) {

        return deleteListingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteListingResult> deleteListingAsync(DeleteListingRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteListingRequest, DeleteListingResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request) {

        return deleteProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteProjectRequest, DeleteProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteProjectMembershipResult> deleteProjectMembershipAsync(DeleteProjectMembershipRequest request) {

        return deleteProjectMembershipAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteProjectMembershipResult> deleteProjectMembershipAsync(DeleteProjectMembershipRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteProjectMembershipRequest, DeleteProjectMembershipResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSubscriptionGrantResult> deleteSubscriptionGrantAsync(DeleteSubscriptionGrantRequest request) {

        return deleteSubscriptionGrantAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSubscriptionGrantResult> deleteSubscriptionGrantAsync(DeleteSubscriptionGrantRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSubscriptionGrantRequest, DeleteSubscriptionGrantResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSubscriptionRequestResult> deleteSubscriptionRequestAsync(DeleteSubscriptionRequestRequest request) {

        return deleteSubscriptionRequestAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSubscriptionRequestResult> deleteSubscriptionRequestAsync(DeleteSubscriptionRequestRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSubscriptionRequestRequest, DeleteSubscriptionRequestResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSubscriptionTargetResult> deleteSubscriptionTargetAsync(DeleteSubscriptionTargetRequest request) {

        return deleteSubscriptionTargetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSubscriptionTargetResult> deleteSubscriptionTargetAsync(DeleteSubscriptionTargetRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSubscriptionTargetRequest, DeleteSubscriptionTargetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAssetResult> getAssetAsync(GetAssetRequest request) {

        return getAssetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAssetResult> getAssetAsync(GetAssetRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAssetRequest, GetAssetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAssetTypeResult> getAssetTypeAsync(GetAssetTypeRequest request) {

        return getAssetTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAssetTypeResult> getAssetTypeAsync(GetAssetTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAssetTypeRequest, GetAssetTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDataSourceResult> getDataSourceAsync(GetDataSourceRequest request) {

        return getDataSourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDataSourceResult> getDataSourceAsync(GetDataSourceRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDataSourceRequest, GetDataSourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDataSourceRunResult> getDataSourceRunAsync(GetDataSourceRunRequest request) {

        return getDataSourceRunAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDataSourceRunResult> getDataSourceRunAsync(GetDataSourceRunRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDataSourceRunRequest, GetDataSourceRunResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDomainResult> getDomainAsync(GetDomainRequest request) {

        return getDomainAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDomainResult> getDomainAsync(GetDomainRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDomainRequest, GetDomainResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetEnvironmentResult> getEnvironmentAsync(GetEnvironmentRequest request) {

        return getEnvironmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetEnvironmentResult> getEnvironmentAsync(GetEnvironmentRequest request,
            com.amazonaws.handlers.AsyncHandler<GetEnvironmentRequest, GetEnvironmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetEnvironmentBlueprintResult> getEnvironmentBlueprintAsync(GetEnvironmentBlueprintRequest request) {

        return getEnvironmentBlueprintAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetEnvironmentBlueprintResult> getEnvironmentBlueprintAsync(GetEnvironmentBlueprintRequest request,
            com.amazonaws.handlers.AsyncHandler<GetEnvironmentBlueprintRequest, GetEnvironmentBlueprintResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetEnvironmentBlueprintConfigurationResult> getEnvironmentBlueprintConfigurationAsync(
            GetEnvironmentBlueprintConfigurationRequest request) {

        return getEnvironmentBlueprintConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetEnvironmentBlueprintConfigurationResult> getEnvironmentBlueprintConfigurationAsync(
            GetEnvironmentBlueprintConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetEnvironmentBlueprintConfigurationRequest, GetEnvironmentBlueprintConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetEnvironmentProfileResult> getEnvironmentProfileAsync(GetEnvironmentProfileRequest request) {

        return getEnvironmentProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetEnvironmentProfileResult> getEnvironmentProfileAsync(GetEnvironmentProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<GetEnvironmentProfileRequest, GetEnvironmentProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetFormTypeResult> getFormTypeAsync(GetFormTypeRequest request) {

        return getFormTypeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetFormTypeResult> getFormTypeAsync(GetFormTypeRequest request,
            com.amazonaws.handlers.AsyncHandler<GetFormTypeRequest, GetFormTypeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetGlossaryResult> getGlossaryAsync(GetGlossaryRequest request) {

        return getGlossaryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetGlossaryResult> getGlossaryAsync(GetGlossaryRequest request,
            com.amazonaws.handlers.AsyncHandler<GetGlossaryRequest, GetGlossaryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetGlossaryTermResult> getGlossaryTermAsync(GetGlossaryTermRequest request) {

        return getGlossaryTermAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetGlossaryTermResult> getGlossaryTermAsync(GetGlossaryTermRequest request,
            com.amazonaws.handlers.AsyncHandler<GetGlossaryTermRequest, GetGlossaryTermResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetGroupProfileResult> getGroupProfileAsync(GetGroupProfileRequest request) {

        return getGroupProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetGroupProfileResult> getGroupProfileAsync(GetGroupProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<GetGroupProfileRequest, GetGroupProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetIamPortalLoginUrlResult> getIamPortalLoginUrlAsync(GetIamPortalLoginUrlRequest request) {

        return getIamPortalLoginUrlAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetIamPortalLoginUrlResult> getIamPortalLoginUrlAsync(GetIamPortalLoginUrlRequest request,
            com.amazonaws.handlers.AsyncHandler<GetIamPortalLoginUrlRequest, GetIamPortalLoginUrlResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetListingResult> getListingAsync(GetListingRequest request) {

        return getListingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetListingResult> getListingAsync(GetListingRequest request,
            com.amazonaws.handlers.AsyncHandler<GetListingRequest, GetListingResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetMetadataGenerationRunResult> getMetadataGenerationRunAsync(GetMetadataGenerationRunRequest request) {

        return getMetadataGenerationRunAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMetadataGenerationRunResult> getMetadataGenerationRunAsync(GetMetadataGenerationRunRequest request,
            com.amazonaws.handlers.AsyncHandler<GetMetadataGenerationRunRequest, GetMetadataGenerationRunResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetProjectResult> getProjectAsync(GetProjectRequest request) {

        return getProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetProjectResult> getProjectAsync(GetProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<GetProjectRequest, GetProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSubscriptionResult> getSubscriptionAsync(GetSubscriptionRequest request) {

        return getSubscriptionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSubscriptionResult> getSubscriptionAsync(GetSubscriptionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSubscriptionRequest, GetSubscriptionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSubscriptionGrantResult> getSubscriptionGrantAsync(GetSubscriptionGrantRequest request) {

        return getSubscriptionGrantAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSubscriptionGrantResult> getSubscriptionGrantAsync(GetSubscriptionGrantRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSubscriptionGrantRequest, GetSubscriptionGrantResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSubscriptionRequestDetailsResult> getSubscriptionRequestDetailsAsync(GetSubscriptionRequestDetailsRequest request) {

        return getSubscriptionRequestDetailsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSubscriptionRequestDetailsResult> getSubscriptionRequestDetailsAsync(GetSubscriptionRequestDetailsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSubscriptionRequestDetailsRequest, GetSubscriptionRequestDetailsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSubscriptionTargetResult> getSubscriptionTargetAsync(GetSubscriptionTargetRequest request) {

        return getSubscriptionTargetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSubscriptionTargetResult> getSubscriptionTargetAsync(GetSubscriptionTargetRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSubscriptionTargetRequest, GetSubscriptionTargetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetUserProfileResult> getUserProfileAsync(GetUserProfileRequest request) {

        return getUserProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetUserProfileResult> getUserProfileAsync(GetUserProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<GetUserProfileRequest, GetUserProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAssetRevisionsResult> listAssetRevisionsAsync(ListAssetRevisionsRequest request) {

        return listAssetRevisionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAssetRevisionsResult> listAssetRevisionsAsync(ListAssetRevisionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAssetRevisionsRequest, ListAssetRevisionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDataSourceRunActivitiesResult> listDataSourceRunActivitiesAsync(ListDataSourceRunActivitiesRequest request) {

        return listDataSourceRunActivitiesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDataSourceRunActivitiesResult> listDataSourceRunActivitiesAsync(ListDataSourceRunActivitiesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDataSourceRunActivitiesRequest, ListDataSourceRunActivitiesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDataSourceRunsResult> listDataSourceRunsAsync(ListDataSourceRunsRequest request) {

        return listDataSourceRunsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDataSourceRunsResult> listDataSourceRunsAsync(ListDataSourceRunsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDataSourceRunsRequest, ListDataSourceRunsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDataSourcesResult> listDataSourcesAsync(ListDataSourcesRequest request) {

        return listDataSourcesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDataSourcesResult> listDataSourcesAsync(ListDataSourcesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDataSourcesRequest, ListDataSourcesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDomainsResult> listDomainsAsync(ListDomainsRequest request) {

        return listDomainsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDomainsResult> listDomainsAsync(ListDomainsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDomainsRequest, ListDomainsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListEnvironmentBlueprintConfigurationsResult> listEnvironmentBlueprintConfigurationsAsync(
            ListEnvironmentBlueprintConfigurationsRequest request) {

        return listEnvironmentBlueprintConfigurationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListEnvironmentBlueprintConfigurationsResult> listEnvironmentBlueprintConfigurationsAsync(
            ListEnvironmentBlueprintConfigurationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListEnvironmentBlueprintConfigurationsRequest, ListEnvironmentBlueprintConfigurationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListEnvironmentBlueprintsResult> listEnvironmentBlueprintsAsync(ListEnvironmentBlueprintsRequest request) {

        return listEnvironmentBlueprintsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListEnvironmentBlueprintsResult> listEnvironmentBlueprintsAsync(ListEnvironmentBlueprintsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListEnvironmentBlueprintsRequest, ListEnvironmentBlueprintsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListEnvironmentProfilesResult> listEnvironmentProfilesAsync(ListEnvironmentProfilesRequest request) {

        return listEnvironmentProfilesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListEnvironmentProfilesResult> listEnvironmentProfilesAsync(ListEnvironmentProfilesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListEnvironmentProfilesRequest, ListEnvironmentProfilesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListEnvironmentsResult> listEnvironmentsAsync(ListEnvironmentsRequest request) {

        return listEnvironmentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListEnvironmentsResult> listEnvironmentsAsync(ListEnvironmentsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListEnvironmentsRequest, ListEnvironmentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListMetadataGenerationRunsResult> listMetadataGenerationRunsAsync(ListMetadataGenerationRunsRequest request) {

        return listMetadataGenerationRunsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListMetadataGenerationRunsResult> listMetadataGenerationRunsAsync(ListMetadataGenerationRunsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListMetadataGenerationRunsRequest, ListMetadataGenerationRunsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListNotificationsResult> listNotificationsAsync(ListNotificationsRequest request) {

        return listNotificationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListNotificationsResult> listNotificationsAsync(ListNotificationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListNotificationsRequest, ListNotificationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListProjectMembershipsResult> listProjectMembershipsAsync(ListProjectMembershipsRequest request) {

        return listProjectMembershipsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListProjectMembershipsResult> listProjectMembershipsAsync(ListProjectMembershipsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListProjectMembershipsRequest, ListProjectMembershipsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request) {

        return listProjectsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListProjectsRequest, ListProjectsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSubscriptionGrantsResult> listSubscriptionGrantsAsync(ListSubscriptionGrantsRequest request) {

        return listSubscriptionGrantsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSubscriptionGrantsResult> listSubscriptionGrantsAsync(ListSubscriptionGrantsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSubscriptionGrantsRequest, ListSubscriptionGrantsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSubscriptionRequestsResult> listSubscriptionRequestsAsync(ListSubscriptionRequestsRequest request) {

        return listSubscriptionRequestsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSubscriptionRequestsResult> listSubscriptionRequestsAsync(ListSubscriptionRequestsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSubscriptionRequestsRequest, ListSubscriptionRequestsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSubscriptionTargetsResult> listSubscriptionTargetsAsync(ListSubscriptionTargetsRequest request) {

        return listSubscriptionTargetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSubscriptionTargetsResult> listSubscriptionTargetsAsync(ListSubscriptionTargetsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSubscriptionTargetsRequest, ListSubscriptionTargetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSubscriptionsResult> listSubscriptionsAsync(ListSubscriptionsRequest request) {

        return listSubscriptionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSubscriptionsResult> listSubscriptionsAsync(ListSubscriptionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSubscriptionsRequest, ListSubscriptionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutEnvironmentBlueprintConfigurationResult> putEnvironmentBlueprintConfigurationAsync(
            PutEnvironmentBlueprintConfigurationRequest request) {

        return putEnvironmentBlueprintConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutEnvironmentBlueprintConfigurationResult> putEnvironmentBlueprintConfigurationAsync(
            PutEnvironmentBlueprintConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<PutEnvironmentBlueprintConfigurationRequest, PutEnvironmentBlueprintConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<RejectPredictionsResult> rejectPredictionsAsync(RejectPredictionsRequest request) {

        return rejectPredictionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RejectPredictionsResult> rejectPredictionsAsync(RejectPredictionsRequest request,
            com.amazonaws.handlers.AsyncHandler<RejectPredictionsRequest, RejectPredictionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<RejectSubscriptionRequestResult> rejectSubscriptionRequestAsync(RejectSubscriptionRequestRequest request) {

        return rejectSubscriptionRequestAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RejectSubscriptionRequestResult> rejectSubscriptionRequestAsync(RejectSubscriptionRequestRequest request,
            com.amazonaws.handlers.AsyncHandler<RejectSubscriptionRequestRequest, RejectSubscriptionRequestResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<RevokeSubscriptionResult> revokeSubscriptionAsync(RevokeSubscriptionRequest request) {

        return revokeSubscriptionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RevokeSubscriptionResult> revokeSubscriptionAsync(RevokeSubscriptionRequest request,
            com.amazonaws.handlers.AsyncHandler<RevokeSubscriptionRequest, RevokeSubscriptionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchResult> searchAsync(SearchRequest request) {

        return searchAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchResult> searchAsync(SearchRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchRequest, SearchResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchGroupProfilesResult> searchGroupProfilesAsync(SearchGroupProfilesRequest request) {

        return searchGroupProfilesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchGroupProfilesResult> searchGroupProfilesAsync(SearchGroupProfilesRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchGroupProfilesRequest, SearchGroupProfilesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchListingsResult> searchListingsAsync(SearchListingsRequest request) {

        return searchListingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchListingsResult> searchListingsAsync(SearchListingsRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchListingsRequest, SearchListingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchTypesResult> searchTypesAsync(SearchTypesRequest request) {

        return searchTypesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchTypesResult> searchTypesAsync(SearchTypesRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchTypesRequest, SearchTypesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SearchUserProfilesResult> searchUserProfilesAsync(SearchUserProfilesRequest request) {

        return searchUserProfilesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SearchUserProfilesResult> searchUserProfilesAsync(SearchUserProfilesRequest request,
            com.amazonaws.handlers.AsyncHandler<SearchUserProfilesRequest, SearchUserProfilesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartDataSourceRunResult> startDataSourceRunAsync(StartDataSourceRunRequest request) {

        return startDataSourceRunAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartDataSourceRunResult> startDataSourceRunAsync(StartDataSourceRunRequest request,
            com.amazonaws.handlers.AsyncHandler<StartDataSourceRunRequest, StartDataSourceRunResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartMetadataGenerationRunResult> startMetadataGenerationRunAsync(StartMetadataGenerationRunRequest request) {

        return startMetadataGenerationRunAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartMetadataGenerationRunResult> startMetadataGenerationRunAsync(StartMetadataGenerationRunRequest request,
            com.amazonaws.handlers.AsyncHandler<StartMetadataGenerationRunRequest, StartMetadataGenerationRunResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateDataSourceResult> updateDataSourceAsync(UpdateDataSourceRequest request) {

        return updateDataSourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateDataSourceResult> updateDataSourceAsync(UpdateDataSourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateDataSourceRequest, UpdateDataSourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateDomainResult> updateDomainAsync(UpdateDomainRequest request) {

        return updateDomainAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateDomainResult> updateDomainAsync(UpdateDomainRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateDomainRequest, UpdateDomainResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateEnvironmentResult> updateEnvironmentAsync(UpdateEnvironmentRequest request) {

        return updateEnvironmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateEnvironmentResult> updateEnvironmentAsync(UpdateEnvironmentRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateEnvironmentRequest, UpdateEnvironmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateEnvironmentProfileResult> updateEnvironmentProfileAsync(UpdateEnvironmentProfileRequest request) {

        return updateEnvironmentProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateEnvironmentProfileResult> updateEnvironmentProfileAsync(UpdateEnvironmentProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateEnvironmentProfileRequest, UpdateEnvironmentProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateGlossaryResult> updateGlossaryAsync(UpdateGlossaryRequest request) {

        return updateGlossaryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateGlossaryResult> updateGlossaryAsync(UpdateGlossaryRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateGlossaryRequest, UpdateGlossaryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateGlossaryTermResult> updateGlossaryTermAsync(UpdateGlossaryTermRequest request) {

        return updateGlossaryTermAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateGlossaryTermResult> updateGlossaryTermAsync(UpdateGlossaryTermRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateGlossaryTermRequest, UpdateGlossaryTermResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateGroupProfileResult> updateGroupProfileAsync(UpdateGroupProfileRequest request) {

        return updateGroupProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateGroupProfileResult> updateGroupProfileAsync(UpdateGroupProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateGroupProfileRequest, UpdateGroupProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request) {

        return updateProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateProjectRequest, UpdateProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSubscriptionGrantStatusResult> updateSubscriptionGrantStatusAsync(UpdateSubscriptionGrantStatusRequest request) {

        return updateSubscriptionGrantStatusAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSubscriptionGrantStatusResult> updateSubscriptionGrantStatusAsync(UpdateSubscriptionGrantStatusRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSubscriptionGrantStatusRequest, UpdateSubscriptionGrantStatusResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSubscriptionRequestResult> updateSubscriptionRequestAsync(UpdateSubscriptionRequestRequest request) {

        return updateSubscriptionRequestAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSubscriptionRequestResult> updateSubscriptionRequestAsync(UpdateSubscriptionRequestRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSubscriptionRequestRequest, UpdateSubscriptionRequestResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSubscriptionTargetResult> updateSubscriptionTargetAsync(UpdateSubscriptionTargetRequest request) {

        return updateSubscriptionTargetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSubscriptionTargetResult> updateSubscriptionTargetAsync(UpdateSubscriptionTargetRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSubscriptionTargetRequest, UpdateSubscriptionTargetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateUserProfileResult> updateUserProfileAsync(UpdateUserProfileRequest request) {

        return updateUserProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateUserProfileResult> updateUserProfileAsync(UpdateUserProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateUserProfileRequest, UpdateUserProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
